/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.YieldExpression;
import org.eclipse.php.internal.core.typeinference.Declaration;
import org.eclipse.php.internal.core.typeinference.GeneratorClassType;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.IPHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.evaluators.VariableReferenceEvaluator;

public class BindingUtility {
    private static final int TIME_LIMIT = 1000;
    private ISourceModule sourceModule;
    private ASTNode rootNode;
    private Map<SourceRange, IEvaluatedType> evaluatedTypesCache = new HashMap<SourceRange, IEvaluatedType>();
    private int timeLimit = 1000;
    private IModelAccessCache modelAccessCache;
    private IPHPTypeInferencer cachedInferencer = null;

    public BindingUtility(ISourceModule sourceModule) {
        this.sourceModule = sourceModule;
        this.rootNode = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
    }

    public BindingUtility(ISourceModule sourceModule, ASTNode rootNode) {
        this.sourceModule = sourceModule;
        this.rootNode = rootNode;
    }

    public BindingUtility(ISourceModule sourceModule, IModelAccessCache modelAccessCache) {
        this(sourceModule);
        this.modelAccessCache = modelAccessCache;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public IEvaluatedType getType(ASTNode node) throws ModelException {
        if (node == null) {
            throw new NullPointerException();
        }
        return this.getType(new SourceRange(node));
    }

    public IEvaluatedType getType(SourceRefElement element) throws ModelException {
        if (element == null) {
            throw new NullPointerException();
        }
        ISourceModule elementModule = element.getSourceModule();
        if (!elementModule.equals(this.sourceModule)) {
            throw new IllegalArgumentException("Unknown model element");
        }
        return this.getType(new SourceRange(element.getSourceRange()));
    }

    public IEvaluatedType getType(int startOffset, int length) throws ModelException {
        return this.getType(new SourceRange(startOffset, length));
    }

    protected IPHPTypeInferencer getTypeInferencer() {
        return this.cachedInferencer == null ? new PHPTypeInferencer() : this.cachedInferencer;
    }

    protected IEvaluatedType getType(SourceRange sourceRange, IContext context, ASTNode node) {
        return this.getTypeInferencer().evaluateType((AbstractTypeGoal)new ExpressionTypeGoal(context, node), this.timeLimit);
    }

    protected ContextFinder getContext(SourceRange sourceRange) throws ModelException {
        ContextFinder contextFinder = new ContextFinder(sourceRange);
        try {
            this.rootNode.traverse((ASTVisitor)contextFinder);
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e, 4);
        }
        if (contextFinder.getNode() == null) {
            throw new ModelException((Throwable)new IllegalArgumentException("AST node can not be found for the given source range: " + sourceRange), 4);
        }
        return contextFinder;
    }

    protected IEvaluatedType getType(SourceRange sourceRange) throws ModelException {
        if (!this.evaluatedTypesCache.containsKey(sourceRange)) {
            ContextFinder contextFinder = this.getContext(sourceRange);
            this.evaluatedTypesCache.put(sourceRange, this.getType(sourceRange, contextFinder.getContext(), contextFinder.getNode()));
        }
        return this.evaluatedTypesCache.get(sourceRange);
    }

    public IModelElement[] getModelElement(ASTNode node) throws ModelException {
        if (node == null) {
            throw new NullPointerException();
        }
        return this.getModelElement(new SourceRange(node), true);
    }

    public IModelElement[] getModelElement(SourceRefElement element) throws ModelException {
        if (element == null) {
            throw new NullPointerException();
        }
        ISourceModule elementModule = element.getSourceModule();
        if (!elementModule.equals(this.sourceModule)) {
            throw new IllegalArgumentException("Unknown model element");
        }
        return this.getModelElement(new SourceRange(element.getSourceRange()), true);
    }

    public IModelElement[] getModelElement(int startOffset, int length) throws ModelException {
        return this.getModelElement(startOffset, length, true);
    }

    public IModelElement[] getModelElement(int startOffset, int length, IModelAccessCache cache) throws ModelException {
        return this.getModelElement(startOffset, length, true, cache);
    }

    public IModelElement[] getModelElement(int startOffset, int length, boolean filter) throws ModelException {
        return this.getModelElement(new SourceRange(startOffset, length), filter);
    }

    public IModelElement[] getModelElement(int startOffset, int length, boolean filter, IModelAccessCache cache) throws ModelException {
        return this.getModelElement(new SourceRange(startOffset, length), filter, cache);
    }

    protected IModelElement[] getModelElement(SourceRange sourceRange, boolean filter) throws ModelException {
        return this.getModelElement(sourceRange, filter, null);
    }

    protected IModelElement[] getModelElement(SourceRange sourceRange, boolean filter, IModelAccessCache cache) throws ModelException {
        ContextFinder contextFinder = this.getContext(sourceRange);
        if (!this.evaluatedTypesCache.containsKey(sourceRange)) {
            this.evaluatedTypesCache.put(sourceRange, this.getType(sourceRange, contextFinder.getContext(), contextFinder.getNode()));
        }
        IEvaluatedType evaluatedType = this.evaluatedTypesCache.get(sourceRange);
        return PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)contextFinder.getContext(), sourceRange.getOffset(), cache);
    }

    public IModelElement getFieldByPosition(int start, int length) throws Exception {
        SourceRange sourceRange = new SourceRange(start, length);
        ContextFinder contextFinder = this.getContext(sourceRange);
        ASTNode node = contextFinder.getNode();
        if (node instanceof VariableReference) {
            ASTNode localScopeNode = this.rootNode;
            IContext context = contextFinder.getContext();
            if (context instanceof MethodContext) {
                localScopeNode = ((MethodContext)context).getMethodNode();
            }
            VariableReferenceEvaluator.LocalReferenceDeclSearcher varDecSearcher = new VariableReferenceEvaluator.LocalReferenceDeclSearcher(this.sourceModule, (VariableReference)node, localScopeNode);
            this.rootNode.traverse((ASTVisitor)varDecSearcher);
            Declaration[] decls = varDecSearcher.getDeclarations();
            if (decls != null && decls.length > 0) {
                return this.sourceModule.getElementAt(decls[0].getNode().sourceStart());
            }
        }
        return null;
    }

    public IEvaluatedType[] getFunctionReturnType(IMethod functionElement) {
        LinkedList yieldExpressions;
        LinkedList returnExpressions;
        LinkedList<Object> evaluated;
        ModuleDeclaration sourceModuleDeclaration;
        ISourceModule sourceModule;
        block15: {
            MethodDeclaration functionDeclaration;
            block14: {
                sourceModule = functionElement.getSourceModule();
                sourceModuleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                functionDeclaration = null;
                try {
                    functionDeclaration = PHPModelUtils.getNodeByMethod(sourceModuleDeclaration, functionElement);
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block14;
                    e.printStackTrace();
                }
            }
            evaluated = new LinkedList<Object>();
            returnExpressions = new LinkedList();
            yieldExpressions = new LinkedList();
            if (functionDeclaration != null) {
                final MethodDeclaration topDeclaration = functionDeclaration;
                Iterator visitor = new ASTVisitor(){

                    public boolean visitGeneral(ASTNode node) throws Exception {
                        if (node instanceof LambdaFunctionDeclaration && node != topDeclaration) {
                            return false;
                        }
                        if (node instanceof ReturnStatement) {
                            ReturnStatement statement = (ReturnStatement)node;
                            Expression expr = statement.getExpr();
                            if (expr == null) {
                                evaluated.add(PHPSimpleTypes.VOID);
                            } else {
                                returnExpressions.add(expr);
                            }
                        } else if (node instanceof YieldExpression) {
                            YieldExpression statement = (YieldExpression)node;
                            Expression expr = statement.getExpr();
                            yieldExpressions.add(expr);
                        }
                        return super.visitGeneral(node);
                    }
                };
                try {
                    functionDeclaration.traverse(visitor);
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block15;
                    e.printStackTrace();
                }
            }
        }
        for (Expression expr : returnExpressions) {
            SourceRange sourceRange = new SourceRange((ASTNode)expr);
            try {
                ContextFinder contextFinder = this.getContext(sourceRange);
                IContext context = contextFinder.getContext();
                IEvaluatedType resolvedExpression = PHPTypeInferenceUtils.resolveExpression(this.getTypeInferencer(), sourceModule, sourceModuleDeclaration, context, (ASTNode)expr);
                if (resolvedExpression == null) continue;
                evaluated.add(resolvedExpression);
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        if (yieldExpressions.size() > 0) {
            GeneratorClassType generator = new GeneratorClassType();
            for (Expression expr : yieldExpressions) {
                block16: {
                    if (expr == null) {
                        generator.getTypes().add(PHPSimpleTypes.NULL);
                    } else {
                        SourceRange sourceRange = new SourceRange((ASTNode)expr);
                        try {
                            ContextFinder contextFinder = this.getContext(sourceRange);
                            IContext context = contextFinder.getContext();
                            IEvaluatedType resolvedExpression = PHPTypeInferenceUtils.resolveExpression(this.getTypeInferencer(), sourceModule, sourceModuleDeclaration, context, (ASTNode)expr);
                            if (resolvedExpression == null) break block16;
                            generator.getTypes().add(resolvedExpression);
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) continue;
                            e.printStackTrace();
                            continue;
                        }
                    }
                }
                evaluated.add((Object)generator);
            }
        }
        return evaluated.toArray(new IEvaluatedType[evaluated.size()]);
    }

    public void setCachedInferencer(IPHPTypeInferencer cachedInferencer) {
        this.cachedInferencer = cachedInferencer;
    }

    private class ContextFinder
    extends org.eclipse.php.internal.core.typeinference.context.ContextFinder {
        private SourceRange sourceRange;
        private IContext context;
        private ASTNode node;

        public ContextFinder(SourceRange sourceRange) {
            super(BindingUtility.this.sourceModule);
            this.sourceRange = sourceRange;
        }

        @Override
        public IContext getContext() {
            if (this.context instanceof IModelCacheContext) {
                ((IModelCacheContext)this.context).setCache(BindingUtility.this.modelAccessCache);
            }
            return this.context;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node.sourceStart() > this.sourceRange.getEnd()) {
                return false;
            }
            if (node.sourceEnd() < this.sourceRange.offset) {
                return false;
            }
            if (node.sourceStart() <= this.sourceRange.offset && node.sourceEnd() >= this.sourceRange.getEnd() && !this.contextStack.isEmpty()) {
                this.context = (IContext)this.contextStack.peek();
                this.node = node;
            }
            return true;
        }
    }

    private class SourceRange {
        private final int offset;
        private final int length;

        public SourceRange(ISourceRange sourceRange) {
            this.offset = sourceRange.getOffset();
            this.length = sourceRange.getLength();
        }

        public SourceRange(int offset, int length) {
            this.length = length;
            this.offset = offset;
        }

        public SourceRange(ASTNode node) {
            this(node.sourceStart(), node.sourceEnd() - node.sourceStart());
        }

        public int getEnd() {
            return this.length + this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.offset;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceRange other = (SourceRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.offset == other.offset;
        }

        public String toString() {
            return "<offset=" + this.offset + ", length=" + this.length + ">";
        }
    }
}

