/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.typeinference.ArrayDeclaration;
import org.eclipse.php.internal.core.typeinference.Declaration;

public class DeclarationScope {
    private Map<String, LinkedList<Declaration>> decls = new HashMap<String, LinkedList<Declaration>>();
    private IContext context;
    private Stack<Statement> innerBlocks = new Stack();

    public DeclarationScope(IContext context) {
        this.context = context;
    }

    public IContext getContext() {
        return this.context;
    }

    public void enterInnerBlock(Statement s) {
        if (!this.innerBlocks.isEmpty() && this.innerBlocks.peek() == s) {
            return;
        }
        this.innerBlocks.push(s);
    }

    public void exitInnerBlock() {
        if (!this.innerBlocks.isEmpty()) {
            this.innerBlocks.pop();
        }
    }

    public int getInnerBlockLevel() {
        return this.innerBlocks.size();
    }

    public Map<String, LinkedList<Declaration>> getAllDeclarations() {
        return this.decls;
    }

    public Declaration[] getDeclarations(String varName) {
        LinkedList<Declaration> result = new LinkedList<Declaration>();
        LinkedList<Declaration> varDecls = this.decls.get(varName);
        if (varDecls != null) {
            for (Declaration decl : varDecls) {
                if (decl == null) continue;
                result.add(decl);
            }
        }
        return result.toArray(new Declaration[result.size()]);
    }

    public void addDeclaration(String varName, ASTNode declNode) {
        Declaration decl;
        LinkedList<Declaration> varDecls = this.decls.get(varName);
        if (varDecls == null) {
            varDecls = new LinkedList();
            this.decls.put(varName, varDecls);
        }
        int level = this.innerBlocks.size();
        while (varDecls.size() > level + 1) {
            varDecls.removeLast();
        }
        while (varDecls.size() < level) {
            varDecls.addLast(null);
        }
        if (declNode instanceof Assignment && ((Assignment)declNode).getVariable() instanceof ArrayVariableReference) {
            int index = varDecls.size() - 1;
            while (index >= 0) {
                Declaration decl2 = varDecls.get(index);
                if (decl2 instanceof ArrayDeclaration) {
                    ArrayDeclaration arrayDeclaration = (ArrayDeclaration)decl2;
                    arrayDeclaration.addDeclaration(declNode);
                    return;
                }
                --index;
            }
        }
        if (varDecls.size() > level && (decl = varDecls.get(level)) != null) {
            if (level > 0) {
                Statement block = (Statement)this.innerBlocks.get(level - 1);
                if (DeclarationScope.isInSameBlock(block, decl.getNode(), declNode)) {
                    decl.setNode(declNode);
                    return;
                }
            } else {
                if (decl instanceof ArrayDeclaration) {
                    decl = new Declaration(declNode instanceof GlobalStatement, declNode);
                    varDecls.set(level, decl);
                } else if (!(declNode instanceof Assignment) || !(((Assignment)declNode).getVariable() instanceof ArrayVariableReference)) {
                    decl.setNode(declNode);
                }
                return;
            }
        }
        if (declNode instanceof Assignment && ((Assignment)declNode).getValue() instanceof ArrayCreation) {
            varDecls.addLast(new ArrayDeclaration(declNode instanceof GlobalStatement, declNode));
        } else {
            varDecls.addLast(new Declaration(declNode instanceof GlobalStatement, declNode));
        }
    }

    public static boolean isInSameBlock(Statement block, ASTNode oldNode, ASTNode newNode) {
        if (block instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)block;
            Statement oldBlock = DeclarationScope.getBlock(ifStatement, oldNode);
            Statement newBlock = DeclarationScope.getBlock(ifStatement, newNode);
            if (oldBlock != null && oldBlock == newBlock) {
                return DeclarationScope.isInSameBlock(newBlock, oldNode, newNode);
            }
            return false;
        }
        return true;
    }

    private static Statement getBlock(IfStatement ifStatement, ASTNode node) {
        Statement falseStatement = ifStatement.getFalseStatement();
        Statement trueStatement = ifStatement.getTrueStatement();
        if (trueStatement != null && trueStatement.sourceStart() <= node.sourceStart() && trueStatement.sourceEnd() >= node.sourceEnd()) {
            return trueStatement;
        }
        if (falseStatement != null && falseStatement.sourceStart() <= node.sourceStart() && falseStatement.sourceEnd() >= node.sourceEnd()) {
            return falseStatement;
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Variable Declarations (").append(this.context).append("): \n\n");
        for (Map.Entry<String, LinkedList<Declaration>> entry : this.decls.entrySet()) {
            String varName = entry.getKey();
            buf.append(varName).append(" => { \n\n");
            LinkedList<Declaration> varDecls = entry.getValue();
            if (varDecls != null) {
                for (Declaration declNode : varDecls) {
                    buf.append(declNode.toString()).append(", \n\n");
                }
            }
            buf.append("}, \n\n");
        }
        return buf.toString();
    }
}

