/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.typeinference.PHPClassType;

public class PHPSimpleTypes {
    private static final Map<String, TypeInfo> SIMPLE_TYPES;
    public static final IEvaluatedType NUMBER;
    public static final IEvaluatedType BOOLEAN;
    public static final IEvaluatedType STRING;
    public static final IEvaluatedType OBJECT;
    public static final IEvaluatedType RESOURCE;
    public static final IEvaluatedType ARRAY;
    public static final IEvaluatedType VOID;
    public static final IEvaluatedType NULL;
    public static final IEvaluatedType MIXED;
    public static final IEvaluatedType CALLABLE;

    static {
        NUMBER = new SimpleType(1);
        BOOLEAN = new SimpleType(5);
        STRING = new SimpleType(0);
        OBJECT = new PHPClassType("object");
        RESOURCE = new PHPClassType("resource");
        ARRAY = new MultiTypeType();
        VOID = new SimpleType(6);
        NULL = new SimpleType(8);
        MIXED = new PHPClassType("mixed");
        CALLABLE = new PHPClassType("callable");
        SIMPLE_TYPES = new HashMap<String, TypeInfo>();
        SIMPLE_TYPES.put("array", new TypeInfo(ARRAY, PHPVersion.PHP5));
        SIMPLE_TYPES.put("bool", new TypeInfo(BOOLEAN, PHPVersion.PHP7_0));
        SIMPLE_TYPES.put("boolean", new TypeInfo(BOOLEAN, null));
        SIMPLE_TYPES.put("int", new TypeInfo(NUMBER, PHPVersion.PHP7_0));
        SIMPLE_TYPES.put("integer", new TypeInfo(NUMBER, null));
        SIMPLE_TYPES.put("float", new TypeInfo(NUMBER, PHPVersion.PHP7_0));
        SIMPLE_TYPES.put("double", new TypeInfo(NUMBER, null));
        SIMPLE_TYPES.put("number", new TypeInfo(NUMBER, null));
        SIMPLE_TYPES.put("string", new TypeInfo(STRING, PHPVersion.PHP7_0));
        SIMPLE_TYPES.put("resource", new TypeInfo(RESOURCE, null));
        SIMPLE_TYPES.put("object", new TypeInfo(OBJECT, null));
        SIMPLE_TYPES.put("void", new TypeInfo(VOID, null));
        SIMPLE_TYPES.put("null", new TypeInfo(NULL, null));
        SIMPLE_TYPES.put("mixed", new TypeInfo(MIXED, null));
        SIMPLE_TYPES.put("callable", new TypeInfo(CALLABLE, PHPVersion.PHP5_4));
    }

    public static IEvaluatedType fromString(String type) {
        return PHPSimpleTypes.fromStringCS(type.toLowerCase());
    }

    public static IEvaluatedType fromStringCS(String type) {
        TypeInfo typeInfo = SIMPLE_TYPES.get(type);
        if (typeInfo != null) {
            return typeInfo.type;
        }
        return null;
    }

    public static boolean isSimpleTypeCS(String type) {
        return SIMPLE_TYPES.containsKey(type);
    }

    public static boolean isSimpleType(String type) {
        return SIMPLE_TYPES.containsKey(type.toLowerCase());
    }

    public static boolean isHintable(String name, PHPVersion phpVersion) {
        TypeInfo typeInfo = SIMPLE_TYPES.get(name.toLowerCase());
        if (typeInfo != null) {
            return typeInfo.isHintable(phpVersion);
        }
        return false;
    }

    private static TypeInfo findInfo(IEvaluatedType type) {
        for (TypeInfo info : SIMPLE_TYPES.values()) {
            if (!info.type.equals(type)) continue;
            return info;
        }
        return null;
    }

    public static boolean isSimpleType(IEvaluatedType type) {
        return PHPSimpleTypes.findInfo(type) != null;
    }

    public static boolean isHintable(IEvaluatedType type, PHPVersion phpVersion) {
        TypeInfo info = PHPSimpleTypes.findInfo(type);
        if (info != null) {
            return info.isHintable(phpVersion);
        }
        return false;
    }

    private static class TypeInfo {
        public IEvaluatedType type;
        public PHPVersion hintableSince;

        public TypeInfo(IEvaluatedType type, PHPVersion hintableSince) {
            this.type = type;
            this.hintableSince = hintableSince;
        }

        public boolean isHintable() {
            return this.hintableSince != null;
        }

        public boolean isHintable(PHPVersion phpVersion) {
            if (!this.isHintable()) {
                return false;
            }
            if (phpVersion == null) {
                return true;
            }
            return this.hintableSince == phpVersion || this.hintableSince.isLessThan(phpVersion);
        }
    }
}

