/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;

public class IncludeStringHack {
    private static final Pattern DOUBLE_DOT_WITH_SLASH = Pattern.compile("\\.{2}([\\/])");
    private static final String DOUBLE_PIPE_WITH_SLASH_REPLACEMENT = "||$1";
    private static final Pattern DOUBLE_DOT_AT_END = Pattern.compile("\\.{2}$");
    private static final String DOUBLE_PIPE_AT_END_REPLACEMENT = "||";
    private static final Pattern SINGLE_DOT_WITH_SLASH = Pattern.compile("\\.{1}([\\/])");
    private static final String SINGLE_PIPE_WITH_SLASH_REPLACEMENT = "|$1";
    private static final Pattern SINGLE_DOT_AT_END = Pattern.compile("\\.{1}$");
    private static final String SINGLE_PIPE_AT_END_REPLACEMENT = "|";
    private static final Pattern DOUBLE_PIPE_WITH_SLASH = Pattern.compile("\\|{2}([\\/])");
    private static final String DOUBLE_DOT_WITH_SLASH_REPLACEMENT = "..$1";
    private static final Pattern DOUBLE_PIPE_AT_END = Pattern.compile("\\|{2}$");
    private static final String DOUBLE_DOT_AT_END_REPLACEMENT = "..";
    private static final Pattern SINGLE_PIPE_WITH_SLASH = Pattern.compile("\\|{1}([\\/])");
    private static final String SINGLE_DOT_WITH_SLASH_REPLACEMENT = ".$1";
    private static final Pattern SINGLE_PIPE_AT_END = Pattern.compile("\\|{1}$");
    private static final String SINGLE_DOT_AT_END_REPLACEMENT = ".";

    public static String hack(String includeString) {
        includeString = DOUBLE_DOT_WITH_SLASH.matcher(includeString).replaceAll(DOUBLE_PIPE_WITH_SLASH_REPLACEMENT);
        includeString = DOUBLE_DOT_AT_END.matcher(includeString).replaceAll(DOUBLE_PIPE_AT_END_REPLACEMENT);
        includeString = SINGLE_DOT_WITH_SLASH.matcher(includeString).replaceAll(SINGLE_PIPE_WITH_SLASH_REPLACEMENT);
        includeString = SINGLE_DOT_AT_END.matcher(includeString).replaceAll(SINGLE_PIPE_AT_END_REPLACEMENT);
        return includeString;
    }

    public static String unhack(String includeString) {
        includeString = DOUBLE_PIPE_WITH_SLASH.matcher(includeString).replaceAll(DOUBLE_DOT_WITH_SLASH_REPLACEMENT);
        includeString = DOUBLE_PIPE_AT_END.matcher(includeString).replaceAll(DOUBLE_DOT_AT_END_REPLACEMENT);
        includeString = SINGLE_PIPE_WITH_SLASH.matcher(includeString).replaceAll(SINGLE_DOT_WITH_SLASH_REPLACEMENT);
        includeString = SINGLE_PIPE_AT_END.matcher(includeString).replaceAll(SINGLE_DOT_AT_END_REPLACEMENT);
        return includeString;
    }

    public static boolean isHacked(IPath includePath) {
        int i = 0;
        while (i < includePath.segmentCount()) {
            if (includePath.segment(i).equals(SINGLE_PIPE_AT_END_REPLACEMENT) || includePath.segment(i).equals(DOUBLE_PIPE_AT_END_REPLACEMENT)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

