/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.function;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.refactoring.core.extract.function.ExtractFunctionRefactoring;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileInfo;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.eclipse.php.refactoring.core.test.TestProject;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class ExtractFunctionRefactoringTest
extends AbstractRefactoringTest {
    @PDTTList.Parameters
    public static String[] dirs = new String[]{"/resources/extractfunc/"};

    @Override
    protected TestProject getProject() {
        return new TestProject("RefactoringExtractFunc");
    }

    public ExtractFunctionRefactoringTest(String[] fileNames) {
        super(fileNames);
    }

    @Test
    public void test(String fileName) {
        PdttFileExt testFile = (PdttFileExt)((Object)this.filesMap.get(fileName));
        IFile file = this.project.findFile(testFile.getTestFiles().get(0).getName());
        IStructuredModel model = null;
        try {
            model = ExtractFunctionRefactoringTest.createUnManagedStructuredModelFor(file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        int start = Integer.valueOf((String)testFile.getConfig().get("start"));
        int length = Integer.valueOf((String)testFile.getConfig().get("length"));
        String visibility = (String)testFile.getConfig().get("visibility");
        ExtractFunctionRefactoring processor = new ExtractFunctionRefactoring(DLTKCore.createSourceModuleFrom((IFile)file), (IDocument)structuredDocument, start, length);
        if ("default".equals(visibility)) {
            processor.setVisibility(0);
        }
        if ("public".equals(visibility)) {
            processor.setVisibility(64);
        }
        if ("prvate".equals(visibility)) {
            processor.setVisibility(16);
        }
        if ("protected".equals(visibility)) {
            processor.setVisibility(32);
        }
        processor.setNewFunctionName((String)testFile.getConfig().get("newName"));
        this.checkInitCondition((Refactoring)processor);
        this.performChange((Refactoring)processor);
        this.checkTestResult(testFile, structuredDocument);
    }

    protected void checkTestResult(PdttFileExt testFile, IStructuredDocument structuredDocument) {
        List<FileInfo> files = testFile.getExpectedFiles();
        for (FileInfo expFile : files) {
            IFile file = this.project.findFile(expFile.getName());
            Assert.assertTrue((boolean)file.exists());
            String content = structuredDocument.get();
            String diff = PHPCoreTests.compareContentsIgnoreWhitespace((String)expFile.getContents(), (String)content);
            if (diff == null) continue;
            Assert.fail((String)diff);
        }
    }
}

