/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.variable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.refactoring.core.extract.variable.ExtractVariableRefactoring;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtractVariableRefactoringTest26642
extends AbstractRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("TestProject1");
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file = folder.getFile("ExtractVariableRefactoringTest26642.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php function tests ($oppp){  return $oppp;}$test = 123;$test1 = 124;echo $test;$test = \"test\" $paste = tests ($test);?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testExtract() {
        IStructuredModel model = null;
        try {
            model = ExtractVariableRefactoringTest26642.createUnManagedStructuredModelFor(this.file);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)model);
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        Assert.assertNotNull((Object)structuredDocument);
        try {
            ExtractVariableRefactoring processor = new ExtractVariableRefactoring(DLTKCore.createSourceModuleFrom((IFile)this.file), (IDocument)structuredDocument, 47, 0);
            processor.setNewVariableName("c");
            this.checkInitCondition((Refactoring)processor);
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Override
    protected void checkInitCondition(Refactoring processor) {
        try {
            RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((long)4L, (long)status.getSeverity());
        }
        catch (OperationCanceledException e1) {
            Assert.fail((String)e1.getMessage());
        }
        catch (CoreException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }
}

