/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.rename.RenameFunctionProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameFuncProcessorTestCase0027497
extends AbstractRenameRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1");
        this.file = this.project1.getFile("RenameFuncTest00274972.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php include \"src/RenameFuncTest0027497.php\"; foo274972(); ?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        IFolder folder = this.project1.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file = folder.getFile("RenameFuncTest0027497.php");
        source = new ByteArrayInputStream("<?php function foo274972(){}; ?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testRename() throws Exception {
        String content;
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 17;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameFunctionProcessor processor = new RenameFunctionProcessor(this.file, selectedNode);
        processor.setNewElementName("foo2749721");
        processor.setUpdateTextualMatches(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        IFile file = this.project1.getFile("src/RenameFuncTest0027497.php");
        Assert.assertTrue((boolean)file.exists());
        try {
            content = FileUtils.getContents(file);
            Assert.assertEquals((Object)"<?php function foo2749721(){}; ?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file = this.project1.getFile("RenameFuncTest00274972.php");
        Assert.assertTrue((boolean)file.exists());
        try {
            content = FileUtils.getContents(file);
            Assert.assertEquals((Object)"<?php include \"src/RenameFuncTest0027497.php\"; foo2749721(); ?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

