/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.coverage;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;

public class CodeCoveragePreferenceKeys {
    public static final String CODE_COVERAGE_COLUMNS = "org.eclipse.php.debug.uicode_coverage_column_widths";
    private static final int[] defaultWidth = new int[]{150, 100};

    public static IPreferenceStore getPreferenceStore() {
        return PHPDebugUIPlugin.getDefault().getPreferenceStore();
    }

    public static void initializeDefaultValues() {
        IPreferenceStore store = CodeCoveragePreferenceKeys.getPreferenceStore();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < defaultWidth.length) {
            buf.append(defaultWidth[i]);
            if (i < defaultWidth.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        store.setDefault(CODE_COVERAGE_COLUMNS, buf.toString());
    }

    private CodeCoveragePreferenceKeys() {
    }

    public static int[] getCodeCoverageColumnWidths() {
        String widthsString = CodeCoveragePreferenceKeys.getPreferenceStore().getString(CODE_COVERAGE_COLUMNS);
        String[] widthsArray = widthsString.split(",");
        int[] widths = new int[widthsArray.length];
        int i = 0;
        while (i < widthsArray.length) {
            widths[i] = Integer.parseInt(widthsArray[i]);
            if (widths[i] < 1) {
                widths[i] = defaultWidth[i];
            }
            ++i;
        }
        return widths;
    }

    public static void setCodeCoverageColumnWidths(int[] widths) {
        StringBuffer widthsBuffer = new StringBuffer();
        int i = 0;
        while (i < widths.length) {
            if (widthsBuffer.length() > 0) {
                widthsBuffer.append(",");
            }
            widthsBuffer.append(String.valueOf(widths[i]));
            ++i;
        }
        CodeCoveragePreferenceKeys.getPreferenceStore().setValue(CODE_COVERAGE_COLUMNS, widthsBuffer.toString());
    }
}

