/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.codemanipulation;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ImportContainer;
import org.eclipse.dltk.internal.core.ImportDeclaration;
import org.eclipse.dltk.internal.corext.util.Strings;
import org.eclipse.dltk.internal.ui.DLTKUIStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.IFunctionBinding;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ImportRewrite;
import org.eclipse.php.internal.core.ast.util.Signature;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.template.php.CodeTemplateContext;
import org.eclipse.php.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StubUtility {
    private static final String[] EMPTY = new String[0];
    private static final Set<String> VALID_TYPE_BODY_TEMPLATES = new HashSet<String>();
    public static final int STATIC_FIELD = 1;
    public static final int INSTANCE_FIELD = 2;
    public static final int CONSTANT_FIELD = 3;
    public static final int PARAMETER = 4;
    public static final int LOCAL = 5;

    static {
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.php.ui.editor.templates.php.codetemplates.classbody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.php.ui.editor.templates.php.codetemplates.interfacebody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.php.ui.editor.templates.php.codetemplates.enumbody");
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.php.ui.editor.templates.php.codetemplates.annotationbody");
    }

    public static MethodDeclaration createImplementationStub(@NonNull ISourceModule unit, NamespaceDeclaration namespace, ASTRewrite rewrite, ImportRewrite imports, IMethod method, boolean deferred) throws CoreException {
        FullyQualifiedReference returnType;
        Assert.isNotNull((Object)imports);
        Assert.isNotNull((Object)rewrite);
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.setModifier(StubUtility.getImplementationModifiers(ast, method, deferred));
        FunctionDeclaration func = ast.newFunctionDeclaration();
        func.setFunctionName(ast.newIdentifier(method.getElementName()));
        decl.setFunction(func);
        IParameter[] typeParams = method.getParameters();
        List typeParameters = decl.getFunction().formalParameters();
        ISourceModule sourceModule = method.getSourceModule();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        org.eclipse.dltk.ast.declarations.MethodDeclaration methodDeclaration = PHPModelUtils.getNodeByMethod((ModuleDeclaration)moduleDeclaration, (IMethod)method);
        List arguments = methodDeclaration.getArguments();
        boolean supportNullable = ProjectOptions.getPHPVersion((IModelElement)unit).isGreaterThan(PHPVersion.PHP7_0);
        Map<String, ImportDeclaration> importContainers = StubUtility.getImportContainer(method);
        String declaringNamespace = StubUtility.getDeclaringNamespace(method);
        if (typeParams != null) {
            int i = 0;
            while (i < typeParams.length) {
                String typeName;
                FormalParameter newTypeParam = ast.newFormalParameter();
                org.eclipse.php.core.compiler.ast.nodes.FormalParameter currTypeParam = (org.eclipse.php.core.compiler.ast.nodes.FormalParameter)arguments.get(i);
                IParameter curr = typeParams[i];
                if (currTypeParam.getParameterType() != null && (typeName = StubUtility.addImports(namespace, curr.getType(), declaringNamespace, importContainers, imports)) != null) {
                    String parameterType = curr.getType();
                    if (supportNullable && ((FullyQualifiedReference)currTypeParam.getParameterType()).isNullable()) {
                        parameterType = String.valueOf('?') + parameterType;
                    }
                    newTypeParam.setParameterType((Expression)ast.newIdentifier(parameterType));
                }
                newTypeParam.setParameterName((Expression)ast.newIdentifier(curr.getName()));
                if (curr.getDefaultValue() != null) {
                    newTypeParam.setDefaultValue((Expression)ast.newIdentifier(curr.getDefaultValue()));
                }
                typeParameters.add(newTypeParam);
                ++i;
            }
        }
        if ((returnType = (FullyQualifiedReference)((PHPMethodDeclaration)methodDeclaration).getReturnType()) != null && supportNullable) {
            String returnTypeName = returnType.getName();
            if (returnType.isNullable()) {
                returnTypeName = String.valueOf('?') + returnTypeName;
            }
            func.setReturnType(ast.newIdentifier(returnTypeName));
            StubUtility.addImports(namespace, returnType.getName(), declaringNamespace, importContainers, imports);
        }
        if (!deferred) {
            Block body = ast.newBlock();
            func.setBody(body);
        }
        return decl;
    }

    private static String getDeclaringNamespace(IMethod method) {
        IType namespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
        if (namespace != null) {
            return namespace.getElementName();
        }
        return "";
    }

    private static int getImplementationModifiers(AST ast, IMethod method, boolean deferred) throws ModelException {
        int modifiers = method.getFlags() & 0xFFFFFFFE & 0xFFFFFFEF;
        if (deferred) {
            modifiers &= 0xFFFFFFDF;
            modifiers |= 0x40;
        }
        return modifiers;
    }

    private static Map<String, ImportDeclaration> getImportContainer(IMethod method) throws ModelException {
        HashMap<String, ImportDeclaration> importContainers = new HashMap<String, ImportDeclaration>();
        ImportContainersFinder finder = new ImportContainersFinder(importContainers);
        method.getSourceModule().accept((IModelElementVisitor)finder);
        return importContainers;
    }

    private static String addImports(NamespaceDeclaration namespace, String typeName, String declaringNamespace, Map<String, ImportDeclaration> importContainers, ImportRewrite imports) {
        if (PHPSimpleTypes.isSimpleType((String)typeName)) {
            return typeName;
        }
        ImportDeclaration importDeclaration = importContainers.get(typeName);
        if (importDeclaration != null) {
            typeName = importDeclaration.getElementName();
        } else if (typeName != null && declaringNamespace != null && !declaringNamespace.equals("")) {
            typeName = String.valueOf(declaringNamespace) + '\\' + typeName;
        }
        if (typeName != null) {
            imports.addImport(namespace, typeName);
            return typeName;
        }
        return null;
    }

    public static String getMethodBodyContent(boolean isConstructor, IScriptProject project, String destTypeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateName = isConstructor ? "org.eclipse.php.ui.editor.templates.php.codetemplates.constructorbody" : "org.eclipse.php.ui.editor.templates.php.codetemplates.methodbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("body_statement", bodyStatement);
        String str = StubUtility.evaluateTemplate(context, template, new String[]{"body_statement"});
        if (str == null && !Strings.containsOnlyWhitespaces((String)bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getGetterMethodBodyContent(IScriptProject project, String destTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.php.ui.editor.templates.php.codetemplates.getterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterMethodBodyContent(IScriptProject project, String destTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.php.ui.editor.templates.php.codetemplates.setterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCatchBodyContent(IScriptProject sp, String exceptionType, String variableName, String enclosingType, String enclosingMethod, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.php.ui.editor.templates.php.codetemplates.catchblock", sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelimiter);
        context.setVariable("enclosing_type", enclosingType);
        context.setVariable("enclosing_method", enclosingMethod);
        context.setVariable("exception_type", exceptionType);
        context.setVariable("exception_var", variableName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCompilationUnitContent(IScriptProject sp, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.php.ui.editor.templates.php.codetemplates.newtype", sp);
        if (template == null) {
            return null;
        }
        IScriptProject project = sp;
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", sp.getElementName());
        String[] fullLine = new String[]{"package_declaration", "filecomment", "typecomment"};
        return StubUtility.evaluateTemplate(context, template, fullLine);
    }

    public static String getFileComment(ISourceModule sm, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.php.ui.editor.templates.php.codetemplates.filecomment", sm.getScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sm.getScriptProject(), lineDelimiter);
        context.setVariable("file_name", sm.getElementName());
        context.setVariable("project_name", sm.getScriptProject().getElementName());
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getFileComment(IScriptProject sp, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.php.ui.editor.templates.php.codetemplates.filecomment", sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelimiter);
        context.setVariable("file_name", sp.getElementName());
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getTypeComment(IScriptProject sp, String typeQualifiedName, String[] typeParameterNames, String lineDelim) throws CoreException {
        TemplateBuffer buffer;
        Template template = StubUtility.getCodeTemplate("org.eclipse.php.ui.editor.templates.php.codetemplates.typecomment", sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelim);
        context.setVariable("enclosing_type", Signature.getQualifier((String)typeQualifiedName));
        context.setVariable("type_name", Signature.getSimpleName((String)typeQualifiedName));
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        int[] tagOffsets = position.getOffsets();
        int i = tagOffsets.length - 1;
        while (i >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, tagOffsets[i], position.getLength(), EMPTY, null, typeParameterNames, false, lineDelim, null);
            }
            catch (BadLocationException e) {
                throw new CoreException(DLTKUIStatus.createError((int)4, (Throwable)e));
            }
            --i;
        }
        return document.get();
    }

    public static String[] getParameterTypeNamesForSeeTag(IFunctionBinding binding) {
        ITypeBinding[] typeParametersTypes = binding.getParameterTypes();
        String[] typeParameterNames = null;
        if (typeParametersTypes != null) {
            typeParameterNames = new String[typeParametersTypes.length];
            int i = 0;
            ITypeBinding[] iTypeBindingArray = typeParametersTypes;
            int n = typeParametersTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding type = iTypeBindingArray[n2];
                typeParameterNames[i++] = type.getName();
                ++n2;
            }
        }
        return typeParameterNames;
    }

    private static String[] getParameterTypeNamesForSeeTag(IMethod overridden) throws ModelException {
        try {
            Program program = SharedASTProvider.getAST(overridden.getSourceModule(), SharedASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            ASTNode elementAt = program != null ? program.getElementAt(overridden.getSourceRange().getOffset()) : null;
            IMethodBinding resolvedBinding = null;
            if (elementAt instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)elementAt;
                resolvedBinding = methodDeclaration.resolveMethodBinding();
            } else if (elementAt instanceof FunctionDeclaration) {
                FunctionDeclaration functionDeclaration = (FunctionDeclaration)elementAt;
                resolvedBinding = functionDeclaration.resolveFunctionBinding();
            }
            if (resolvedBinding != null) {
                return StubUtility.getParameterTypeNamesForSeeTag((IFunctionBinding)resolvedBinding);
            }
        }
        catch (IOException e) {
            PHPUiPlugin.log(e);
        }
        String[] paramTypes = overridden.getParameterNames();
        String[] paramTypeNames = new String[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypeNames[i] = Signature.toString((String)Signature.getTypeErasure((String)paramTypes[i]));
            ++i;
        }
        return paramTypeNames;
    }

    private static String getSeeTag(String declaringClassQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        StringBuilder buf = new StringBuilder();
        buf.append("@see ");
        buf.append(declaringClassQualifiedName);
        buf.append("::");
        buf.append(methodName);
        buf.append('(');
        if (parameterTypesQualifiedNames != null) {
            int i = 0;
            while (i < parameterTypesQualifiedNames.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(parameterTypesQualifiedNames[i]);
                ++i;
            }
        }
        buf.append(')');
        return buf.toString();
    }

    public static String[] getTypeParameterNames(String[] typeParameters) {
        String[] typeParametersNames = new String[typeParameters.length];
        int i = 0;
        while (i < typeParameters.length) {
            typeParametersNames[i] = typeParameters[i];
            ++i;
        }
        return typeParametersNames;
    }

    public static String getTypeBody(String templateID, IScriptProject sp, String typeName, String lineDelim) throws CoreException {
        if (!VALID_TYPE_BODY_TEMPLATES.contains(templateID)) {
            throw new IllegalArgumentException("Invalid code template ID: " + templateID);
        }
        Template template = StubUtility.getCodeTemplate(templateID, sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelim);
        context.setVariable("type_name", typeName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getMethodComment(IScriptProject sp, String typeName, String methodName, String[] paramNames, String retTypeSig, String[] typeParameterNames, IMethod target, boolean delegate, String lineDelimiter, List<String> newExceptions) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "org.eclipse.php.ui.editor.templates.php.codetemplates.methodcomment";
        if (target != null) {
            templateName = delegate ? "org.eclipse.php.ui.editor.templates.php.codetemplates.delegatecomment" : "org.eclipse.php.ui.editor.templates.php.codetemplates.overridecomment";
        } else if (retTypeSig == null && typeName != null && (typeName.equals(methodName) || "constructor".equals(methodName))) {
            templateName = "org.eclipse.php.ui.editor.templates.php.codetemplates.constructorcomment";
        }
        Template template = StubUtility.getCodeTemplate(templateName, sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelimiter);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", retTypeSig);
        }
        if (target != null) {
            String targetTypeName = target.getDeclaringType().getTypeQualifiedName(PHPModelUtils.ENCLOSING_TYPE_SEPARATOR);
            if (targetTypeName.indexOf(PHPModelUtils.ENCLOSING_TYPE_SEPARATOR) > 0) {
                targetTypeName = String.valueOf(PHPModelUtils.ENCLOSING_TYPE_SEPARATOR) + targetTypeName;
            }
            String[] targetParamTypeNames = StubUtility.getParameterTypeNamesForSeeTag(target);
            if (delegate) {
                context.setVariable("see_to_target", StubUtility.getSeeTag(targetTypeName, methodName, targetParamTypeNames));
            } else {
                context.setVariable("see_to_overridden", StubUtility.getSeeTag(targetTypeName, methodName, targetParamTypeNames));
            }
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        int[] tagOffsets = position.getOffsets();
        int i = tagOffsets.length - 1;
        while (i >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, tagOffsets[i], position.getLength(), paramNames, retTypeSig, typeParameterNames, false, lineDelimiter, newExceptions);
            }
            catch (BadLocationException e) {
                throw new CoreException(DLTKUIStatus.createError((int)4, (Throwable)e));
            }
            --i;
        }
        return document.get();
    }

    private static String fixEmptyVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = StubUtility.findVariable(buffer, variables[i]);
            if (position != null && position.getLength() <= 0) {
                int[] offsets = position.getOffsets();
                int k = 0;
                while (k < offsets.length) {
                    int line = doc.getLineOfOffset(offsets[k]);
                    IRegion lineInfo = doc.getLineInformation(line);
                    int offset = lineInfo.getOffset();
                    String str = doc.get(offset, lineInfo.getLength());
                    if (Strings.containsOnlyWhitespaces((String)str) && nLines > line + 1 && removedLines.add(line)) {
                        int nextStart = doc.getLineOffset(line + 1);
                        edit.addChild((TextEdit)new DeleteEdit(offset, nextStart - offset));
                    }
                    ++k;
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    public static String getFieldComment(IScriptProject sp, String fieldType, String fieldName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.php.ui.editor.templates.php.codetemplates.fieldcomment", sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelimiter);
        context.setVariable("field_type", fieldType);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getMultipleFieldsComment(IScriptProject sp, String[] fieldTypes, String[] fieldNames, String lineDelim) throws CoreException {
        TemplateBuffer buffer;
        Template template = StubUtility.getCodeTemplate("org.eclipse.php.ui.editor.templates.php.codetemplates.multifieldcomment", sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelim);
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        int[] tagOffsets = position.getOffsets();
        int i = tagOffsets.length - 1;
        while (i >= 0) {
            try {
                StubUtility.insertVarTags((IDocument)document, tagOffsets[i], position.getLength(), fieldNames, fieldTypes, lineDelim);
            }
            catch (BadLocationException e) {
                throw new CoreException(DLTKUIStatus.createError((int)4, (Throwable)e));
            }
            --i;
        }
        return document.get();
    }

    public static String getSetterComment(IScriptProject sp, String typeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.php.ui.editor.templates.php.codetemplates.settercomment";
        Template template = StubUtility.getCodeTemplate(templateName, sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelimiter);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getGetterComment(IScriptProject sp, String typeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.php.ui.editor.templates.php.codetemplates.gettercomment";
        Template template = StubUtility.getCodeTemplate(templateName, sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelimiter);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        return str;
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = StubUtility.fixEmptyVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces((String)str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertVarTags(IDocument textBuffer, int offset, int length, String[] fieldNames, String[] fieldTypes, String lineDelimiter) throws BadLocationException {
        int prevLine;
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < fieldNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@var ").append(fieldTypes[i]).append(' ').append(fieldNames[i]);
            ++i;
        }
        if (buf.length() == 0 && StubUtility.isAllCommentWhitespace(lineStart) && (prevLine = textBuffer.getLineOfOffset(offset) - 1) > 0) {
            IRegion prevRegion = textBuffer.getLineInformation(prevLine);
            int prevLineEnd = prevRegion.getOffset() + prevRegion.getLength();
            textBuffer.replace(prevLineEnd, offset + length - prevLineEnd, "");
            return;
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, String[] paramNames, String returnType, String[] typeParameterNames, boolean isDeprecated, String lineDelimiter, List<String> newExceptions) throws BadLocationException {
        int prevLine;
        int i;
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuilder buf = new StringBuilder();
        if (typeParameterNames != null) {
            i = 0;
            while (i < typeParameterNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@param <").append(typeParameterNames[i]).append('>');
                ++i;
            }
        }
        if (paramNames != null) {
            i = 0;
            while (i < paramNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@param ").append(paramNames[i]);
                ++i;
            }
        }
        if (newExceptions != null) {
            for (String exception : newExceptions) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@throws ").append(exception);
            }
        }
        if (returnType != null && !returnType.equals("void")) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@return ").append(returnType);
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@deprecated");
        }
        if (buf.length() == 0 && StubUtility.isAllCommentWhitespace(lineStart) && (prevLine = textBuffer.getLineOfOffset(offset) - 1) > 0) {
            IRegion prevRegion = textBuffer.getLineInformation(prevLine);
            int prevLineEnd = prevRegion.getOffset() + prevRegion.getLength();
            textBuffer.replace(prevLineEnd, offset + length - prevLineEnd, "");
            return;
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isAllCommentWhitespace(String lineStart) {
        int i = 0;
        while (i < lineStart.length()) {
            char ch = lineStart.charAt(i);
            if (!Character.isWhitespace(ch) && ch != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getLineDelimiterUsed(IScriptProject project) {
        return StubUtility.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IScriptProject project) {
        if (project == null) {
            assert (false);
            return null;
        }
        String lineDelimiter = StubUtility.getLineDelimiterPreference(project);
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IScriptProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static void setCodeTemplate(String templateId, String pattern, IScriptProject project) {
        TemplateStore codeTemplateStore = PHPUiPlugin.getDefault().getCodeTemplateStore();
        TemplatePersistenceData data = codeTemplateStore.getTemplateData(templateId);
        Template orig = data.getTemplate();
        Template copy = new Template(orig.getName(), orig.getDescription(), orig.getContextTypeId(), pattern, true);
        data.setTemplate(copy);
    }

    private static Template getCodeTemplate(String id, IScriptProject sp) {
        if (sp == null) {
            return PHPUiPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(sp.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            PHPUiPlugin.log(e);
        }
        return projectStore.findTemplateById(id);
    }

    private static class ImportContainersFinder
    implements IModelElementVisitor {
        Map<String, ImportDeclaration> importContainers;

        public ImportContainersFinder(Map<String, ImportDeclaration> importContainers) {
            this.importContainers = importContainers;
        }

        public boolean visit(IModelElement element) {
            if (element instanceof ImportContainer) {
                try {
                    IModelElement[] iModelElementArray = ((ImportContainer)element).getChildren();
                    int n = iModelElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelElement ele = iModelElementArray[n2];
                        if (!this.importContainers.containsKey(ele.getElementName())) {
                            this.importContainers.put(PHPModelUtils.extractElementName((String)ele.getElementName()), (ImportDeclaration)ele);
                        }
                        ++n2;
                    }
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                }
                return false;
            }
            return true;
        }
    }
}

