/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.test;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.Activator;
import org.eclipse.php.refactoring.core.test.FileInfo;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.eclipse.php.refactoring.core.test.TestProject;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=PDTTList.class)
public abstract class AbstractPDTTListRefactoringTest
extends AbstractRefactoringTest {
    protected String[] fileNames = null;
    protected final TestProject project;
    protected Map<String, PdttFileExt> filesMap = new LinkedHashMap<String, PdttFileExt>();

    public AbstractPDTTListRefactoringTest(String[] fileNames) {
        this.project = this.createProject();
        this.fileNames = fileNames;
    }

    private TestProject createProject() {
        return new TestProject();
    }

    @PDTTList.BeforeList
    public void setUpListSuite() throws Exception {
        this.initFiles(this.fileNames);
    }

    @PDTTList.AfterList
    public void tearDownListSuite() throws Exception {
        this.project.delete();
    }

    protected void initFiles(String[] fileNames) throws Exception {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            PdttFileExt pdttFile = new PdttFileExt(AbstractPDTTListRefactoringTest.getBundle(), fileName);
            for (FileInfo testFile : pdttFile.getTestFiles()) {
                this.project.createFile(testFile.getName(), this.getContents(pdttFile, testFile));
            }
            this.filesMap.put(fileName, pdttFile);
            ++n2;
        }
        TestUtils.waitForIndexer();
    }

    protected String getContents(PdttFileExt pdttFile, FileInfo testFile) {
        String data = testFile.getContents();
        int offset = data.lastIndexOf(124);
        if (offset < 0) {
            return data;
        }
        pdttFile.getConfig().put("start", String.valueOf(offset));
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        return data;
    }

    protected void checkTestResult(PdttFileExt pdttFile) {
        TestUtils.waitForIndexer();
        List<FileInfo> files = pdttFile.getExpectedFiles();
        for (FileInfo expFile : files) {
            IFile file = this.project.findFile(expFile.getName());
            Assert.assertTrue((boolean)file.exists());
            try {
                PDTTUtils.assertContents((String)this.getContents(pdttFile, expFile), (String)FileUtils.getContents(file));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @AbstractPDTTRunner.Context
    public static Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }
}

