/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.ast.nodes.TraitUseStatement;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.compiler.ast.parser.AbstractPHPSourceParser;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPSourceParserFactory;
import org.eclipse.php.internal.core.compiler.ast.visitor.TraitUseStatementVisitor;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class TraitUseStatementVisitorTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private AbstractPHPSourceParser parser;

    static {
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/astutils/trait_use_statement_visitor/php54"});
    }

    public TraitUseStatementVisitorTests(PHPVersion phpVersion, String[] fileName) {
        this.parser = PHPSourceParserFactory.createParser((PHPVersion)phpVersion);
    }

    @Test
    public void traitUse(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdttFile.getFile().trim().getBytes());
        ModuleDeclaration moduleDeclaration = (ModuleDeclaration)this.parser.parse((Reader)new InputStreamReader(inputStream), null, ProjectOptions.useShortTags(null));
        final StringBuilder builder = new StringBuilder();
        moduleDeclaration.traverse((ASTVisitor)new TraitUseStatementVisitor(){

            public boolean visit(TraitUseStatement s) throws Exception {
                builder.append(s);
                return false;
            }
        });
        String actual = builder.toString();
        String expected = pdttFile.getExpected();
        PDTTUtils.assertContents(expected, actual);
    }
}

