/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.locator.NodeFinder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class AbstractConciliatorTest {
    protected static IProject project;
    protected static PHPVersion phpVersion;
    protected IFile file;

    static {
        phpVersion = null;
    }

    @BeforeClass
    public static void setUpSuite() throws Exception {
        project = phpVersion != null ? AbstractConciliatorTest.createProject("projectConciliator", phpVersion) : AbstractConciliatorTest.createProject("projectConciliator");
    }

    @AfterClass
    public static void tearDownSuite() throws Exception {
        TestUtils.deleteProject(project);
    }

    public static IProject createProject(String name) {
        IProject project = TestUtils.createProject(name);
        try {
            project.build(6, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        TestUtils.waitForIndexer();
        return project;
    }

    public static IProject createProject(String name, PHPVersion version) {
        IProject project = TestUtils.createProject(name);
        try {
            TestUtils.setProjectPHPVersion(project, version);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        TestUtils.waitForIndexer();
        return project;
    }

    @After
    public void tearDown() {
        TestUtils.deleteFile(this.file);
    }

    public Program createProgramFromSource(IFile file) throws Exception {
        ISourceModule source = DLTKCore.createSourceModuleFrom((IFile)file);
        return this.createProgramFromSource(source);
    }

    public Program createProgramFromSource(ISourceModule source) throws Exception {
        IResource resource = source.getResource();
        IProject project = null;
        if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        }
        PHPVersion version = project != null ? ProjectOptions.getPHPVersion((IProject)project) : ProjectOptions.getDefaultPHPVersion();
        ASTParser newParser = ASTParser.newParser((PHPVersion)version, (ISourceModule)source);
        return newParser.createAST(null);
    }

    protected void setFileContent(String content) {
        this.file = TestUtils.createFile(project, "test.php", content);
        TestUtils.waitForIndexer();
    }

    protected Program createProgram(IFile file) {
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        Program program = null;
        try {
            program = this.createProgramFromSource(sourceModule);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return program;
    }

    protected ASTNode locateNode(Program program, int start, int end) {
        ASTNode locateNode = NodeFinder.perform((ASTNode)program, start, end);
        return locateNode;
    }
}

