/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import java_cup.runtime.lr_parser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.DefaultBindingResolver;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.util.Util;

public class ASTParser {
    private final AST ast;
    private final ISourceModule sourceModule;

    private ASTParser(Reader reader, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags) throws IOException {
        this(reader, phpVersion, useASPTags, useShortTags, null);
    }

    private ASTParser(Reader reader, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags, ISourceModule sourceModule) throws IOException {
        this.sourceModule = sourceModule;
        this.ast = new AST(reader, phpVersion, useASPTags, useShortTags);
        this.ast.setDefaultNodeFlag(2);
        if (sourceModule != null) {
            this.ast.setFlag(Integer.MIN_VALUE);
            this.ast.setBindingResolver(new DefaultBindingResolver(sourceModule, sourceModule.getOwner()));
        }
    }

    public static ASTParser newParser(PHPVersion version, boolean useShortTags) {
        try {
            return new ASTParser(new StringReader(""), version, false, useShortTags);
        }
        catch (IOException iOException) {
            assert (false);
            return null;
        }
    }

    public static ASTParser newParser(PHPVersion version) {
        return ASTParser.newParser(version, true);
    }

    public static ASTParser newParser(ISourceModule sourceModule) {
        PHPVersion phpVersion = ProjectOptions.getPHPVersion(sourceModule.getScriptProject().getProject());
        return ASTParser.newParser(phpVersion, sourceModule);
    }

    public static ASTParser newParser(PHPVersion version, ISourceModule sourceModule) {
        if (sourceModule == null) {
            throw new IllegalStateException("ASTParser - Can't parser with null ISourceModule");
        }
        try {
            ASTParser parser = new ASTParser(new StringReader(""), version, false, ProjectOptions.useShortTags(sourceModule.getScriptProject().getProject()), sourceModule);
            parser.setSource(sourceModule.getSourceAsCharArray());
            return parser;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useShortTags) throws IOException {
        return new ASTParser(reader, version, false, useShortTags);
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useASPTags, boolean useShortTags) throws IOException {
        return new ASTParser(reader, version, useASPTags, useShortTags);
    }

    public static ASTParser newParser(Reader reader, PHPVersion version, boolean useASPTags, ISourceModule sourceModule) throws IOException {
        return new ASTParser(reader, version, useASPTags, ProjectOptions.useShortTags(sourceModule.getScriptProject().getProject()), sourceModule);
    }

    public void setSource(char[] source) throws IOException {
        CharArrayReader charArrayReader = new CharArrayReader(source);
        this.setSource(charArrayReader);
    }

    public void setSource(Reader source) throws IOException {
        this.ast.setSource(source);
    }

    public void setSource(ISourceModule sourceModule) throws IOException, ModelException {
        this.ast.setSource(new CharArrayReader(sourceModule.getSourceAsCharArray()));
    }

    public Program createAST(IProgressMonitor progressMonitor) throws Exception {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask("Creating Abstract Syntax Tree for source...", 3);
        AstLexer lexer = this.ast.lexer();
        lr_parser phpParser = this.ast.parser();
        progressMonitor.worked(1);
        phpParser.setScanner((Scanner)lexer);
        progressMonitor.worked(2);
        Symbol symbol = phpParser.parse();
        progressMonitor.done();
        if (symbol == null || !(symbol.value instanceof Program)) {
            return null;
        }
        Program p = (Program)symbol.value;
        AST ast = p.getAST();
        p.setSourceModule(this.sourceModule);
        if (this.sourceModule != null) {
            p.setLineEndTable(Util.lineEndTable((IDocument)new Document(this.sourceModule.getSource())));
        }
        ast.setDefaultNodeFlag(0);
        ast.setOriginalModificationCount(ast.modificationCount());
        return p;
    }
}

