/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.List;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.visitor.Visitor;

public class TraitDeclaration
extends ClassDeclaration {
    public TraitDeclaration(int start, int end, AST ast, int modifier, Identifier className, Expression superClass, List<Identifier> interfaces, Block body) {
        super(start, end, ast, modifier, className, superClass, interfaces, body);
    }

    public TraitDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        if (!(other instanceof TraitDeclaration)) {
            return false;
        }
        return super.subtreeMatch(matcher, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Block body = ASTNode.copySubtree(target, this.getBody());
        int modifier = this.getModifier();
        Identifier name = ASTNode.copySubtree(target, this.getName());
        TraitDeclaration result = new TraitDeclaration(this.getStart(), this.getEnd(), target, modifier, name, this.getName(), this.interfaces(), body);
        return result;
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TraitDeclaration");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append(tab).append("\t").append("<TraitName>\n");
        this.getName().toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("\t").append("</TraitName>\n");
        this.getBody().toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</TraitDeclaration>");
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }
}

