/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.FixedAnswerEvaluator;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.php.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.core.compiler.ast.nodes.BackTickExpression;
import org.eclipse.php.core.compiler.ast.nodes.CastExpression;
import org.eclipse.php.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.compiler.ast.nodes.CloneExpression;
import org.eclipse.php.core.compiler.ast.nodes.ConditionalExpression;
import org.eclipse.php.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameterByReference;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.core.compiler.ast.nodes.InstanceOfExpression;
import org.eclipse.php.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PostfixExpression;
import org.eclipse.php.core.compiler.ast.nodes.PrefixExpression;
import org.eclipse.php.core.compiler.ast.nodes.Quote;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.compiler.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.evaluators.ArrayCreationEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.ArrayDeclarationGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.ArrayVariableReferenceEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.AssignmentEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.CastEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.CatchClauseEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.ClassVariableDeclarationEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.CloneEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.ConditionalExpressionEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.ConstantDeclarationEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.FieldAccessEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.ForeachStatementEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.FormalParameterEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.GlobalVariableReferencesEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.InfixExpressionEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.InstanceCreationEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.IteratorTypeGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.MethodCallTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.MethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPClassEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PostfixExpressionEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PrefixExpressionEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.ScalarEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.StaticConstantAccessEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.TypeReferenceEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.UnaryOperationEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.VariableReferenceEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.phpdoc.PHPDocClassVariableEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.phpdoc.PHPDocMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.ArrayDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.ConstantDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.ForeachStatementGoal;
import org.eclipse.php.internal.core.typeinference.goals.GlobalVariableReferencesGoal;
import org.eclipse.php.internal.core.typeinference.goals.IteratorTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;

public class DefaultPHPGoalEvaluatorFactory
implements IGoalEvaluatorFactory {
    public GoalEvaluator createEvaluator(IGoal goal) {
        Class<?> goalClass = goal.getClass();
        if (goalClass == ExpressionTypeGoal.class) {
            ExpressionTypeGoal exprGoal = (ExpressionTypeGoal)goal;
            return this.createExpressionEvaluator(exprGoal);
        }
        if (goalClass == MethodElementReturnTypeGoal.class) {
            return new MethodReturnTypeEvaluator(goal);
        }
        if (goalClass == PHPDocMethodReturnTypeGoal.class) {
            return new PHPDocMethodReturnTypeEvaluator(goal);
        }
        if (goalClass == GlobalVariableReferencesGoal.class) {
            return new GlobalVariableReferencesEvaluator(goal);
        }
        if (goalClass == ClassVariableDeclarationGoal.class) {
            return new ClassVariableDeclarationEvaluator(goal);
        }
        if (goalClass == PHPDocClassVariableGoal.class) {
            return new PHPDocClassVariableEvaluator(goal);
        }
        if (goalClass == ConstantDeclarationGoal.class) {
            return new ConstantDeclarationEvaluator(goal);
        }
        if (goalClass == ForeachStatementGoal.class) {
            return new ForeachStatementEvaluator(goal);
        }
        if (goalClass == ArrayDeclarationGoal.class) {
            return new ArrayDeclarationGoalEvaluator(goal);
        }
        if (goalClass == IteratorTypeGoal.class) {
            return new IteratorTypeGoalEvaluator(goal);
        }
        return null;
    }

    private GoalEvaluator createExpressionEvaluator(ExpressionTypeGoal exprGoal) {
        TraitAliasStatement tas;
        ASTNode expression = exprGoal.getExpression();
        Class<?> expressionClass = expression.getClass();
        if (expressionClass == InterfaceDeclaration.class || expressionClass == ClassDeclaration.class || expressionClass == TraitDeclaration.class) {
            return new PHPClassEvaluator((IGoal)exprGoal, (TypeDeclaration)expression);
        }
        if (expressionClass == Assignment.class) {
            return new AssignmentEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == Scalar.class) {
            Scalar scalar = (Scalar)expression;
            return new ScalarEvaluator((IGoal)exprGoal, scalar);
        }
        if (expressionClass == TypeReference.class || expressionClass == FullyQualifiedReference.class) {
            TypeReference type = (TypeReference)expression;
            return new TypeReferenceEvaluator((IGoal)exprGoal, type);
        }
        if (expressionClass == TraitAliasStatement.class && (tas = (TraitAliasStatement)expression).getAlias().getTraitMethod() instanceof FullyQualifiedTraitMethodReference) {
            FullyQualifiedTraitMethodReference reference = (FullyQualifiedTraitMethodReference)tas.getAlias().getTraitMethod();
            return new TypeReferenceEvaluator((IGoal)exprGoal, reference.getClassName());
        }
        if (expressionClass == PHPCallExpression.class || expressionClass == StaticMethodInvocation.class) {
            return new MethodCallTypeEvaluator(exprGoal);
        }
        if (expressionClass == ClassInstanceCreation.class) {
            return new InstanceCreationEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == InfixExpression.class) {
            return new InfixExpressionEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == PrefixExpression.class) {
            return new PrefixExpressionEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == PostfixExpression.class) {
            return new PostfixExpressionEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == UnaryOperation.class) {
            return new UnaryOperationEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == CastExpression.class) {
            return new CastEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == VariableReference.class) {
            return new VariableReferenceEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == BackTickExpression.class || expressionClass == Quote.class) {
            return new FixedAnswerEvaluator((IGoal)exprGoal, (Object)PHPSimpleTypes.STRING);
        }
        if (expressionClass == CloneExpression.class) {
            return new CloneEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == InstanceOfExpression.class) {
            return new FixedAnswerEvaluator((IGoal)exprGoal, (Object)PHPSimpleTypes.BOOLEAN);
        }
        if (expressionClass == ConditionalExpression.class) {
            return new ConditionalExpressionEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == ArrayCreation.class) {
            return new ArrayCreationEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == ArrayVariableReference.class || expressionClass == ReflectionArrayVariableReference.class) {
            return new ArrayVariableReferenceEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == FieldAccess.class || expressionClass == StaticFieldAccess.class) {
            return new FieldAccessEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == StaticConstantAccess.class) {
            return new StaticConstantAccessEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == FormalParameter.class || expressionClass == FormalParameterByReference.class) {
            return new FormalParameterEvaluator((IGoal)exprGoal);
        }
        if (expressionClass == CatchClause.class) {
            return new CatchClauseEvaluator((IGoal)exprGoal);
        }
        return null;
    }
}

