/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.rename.RenameFolderProcessor;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameProcessorTestCase0026988
extends AbstractRefactoringTest {
    private IProject project1;
    private IProject project2;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"project1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        TestUtils.createFile((IFolder)folder, (String)"test1.php", (String)"<?php class TestRenameClass{}?>");
        this.project2 = TestUtils.createProject((String)"project2");
        TestUtils.createFile((IProject)this.project2, (String)"test2.php", (String)"<?php include('src/test1.php'); ?>");
        IAccessRule[] accesRules = new IAccessRule[]{};
        boolean combineAccessRules = false;
        IBuildpathEntry buildPath = DLTKCore.newProjectEntry((IPath)this.project1.getProject().getFullPath(), (IAccessRule[])accesRules, (boolean)combineAccessRules, (IBuildpathAttribute[])new IBuildpathAttribute[0], (boolean)false);
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project2.getProject());
        ArrayList<IBuildpathEntry> entriesList = new ArrayList<IBuildpathEntry>();
        try {
            IBuildpathEntry[] entries = scriptProject.getRawBuildpath();
            entriesList.addAll(Arrays.asList(entries));
            entriesList.add(buildPath);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        IBuildpathEntry[] newEntries = new IBuildpathEntry[entriesList.size()];
        scriptProject.setRawBuildpath(null, (IProgressMonitor)new NullProgressMonitor());
        scriptProject.setRawBuildpath(entriesList.toArray(newEntries), (IProgressMonitor)new NullProgressMonitor());
        TestUtils.waitForIndexer();
    }

    @Test
    public void testRename() {
        RenameFolderProcessor processor = new RenameFolderProcessor((IContainer)this.project1);
        processor.setNewElementName("project11");
        processor.setUpdateRefernces(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project2.getProject());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project11");
        Assert.assertTrue((boolean)project.exists());
        Assert.assertTrue((boolean)FileUtils.isInBuildpath(project.getFullPath(), scriptProject, 2));
    }

    @After
    public void tearDown() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("project11");
        TestUtils.deleteProject((IProject)project);
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
        this.project2.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

