/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.search.indexing.AbstractJob;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.wst.validation.ValidationFramework;

public final class TestUtils {
    public static synchronized void waitForIndexer() {
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        Semaphore waitForIndexerSemaphore = new Semaphore(0);
        NoWaitSignalThread noWaitSignalThread = new NoWaitSignalThread();
        indexManager.request((IJob)new NoDelayRequest(noWaitSignalThread, waitForIndexerSemaphore));
        noWaitSignalThread.start();
        waitForIndexerSemaphore.acquireUninterruptibly();
    }

    public static synchronized void waitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public static void setProjectPHPVersion(IProject project, PHPVersion phpVersion) throws CoreException {
        if (phpVersion != ProjectOptions.getPHPVersion((IProject)project)) {
            ProjectOptions.setPHPVersion((PHPVersion)phpVersion, (IProject)project);
            TestUtils.waitForIndexer();
        }
    }

    public static void setProjectPHPVersion(IProject project, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags) throws CoreException {
        if (phpVersion != ProjectOptions.getPHPVersion((IProject)project) || useASPTags != ProjectOptions.isSupportingASPTags((IProject)project) || useShortTags != ProjectOptions.useShortTags((IProject)project)) {
            ProjectOptions.setPHPVersion((PHPVersion)phpVersion, (IProject)project);
            ProjectOptions.setSupportingASPTags((boolean)useASPTags, (IProject)project);
            ProjectOptions.setUseShortTags((boolean)useShortTags, (IProject)project);
            TestUtils.waitForIndexer();
        }
    }

    public static IProject createProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            project.create(null);
            project.open(null);
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
            project.setDescription(desc, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        return project;
    }

    public static IFolder createFolder(IProject project, String folderName) {
        IFolder folder = project.getFolder(folderName);
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        return folder;
    }

    public static IFile createFile(IProject project, String fileName, String fileContent) {
        IFile file = project.getFile(fileName);
        try {
            file.create((InputStream)new ByteArrayInputStream(fileContent.getBytes()), true, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        return file;
    }

    public static IFile createFile(IFolder folder, String fileName, String fileContent) {
        IFile file = folder.getFile(fileName);
        try {
            file.create((InputStream)new ByteArrayInputStream(fileContent.getBytes()), true, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        return file;
    }

    public static void deleteProject(IProject project) {
        try {
            project.close(null);
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }

    public static void deleteFile(IFile file) {
        try {
            file.delete(true, null);
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }

    public static void enableColliders(ColliderType collider) {
        switch (collider) {
            case AUTO_BUILD: {
                TestUtils.enableAutoBuild();
                break;
            }
            case WTP_VALIDATION: {
                TestUtils.enableValidation();
                break;
            }
            case LIBRARY_AUTO_DETECTION: {
                TestUtils.enableLibraryDetection();
                break;
            }
            case ALL: {
                TestUtils.enableAutoBuild();
                TestUtils.enableValidation();
                TestUtils.enableLibraryDetection();
                break;
            }
        }
    }

    public static void disableColliders(ColliderType collider) {
        switch (collider) {
            case AUTO_BUILD: {
                TestUtils.disableAutoBuild();
                break;
            }
            case WTP_VALIDATION: {
                TestUtils.disableValidation();
                break;
            }
            case LIBRARY_AUTO_DETECTION: {
                TestUtils.disableLibraryDetection();
                break;
            }
            case ALL: {
                TestUtils.disableAutoBuild();
                TestUtils.disableValidation();
                TestUtils.disableLibraryDetection();
                break;
            }
        }
    }

    public static String compareContents(String expected, String actual) {
        int expectedDiff = StringUtils.indexOfDifference((String)(actual = actual.replaceAll("[\r\n]+", "\n").trim()), (String)(expected = expected.replaceAll("[\r\n]+", "\n").trim()));
        if (expectedDiff >= 0) {
            int actualDiff = StringUtils.indexOfDifference((String)expected, (String)actual);
            return TestUtils.getDiffError(expected, actual, expectedDiff, actualDiff);
        }
        return null;
    }

    public static String compareContentsIgnoreWhitespace(String expected, String actual) {
        String tmpExpected = expected;
        String tmpActual = actual;
        String diff = StringUtils.difference((String)tmpExpected, (String)tmpActual);
        while (diff.length() > 0) {
            String diff2 = StringUtils.difference((String)tmpActual, (String)tmpExpected);
            if (!Character.isWhitespace(diff.charAt(0)) && !Character.isWhitespace(diff2.charAt(0))) {
                int expectedDiff = StringUtils.indexOfDifference((String)tmpActual, (String)tmpExpected) + (expected.length() - tmpExpected.length());
                int actualDiff = StringUtils.indexOfDifference((String)tmpExpected, (String)tmpActual) + (actual.length() - tmpActual.length());
                return TestUtils.getDiffError(expected, actual, expectedDiff, actualDiff);
            }
            tmpActual = diff.trim();
            tmpExpected = diff2.trim();
            diff = StringUtils.difference((String)tmpExpected, (String)tmpActual);
        }
        return null;
    }

    private static String getDiffError(String expected, String actual, int expectedDiff, int actualDiff) {
        StringBuilder errorBuf = new StringBuilder();
        errorBuf.append("\nEXPECTED:\n--------------\n");
        errorBuf.append(expected.substring(0, expectedDiff)).append("*****").append(expected.substring(expectedDiff));
        errorBuf.append("\n\nACTUAL:\n--------------\n");
        errorBuf.append(actual.substring(0, actualDiff)).append("*****").append(actual.substring(actualDiff));
        return errorBuf.toString();
    }

    private static void enableAutoBuild() {
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            IWorkspaceDescription workspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
            workspaceDescription.setAutoBuilding(true);
            try {
                ResourcesPlugin.getWorkspace().setDescription(workspaceDescription);
            }
            catch (CoreException e) {
                Logger.logException((Throwable)e);
            }
        }
    }

    private static void enableValidation() {
        ValidationFramework.getDefault().suspendAllValidation(false);
    }

    private static void enableLibraryDetection() {
        LibraryFolderManager.getInstance().suspendAllDetection(false);
    }

    private static void disableAutoBuild() {
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            IWorkspaceDescription workspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
            workspaceDescription.setAutoBuilding(false);
            try {
                ResourcesPlugin.getWorkspace().setDescription(workspaceDescription);
            }
            catch (CoreException e) {
                Logger.logException((Throwable)e);
            }
        }
    }

    private static void disableValidation() {
        ValidationFramework.getDefault().suspendAllValidation(true);
    }

    private static void disableLibraryDetection() {
        LibraryFolderManager.getInstance().suspendAllDetection(true);
    }

    public static enum ColliderType {
        AUTO_BUILD,
        WTP_VALIDATION,
        LIBRARY_AUTO_DETECTION,
        ALL;

    }

    private static final class NoDelayRequest
    extends AbstractJob {
        private final Thread noWaitSignalThread;
        private final Semaphore waitForIndexerSemaphore;
        private final IndexManager indexManager;

        private NoDelayRequest(Thread noWaitSignalThread, Semaphore waitForIndexerSemaphore) {
            this.waitForIndexerSemaphore = waitForIndexerSemaphore;
            this.noWaitSignalThread = noWaitSignalThread;
            this.indexManager = ModelManager.getModelManager().getIndexManager();
        }

        protected void run() throws CoreException, IOException {
            if (this.indexManager.awaitingJobsCount() > 1) {
                this.noWaitSignalThread.interrupt();
                NoWaitSignalThread noWaitSignalThread = new NoWaitSignalThread();
                this.indexManager.request((IJob)new NoDelayRequest(noWaitSignalThread, this.waitForIndexerSemaphore));
                noWaitSignalThread.start();
                return;
            }
            this.noWaitSignalThread.interrupt();
            this.waitForIndexerSemaphore.release();
        }

        protected String getName() {
            return "WAIT-UNTIL-READY-NO-DELAY-JOB";
        }
    }

    private static final class NoWaitSignalThread
    extends Thread {
        public NoWaitSignalThread() {
            super("No-Wait-Signal-Thread");
        }

        @Override
        public void run() {
            ModelManager.getModelManager().getIndexManager().waitUntilReady();
        }
    }
}

