/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.phpmodelutils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.tests.PDTTUtils;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class PHPModelUtilsTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile = null;
    protected PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/phpmodelutils/php55"});
    }

    public PHPModelUtilsTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = TestUtils.createProject("PHPModelUtils_" + this.version.toString());
        TestUtils.setProjectPHPVersion(this.project, this.version);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        TestUtils.deleteProject(this.project);
    }

    @Test
    public void test(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        String methodName = pdttFile.getConfig().get("method");
        if (methodName == null) {
            throw new IllegalArgumentException("Missing method name in file " + fileName);
        }
        PreparedFile prepareFile = this.prepareFile(pdttFile.getFile());
        PDTTUtils.assertContents(pdttFile.getExpected(), switch (methodName) {
            case "getFullName" -> this.processGetFullName(pdttFile, prepareFile);
            default -> throw new IllegalArgumentException("Unrecognized method name " + methodName + " in file " + fileName);
        });
    }

    @After
    public void after() throws Exception {
        if (this.testFile != null) {
            TestUtils.deleteFile(this.testFile);
            this.testFile = null;
        }
    }

    protected PreparedFile prepareFile(String originalPHPCode) throws Exception {
        int placeholderEnd;
        int placeholderStart;
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>();
        StringBuilder finalPHPCode = new StringBuilder();
        int offset = 0;
        while ((placeholderStart = originalPHPCode.indexOf(">>", offset)) >= 0 && (placeholderEnd = originalPHPCode.indexOf("<<", placeholderStart)) >= 0) {
            finalPHPCode.append(originalPHPCode.subSequence(offset, placeholderStart));
            String placeholderValue = originalPHPCode.substring(placeholderStart + 2, placeholderEnd);
            placeholders.add(new Placeholder(placeholderValue, finalPHPCode.length()));
            finalPHPCode.append(placeholderValue);
            offset = placeholderEnd + 2;
        }
        finalPHPCode.append(originalPHPCode.substring(offset));
        this.testFile = TestUtils.createFile(this.project, "test.php", finalPHPCode.toString());
        TestUtils.waitForIndexer();
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)this.testFile);
        return new PreparedFile(placeholders, sourceModule);
    }

    private String processGetFullName(PdttFile pdttFile, PreparedFile preparedFile) {
        StringBuilder actual = new StringBuilder();
        for (Placeholder placeholder : preparedFile.placeholders) {
            actual.append(PHPModelUtils.getFullName((String)placeholder.value, (ISourceModule)preparedFile.sourceModule, (int)placeholder.offset)).append("\n");
        }
        return actual.toString();
    }

    private class Placeholder {
        public final String value;
        public final int offset;

        public Placeholder(String value, int offset) {
            this.value = value;
            this.offset = offset;
        }
    }

    private class PreparedFile {
        public final List<Placeholder> placeholders;
        public final ISourceModule sourceModule;

        public PreparedFile(List<Placeholder> placeholders, ISourceModule sourceModule) {
            this.placeholders = placeholders;
            this.sourceModule = sourceModule;
        }
    }
}

