/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;

class SnippetFinder
extends AbstractVisitor {
    private List<Match> fResult = new ArrayList<Match>(2);
    private Match fMatch;
    private ASTNode[] fSnippet;
    private int fIndex;
    private Matcher fMatcher;
    private int fTypes;

    private SnippetFinder(ASTNode[] snippet) {
        this.fSnippet = snippet;
        this.fMatcher = new Matcher();
        this.reset();
    }

    public static Match[] perform(ASTNode start, ASTNode[] snippet) {
        Assert.isTrue((start instanceof ClassDeclaration || start instanceof FunctionDeclaration || start instanceof Program ? 1 : 0) != 0);
        SnippetFinder finder = new SnippetFinder(snippet);
        start.accept((Visitor)finder);
        Iterator<Match> iter = finder.fResult.iterator();
        while (iter.hasNext()) {
            Match match = iter.next();
            ASTNode[] nodes = match.getNodes();
            if (nodes.length != 1 || !SnippetFinder.isLeftHandSideOfAssignment(nodes[0])) continue;
            iter.remove();
        }
        return finder.fResult.toArray(new Match[finder.fResult.size()]);
    }

    private static boolean isLeftHandSideOfAssignment(ASTNode node) {
        ASTNode parent = node.getParent();
        return parent != null && parent.getType() == 3 && ((Assignment)parent).getLeftHandSide() == node;
    }

    public boolean visit(ExpressionStatement node) {
        return this.visitNode((ASTNode)node);
    }

    public boolean visit(FunctionDeclaration node) {
        if (++this.fTypes > 1) {
            return false;
        }
        return super.visit(node);
    }

    public void endVisit(FunctionDeclaration node) {
        --this.fTypes;
        super.endVisit(node);
    }

    protected boolean visitNode(ASTNode node) {
        if (this.matches(node)) {
            return false;
        }
        if (!this.isResetted()) {
            this.reset();
            if (this.matches(node)) {
                return false;
            }
        }
        return true;
    }

    private boolean matches(ASTNode node) {
        if (this.isSnippetNode(node)) {
            return false;
        }
        if (node.subtreeMatch((ASTMatcher)this.fMatcher, (Object)this.fSnippet[this.fIndex]) && this.fMatch.hasCorrectNesting(node)) {
            this.fMatch.add(node);
            ++this.fIndex;
            if (this.fIndex == this.fSnippet.length) {
                this.fResult.add(this.fMatch);
                this.reset();
            }
            return true;
        }
        return false;
    }

    private boolean isResetted() {
        return this.fIndex == 0 && this.fMatch.isEmpty();
    }

    private void reset() {
        this.fIndex = 0;
        this.fMatch = new Match();
    }

    private boolean isSnippetNode(ASTNode node) {
        int i = 0;
        while (i < this.fSnippet.length) {
            if (node == this.fSnippet[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class Match {
        private List<ASTNode> fNodes = new ArrayList<ASTNode>(10);
        private Map<IVariableBinding, Identifier> fLocalMappings = new HashMap<IVariableBinding, Identifier>();

        public void add(ASTNode node) {
            this.fNodes.add(node);
        }

        public boolean hasCorrectNesting(ASTNode node) {
            if (this.fNodes.size() == 0) {
                return true;
            }
            ASTNode parent = node.getParent();
            if (this.fNodes.get(0).getParent() != parent) {
                return false;
            }
            int nodeType = parent.getType();
            return nodeType == 6 || nodeType == 56;
        }

        public ASTNode[] getNodes() {
            return this.fNodes.toArray(new ASTNode[this.fNodes.size()]);
        }

        public void addLocal(IVariableBinding org, Identifier local) {
            this.fLocalMappings.put(org, local);
        }

        public Identifier getMappedName(IVariableBinding org) {
            return this.fLocalMappings.get(org);
        }

        public IVariableBinding getMappedBinding(IVariableBinding org) {
            return null;
        }

        public boolean isEmpty() {
            return this.fNodes.isEmpty() && this.fLocalMappings.isEmpty();
        }

        public boolean isMethodBody() {
            ASTNode first = this.fNodes.get(0);
            if (first.getParent() == null) {
                return false;
            }
            ASTNode candidate = first.getParent().getParent();
            if (candidate == null || candidate.getType() != 42) {
                return false;
            }
            MethodDeclaration method = (MethodDeclaration)candidate;
            return method.getFunction().getBody().statements().size() == this.fNodes.size();
        }

        public MethodDeclaration getEnclosingMethod() {
            ASTNode first = this.fNodes.get(0);
            return (MethodDeclaration)ASTNodes.getParent((ASTNode)first, (int)42);
        }
    }

    private class Matcher
    extends ASTMatcher {
        private Matcher() {
        }

        public boolean match(Identifier candidate, Object s) {
            if (!(s instanceof Identifier)) {
                return false;
            }
            Identifier snippet = (Identifier)s;
            if (!(candidate.getParent() instanceof Variable) || !(snippet.getParent() instanceof Variable)) {
                return false;
            }
            Variable cv = (Variable)candidate.getParent();
            Variable sv = (Variable)snippet.getParent();
            IVariableBinding cb = cv.resolveVariableBinding();
            IVariableBinding sb = sv.resolveVariableBinding();
            if (cb == null || sb == null) {
                return false;
            }
            if (!cb.isField() && !sb.isField()) {
                Variable parent;
                IVariableBinding mappedBinding;
                Identifier mapped = SnippetFinder.this.fMatch.getMappedName(sb);
                if (mapped != null && !cb.equals((Object)(mappedBinding = (parent = (Variable)mapped.getParent()).resolveVariableBinding()))) {
                    return false;
                }
                SnippetFinder.this.fMatch.addLocal(sb, candidate);
                return true;
            }
            return cb.equals((Object)sb);
        }
    }
}

