/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class PHPStackFrame
extends PHPDebugElement
implements IStackFrame {
    private static final Pattern LAMBDA_FUNC_PATTERN = Pattern.compile("(.*)\\((\\d+)\\) : runtime-created function");
    private PHPThread fThread;
    private String fFunctionName;
    private String fFileName;
    private String fResolvedFileName;
    private int fLineNumber;
    private int fDepth;
    private Expression[] fExpressions;
    private VariablesContainer fVariablesContainer = new VariablesContainer();

    public PHPStackFrame(IThread thread, String fileName, String resolvedFileName, String funcName, int lineNumber, int depth, Expression[] localVariables) {
        super((PHPDebugTarget)thread.getDebugTarget());
        this.baseInit(thread, fileName, resolvedFileName, funcName, lineNumber, depth, localVariables);
    }

    private void baseInit(IThread thread, String fileName, String resolvedFileName, String funcName, int lineNumber, int depth, Expression[] localVariables) {
        Matcher matcher = LAMBDA_FUNC_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            fileName = matcher.group(1);
            lineNumber = Integer.parseInt(matcher.group(2));
        }
        this.fFunctionName = funcName;
        this.fFileName = fileName;
        this.fResolvedFileName = resolvedFileName;
        this.fLineNumber = lineNumber;
        this.fDepth = depth;
        this.fThread = (PHPThread)thread;
        this.fExpressions = localVariables;
    }

    protected synchronized void update(int lineNumber, Expression[] localVariables) throws DebugException {
        this.fLineNumber = lineNumber;
        this.fExpressions = localVariables;
        this.fVariablesContainer.markOutdated();
    }

    protected int getDepth() {
        return this.fDepth;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        return this.fVariablesContainer.getVariables();
    }

    public boolean hasVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables(this).length > 0;
    }

    public synchronized int getLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.fFunctionName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fResolvedFileName;
    }

    public String getAbsoluteFileName() {
        return this.fFileName;
    }

    public synchronized Expression[] getStackVariables() {
        return this.fExpressions;
    }

    private final class VariablesContainer {
        private Map<String, IVariable> fAllCurrentVariables = null;
        private Map<String, IVariable> fAllPreviousVariables = null;
        private IVariable[] fVariables = null;
        private boolean fIsOutdated = true;

        private VariablesContainer() {
        }

        IVariable[] getVariables() {
            if (this.fIsOutdated) {
                this.updateVariables();
                this.fVariables = this.fAllCurrentVariables.values().toArray(new IVariable[this.fAllCurrentVariables.size()]);
                this.fIsOutdated = false;
            }
            return this.fVariables;
        }

        void markOutdated() {
            this.fIsOutdated = true;
        }

        private IVariable merge(IVariable variable) {
            if (this.fAllPreviousVariables == null) {
                return variable;
            }
            if (!(variable instanceof PHPVariable)) {
                return variable;
            }
            PHPVariable incoming = (PHPVariable)variable;
            if (incoming.getFullName().isEmpty()) {
                return incoming;
            }
            IVariable stored = this.fAllPreviousVariables.get(incoming.getFullName());
            if (stored != null) {
                ((PHPVariable)stored).update(incoming.getExpression());
                return stored;
            }
            return variable;
        }

        private void updateVariables() {
            this.fAllPreviousVariables = this.fAllCurrentVariables;
            this.fAllCurrentVariables = new LinkedHashMap<String, IVariable>();
            Expression[] localVariables = ExpressionValue.sort(PHPStackFrame.this.fExpressions);
            this.fAllCurrentVariables = new LinkedHashMap<String, IVariable>();
            int i = 0;
            while (i < localVariables.length) {
                PHPVariable incoming = new PHPVariable((PHPDebugTarget)PHPStackFrame.this.fThread.getDebugTarget(), localVariables[i]);
                this.fAllCurrentVariables.put(incoming.getFullName(), this.merge(incoming));
                ++i;
            }
        }
    }
}

