/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

/*
 * generated by Xtext 2.22.0
 */
package org.eclipse.trace4cps.tl.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.common.services.TerminalsGrammarAccess;
import org.eclipse.xtext.service.AbstractElementFinder;
import org.eclipse.xtext.service.GrammarProvider;

@Singleton
public class EtlGrammarAccess extends AbstractElementFinder.AbstractGrammarElementFinder {
	
	public class EtlModelElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.EtlModel");
		private final Assignment cElementsAssignment = (Assignment)rule.eContents().get(1);
		private final RuleCall cElementsTopLevelModelElementParserRuleCall_0 = (RuleCall)cElementsAssignment.eContents().get(0);
		
		//EtlModel:
		//	elements+=TopLevelModelElement*;
		@Override public ParserRule getRule() { return rule; }
		
		//elements+=TopLevelModelElement*
		public Assignment getElementsAssignment() { return cElementsAssignment; }
		
		//TopLevelModelElement
		public RuleCall getElementsTopLevelModelElementParserRuleCall_0() { return cElementsTopLevelModelElementParserRuleCall_0; }
	}
	public class TopLevelModelElementElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.TopLevelModelElement");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Action cSignalDefAction_0_0 = (Action)cGroup_0.eContents().get(0);
		private final Keyword cSignalKeyword_0_1 = (Keyword)cGroup_0.eContents().get(1);
		private final Assignment cNameAssignment_0_2 = (Assignment)cGroup_0.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_0_2_0 = (RuleCall)cNameAssignment_0_2.eContents().get(0);
		private final Keyword cColonKeyword_0_3 = (Keyword)cGroup_0.eContents().get(3);
		private final Assignment cSignalAssignment_0_4 = (Assignment)cGroup_0.eContents().get(4);
		private final RuleCall cSignalSignalParserRuleCall_0_4_0 = (RuleCall)cSignalAssignment_0_4.eContents().get(0);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Action cDefAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Keyword cDefKeyword_1_1 = (Keyword)cGroup_1.eContents().get(1);
		private final Assignment cNameAssignment_1_2 = (Assignment)cGroup_1.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_1_2_0 = (RuleCall)cNameAssignment_1_2.eContents().get(0);
		private final Group cGroup_1_3 = (Group)cGroup_1.eContents().get(3);
		private final Keyword cLeftParenthesisKeyword_1_3_0 = (Keyword)cGroup_1_3.eContents().get(0);
		private final Assignment cParamAssignment_1_3_1 = (Assignment)cGroup_1_3.eContents().get(1);
		private final RuleCall cParamIDTerminalRuleCall_1_3_1_0 = (RuleCall)cParamAssignment_1_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_1_3_2 = (Keyword)cGroup_1_3.eContents().get(2);
		private final Keyword cColonKeyword_1_4 = (Keyword)cGroup_1.eContents().get(4);
		private final Assignment cFormulaAssignment_1_5 = (Assignment)cGroup_1.eContents().get(5);
		private final RuleCall cFormulaFormulaParserRuleCall_1_5_0 = (RuleCall)cFormulaAssignment_1_5.eContents().get(0);
		private final Group cGroup_2 = (Group)cAlternatives.eContents().get(2);
		private final Action cCheckAction_2_0 = (Action)cGroup_2.eContents().get(0);
		private final Keyword cCheckKeyword_2_1 = (Keyword)cGroup_2.eContents().get(1);
		private final Assignment cNameAssignment_2_2 = (Assignment)cGroup_2.eContents().get(2);
		private final RuleCall cNameIDTerminalRuleCall_2_2_0 = (RuleCall)cNameAssignment_2_2.eContents().get(0);
		private final Keyword cColonKeyword_2_3 = (Keyword)cGroup_2.eContents().get(3);
		private final Group cGroup_2_4 = (Group)cGroup_2.eContents().get(4);
		private final Keyword cForallKeyword_2_4_0 = (Keyword)cGroup_2_4.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_2_4_1 = (Keyword)cGroup_2_4.eContents().get(1);
		private final Assignment cVarAssignment_2_4_2 = (Assignment)cGroup_2_4.eContents().get(2);
		private final RuleCall cVarIDTerminalRuleCall_2_4_2_0 = (RuleCall)cVarAssignment_2_4_2.eContents().get(0);
		private final Keyword cColonKeyword_2_4_3 = (Keyword)cGroup_2_4.eContents().get(3);
		private final Assignment cLbAssignment_2_4_4 = (Assignment)cGroup_2_4.eContents().get(4);
		private final RuleCall cLbINT_TTerminalRuleCall_2_4_4_0 = (RuleCall)cLbAssignment_2_4_4.eContents().get(0);
		private final Keyword cFullStopFullStopFullStopKeyword_2_4_5 = (Keyword)cGroup_2_4.eContents().get(5);
		private final Assignment cUbAssignment_2_4_6 = (Assignment)cGroup_2_4.eContents().get(6);
		private final RuleCall cUbINT_TTerminalRuleCall_2_4_6_0 = (RuleCall)cUbAssignment_2_4_6.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_2_4_7 = (Keyword)cGroup_2_4.eContents().get(7);
		private final Assignment cFormulaAssignment_2_5 = (Assignment)cGroup_2.eContents().get(5);
		private final RuleCall cFormulaFormulaParserRuleCall_2_5_0 = (RuleCall)cFormulaAssignment_2_5.eContents().get(0);
		
		///* All TopLevelElements must have a unique name */ TopLevelModelElement:
		//	{SignalDef} 'signal' name=ID ':' signal=Signal
		//	| {Def} 'def' name=ID ('(' param=ID ')')? ':' formula=Formula
		//	| {Check} 'check' name=ID ':' ('forall' '(' var=ID ':' lb=INT_T '...' ub=INT_T ')')? formula=Formula;
		@Override public ParserRule getRule() { return rule; }
		
		//{SignalDef} 'signal' name=ID ':' signal=Signal | {Def} 'def' name=ID ('(' param=ID ')')? ':' formula=Formula | {Check}
		//'check' name=ID ':' ('forall' '(' var=ID ':' lb=INT_T '...' ub=INT_T ')')? formula=Formula
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//{SignalDef} 'signal' name=ID ':' signal=Signal
		public Group getGroup_0() { return cGroup_0; }
		
		//{SignalDef}
		public Action getSignalDefAction_0_0() { return cSignalDefAction_0_0; }
		
		//'signal'
		public Keyword getSignalKeyword_0_1() { return cSignalKeyword_0_1; }
		
		//name=ID
		public Assignment getNameAssignment_0_2() { return cNameAssignment_0_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_0_2_0() { return cNameIDTerminalRuleCall_0_2_0; }
		
		//':'
		public Keyword getColonKeyword_0_3() { return cColonKeyword_0_3; }
		
		//signal=Signal
		public Assignment getSignalAssignment_0_4() { return cSignalAssignment_0_4; }
		
		//Signal
		public RuleCall getSignalSignalParserRuleCall_0_4_0() { return cSignalSignalParserRuleCall_0_4_0; }
		
		//{Def} 'def' name=ID ('(' param=ID ')')? ':' formula=Formula
		public Group getGroup_1() { return cGroup_1; }
		
		//{Def}
		public Action getDefAction_1_0() { return cDefAction_1_0; }
		
		//'def'
		public Keyword getDefKeyword_1_1() { return cDefKeyword_1_1; }
		
		//name=ID
		public Assignment getNameAssignment_1_2() { return cNameAssignment_1_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_1_2_0() { return cNameIDTerminalRuleCall_1_2_0; }
		
		//('(' param=ID ')')?
		public Group getGroup_1_3() { return cGroup_1_3; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_1_3_0() { return cLeftParenthesisKeyword_1_3_0; }
		
		//param=ID
		public Assignment getParamAssignment_1_3_1() { return cParamAssignment_1_3_1; }
		
		//ID
		public RuleCall getParamIDTerminalRuleCall_1_3_1_0() { return cParamIDTerminalRuleCall_1_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_1_3_2() { return cRightParenthesisKeyword_1_3_2; }
		
		//':'
		public Keyword getColonKeyword_1_4() { return cColonKeyword_1_4; }
		
		//formula=Formula
		public Assignment getFormulaAssignment_1_5() { return cFormulaAssignment_1_5; }
		
		//Formula
		public RuleCall getFormulaFormulaParserRuleCall_1_5_0() { return cFormulaFormulaParserRuleCall_1_5_0; }
		
		//{Check} 'check' name=ID ':' ('forall' '(' var=ID ':' lb=INT_T '...' ub=INT_T ')')? formula=Formula
		public Group getGroup_2() { return cGroup_2; }
		
		//{Check}
		public Action getCheckAction_2_0() { return cCheckAction_2_0; }
		
		//'check'
		public Keyword getCheckKeyword_2_1() { return cCheckKeyword_2_1; }
		
		//name=ID
		public Assignment getNameAssignment_2_2() { return cNameAssignment_2_2; }
		
		//ID
		public RuleCall getNameIDTerminalRuleCall_2_2_0() { return cNameIDTerminalRuleCall_2_2_0; }
		
		//':'
		public Keyword getColonKeyword_2_3() { return cColonKeyword_2_3; }
		
		//('forall' '(' var=ID ':' lb=INT_T '...' ub=INT_T ')')?
		public Group getGroup_2_4() { return cGroup_2_4; }
		
		//'forall'
		public Keyword getForallKeyword_2_4_0() { return cForallKeyword_2_4_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_2_4_1() { return cLeftParenthesisKeyword_2_4_1; }
		
		//var=ID
		public Assignment getVarAssignment_2_4_2() { return cVarAssignment_2_4_2; }
		
		//ID
		public RuleCall getVarIDTerminalRuleCall_2_4_2_0() { return cVarIDTerminalRuleCall_2_4_2_0; }
		
		//':'
		public Keyword getColonKeyword_2_4_3() { return cColonKeyword_2_4_3; }
		
		//lb=INT_T
		public Assignment getLbAssignment_2_4_4() { return cLbAssignment_2_4_4; }
		
		//INT_T
		public RuleCall getLbINT_TTerminalRuleCall_2_4_4_0() { return cLbINT_TTerminalRuleCall_2_4_4_0; }
		
		//'...'
		public Keyword getFullStopFullStopFullStopKeyword_2_4_5() { return cFullStopFullStopFullStopKeyword_2_4_5; }
		
		//ub=INT_T
		public Assignment getUbAssignment_2_4_6() { return cUbAssignment_2_4_6; }
		
		//INT_T
		public RuleCall getUbINT_TTerminalRuleCall_2_4_6_0() { return cUbINT_TTerminalRuleCall_2_4_6_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_2_4_7() { return cRightParenthesisKeyword_2_4_7; }
		
		//formula=Formula
		public Assignment getFormulaAssignment_2_5() { return cFormulaAssignment_2_5; }
		
		//Formula
		public RuleCall getFormulaFormulaParserRuleCall_2_5_0() { return cFormulaFormulaParserRuleCall_2_5_0; }
	}
	public class SignalElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.Signal");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Action cTraceSignalAction_0_0 = (Action)cGroup_0.eContents().get(0);
		private final Assignment cFilterAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final RuleCall cFilterAttributeFilterParserRuleCall_0_1_0 = (RuleCall)cFilterAssignment_0_1.eContents().get(0);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Action cThroughputSignalAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Keyword cThroughputKeyword_1_1 = (Keyword)cGroup_1.eContents().get(1);
		private final Keyword cOfKeyword_1_2 = (Keyword)cGroup_1.eContents().get(2);
		private final Alternatives cAlternatives_1_3 = (Alternatives)cGroup_1.eContents().get(3);
		private final Assignment cIdAttAssignment_1_3_0 = (Assignment)cAlternatives_1_3.eContents().get(0);
		private final RuleCall cIdAttIDTerminalRuleCall_1_3_0_0 = (RuleCall)cIdAttAssignment_1_3_0.eContents().get(0);
		private final Assignment cApAssignment_1_3_1 = (Assignment)cAlternatives_1_3.eContents().get(1);
		private final RuleCall cApMtlApParserRuleCall_1_3_1_0 = (RuleCall)cApAssignment_1_3_1.eContents().get(0);
		private final Group cGroup_1_4 = (Group)cGroup_1.eContents().get(4);
		private final Keyword cPerKeyword_1_4_0 = (Keyword)cGroup_1_4.eContents().get(0);
		private final Assignment cScaleAssignment_1_4_1 = (Assignment)cGroup_1_4.eContents().get(1);
		private final RuleCall cScaleTimeUnitEnumEnumRuleCall_1_4_1_0 = (RuleCall)cScaleAssignment_1_4_1.eContents().get(0);
		private final Assignment cConvSpecAssignment_1_5 = (Assignment)cGroup_1.eContents().get(5);
		private final RuleCall cConvSpecConvSpecParserRuleCall_1_5_0 = (RuleCall)cConvSpecAssignment_1_5.eContents().get(0);
		private final Group cGroup_2 = (Group)cAlternatives.eContents().get(2);
		private final Action cLatencySignalAction_2_0 = (Action)cGroup_2.eContents().get(0);
		private final Keyword cLatencyKeyword_2_1 = (Keyword)cGroup_2.eContents().get(1);
		private final Keyword cOfKeyword_2_2 = (Keyword)cGroup_2.eContents().get(2);
		private final Assignment cIdAttAssignment_2_3 = (Assignment)cGroup_2.eContents().get(3);
		private final RuleCall cIdAttIDTerminalRuleCall_2_3_0 = (RuleCall)cIdAttAssignment_2_3.eContents().get(0);
		private final Group cGroup_2_4 = (Group)cGroup_2.eContents().get(4);
		private final Keyword cInKeyword_2_4_0 = (Keyword)cGroup_2_4.eContents().get(0);
		private final Assignment cScaleAssignment_2_4_1 = (Assignment)cGroup_2_4.eContents().get(1);
		private final RuleCall cScaleTimeUnitEnumEnumRuleCall_2_4_1_0 = (RuleCall)cScaleAssignment_2_4_1.eContents().get(0);
		private final Assignment cConvSpecAssignment_2_5 = (Assignment)cGroup_2.eContents().get(5);
		private final RuleCall cConvSpecConvSpecParserRuleCall_2_5_0 = (RuleCall)cConvSpecAssignment_2_5.eContents().get(0);
		private final Group cGroup_3 = (Group)cAlternatives.eContents().get(3);
		private final Action cWipSignalAction_3_0 = (Action)cGroup_3.eContents().get(0);
		private final Keyword cWipKeyword_3_1 = (Keyword)cGroup_3.eContents().get(1);
		private final Keyword cOfKeyword_3_2 = (Keyword)cGroup_3.eContents().get(2);
		private final Assignment cIdAttAssignment_3_3 = (Assignment)cGroup_3.eContents().get(3);
		private final RuleCall cIdAttIDTerminalRuleCall_3_3_0 = (RuleCall)cIdAttAssignment_3_3.eContents().get(0);
		private final Assignment cConvSpecAssignment_3_4 = (Assignment)cGroup_3.eContents().get(4);
		private final RuleCall cConvSpecConvSpecParserRuleCall_3_4_0 = (RuleCall)cConvSpecAssignment_3_4.eContents().get(0);
		private final Group cGroup_4 = (Group)cAlternatives.eContents().get(4);
		private final Action cResourceAmountSignalAction_4_0 = (Action)cGroup_4.eContents().get(0);
		private final Keyword cResourceAmountKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Assignment cFilterAssignment_4_2 = (Assignment)cGroup_4.eContents().get(2);
		private final RuleCall cFilterAttributeFilterParserRuleCall_4_2_0 = (RuleCall)cFilterAssignment_4_2.eContents().get(0);
		private final Assignment cConvSpecAssignment_4_3 = (Assignment)cGroup_4.eContents().get(3);
		private final RuleCall cConvSpecConvSpecParserRuleCall_4_3_0 = (RuleCall)cConvSpecAssignment_4_3.eContents().get(0);
		private final Group cGroup_5 = (Group)cAlternatives.eContents().get(5);
		private final Action cResourceClientSignalAction_5_0 = (Action)cGroup_5.eContents().get(0);
		private final Keyword cResourceClientsKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cFilterAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cFilterAttributeFilterParserRuleCall_5_2_0 = (RuleCall)cFilterAssignment_5_2.eContents().get(0);
		private final Assignment cConvSpecAssignment_5_3 = (Assignment)cGroup_5.eContents().get(3);
		private final RuleCall cConvSpecConvSpecParserRuleCall_5_3_0 = (RuleCall)cConvSpecAssignment_5_3.eContents().get(0);
		
		//Signal:
		//	{TraceSignal} filter=AttributeFilter
		//	| {ThroughputSignal} 'throughput' 'of' (idAtt=ID | ap=MtlAp) ('per' scale=TimeUnitEnum)?
		//	convSpec=ConvSpec?
		//	| {LatencySignal} 'latency' 'of' idAtt=ID ('in' scale=TimeUnitEnum)? convSpec=ConvSpec?
		//	| {WipSignal} 'wip' 'of' idAtt=ID convSpec=ConvSpec?
		//	| {ResourceAmountSignal} 'resource-amount' filter=AttributeFilter convSpec=ConvSpec?
		//	| {ResourceClientSignal} 'resource-clients' filter=AttributeFilter convSpec=ConvSpec?;
		@Override public ParserRule getRule() { return rule; }
		
		//{TraceSignal} filter=AttributeFilter | {ThroughputSignal} 'throughput' 'of' (idAtt=ID | ap=MtlAp) ('per'
		//scale=TimeUnitEnum)? convSpec=ConvSpec? | {LatencySignal} 'latency' 'of' idAtt=ID ('in' scale=TimeUnitEnum)?
		//convSpec=ConvSpec? | {WipSignal} 'wip' 'of' idAtt=ID convSpec=ConvSpec? | {ResourceAmountSignal} 'resource-amount'
		//filter=AttributeFilter convSpec=ConvSpec? | {ResourceClientSignal} 'resource-clients' filter=AttributeFilter
		//convSpec=ConvSpec?
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//{TraceSignal} filter=AttributeFilter
		public Group getGroup_0() { return cGroup_0; }
		
		//{TraceSignal}
		public Action getTraceSignalAction_0_0() { return cTraceSignalAction_0_0; }
		
		//filter=AttributeFilter
		public Assignment getFilterAssignment_0_1() { return cFilterAssignment_0_1; }
		
		//AttributeFilter
		public RuleCall getFilterAttributeFilterParserRuleCall_0_1_0() { return cFilterAttributeFilterParserRuleCall_0_1_0; }
		
		//{ThroughputSignal} 'throughput' 'of' (idAtt=ID | ap=MtlAp) ('per' scale=TimeUnitEnum)? convSpec=ConvSpec?
		public Group getGroup_1() { return cGroup_1; }
		
		//{ThroughputSignal}
		public Action getThroughputSignalAction_1_0() { return cThroughputSignalAction_1_0; }
		
		//'throughput'
		public Keyword getThroughputKeyword_1_1() { return cThroughputKeyword_1_1; }
		
		//'of'
		public Keyword getOfKeyword_1_2() { return cOfKeyword_1_2; }
		
		//(idAtt=ID | ap=MtlAp)
		public Alternatives getAlternatives_1_3() { return cAlternatives_1_3; }
		
		//idAtt=ID
		public Assignment getIdAttAssignment_1_3_0() { return cIdAttAssignment_1_3_0; }
		
		//ID
		public RuleCall getIdAttIDTerminalRuleCall_1_3_0_0() { return cIdAttIDTerminalRuleCall_1_3_0_0; }
		
		//ap=MtlAp
		public Assignment getApAssignment_1_3_1() { return cApAssignment_1_3_1; }
		
		//MtlAp
		public RuleCall getApMtlApParserRuleCall_1_3_1_0() { return cApMtlApParserRuleCall_1_3_1_0; }
		
		//('per' scale=TimeUnitEnum)?
		public Group getGroup_1_4() { return cGroup_1_4; }
		
		//'per'
		public Keyword getPerKeyword_1_4_0() { return cPerKeyword_1_4_0; }
		
		//scale=TimeUnitEnum
		public Assignment getScaleAssignment_1_4_1() { return cScaleAssignment_1_4_1; }
		
		//TimeUnitEnum
		public RuleCall getScaleTimeUnitEnumEnumRuleCall_1_4_1_0() { return cScaleTimeUnitEnumEnumRuleCall_1_4_1_0; }
		
		//convSpec=ConvSpec?
		public Assignment getConvSpecAssignment_1_5() { return cConvSpecAssignment_1_5; }
		
		//ConvSpec
		public RuleCall getConvSpecConvSpecParserRuleCall_1_5_0() { return cConvSpecConvSpecParserRuleCall_1_5_0; }
		
		//{LatencySignal} 'latency' 'of' idAtt=ID ('in' scale=TimeUnitEnum)? convSpec=ConvSpec?
		public Group getGroup_2() { return cGroup_2; }
		
		//{LatencySignal}
		public Action getLatencySignalAction_2_0() { return cLatencySignalAction_2_0; }
		
		//'latency'
		public Keyword getLatencyKeyword_2_1() { return cLatencyKeyword_2_1; }
		
		//'of'
		public Keyword getOfKeyword_2_2() { return cOfKeyword_2_2; }
		
		//idAtt=ID
		public Assignment getIdAttAssignment_2_3() { return cIdAttAssignment_2_3; }
		
		//ID
		public RuleCall getIdAttIDTerminalRuleCall_2_3_0() { return cIdAttIDTerminalRuleCall_2_3_0; }
		
		//('in' scale=TimeUnitEnum)?
		public Group getGroup_2_4() { return cGroup_2_4; }
		
		//'in'
		public Keyword getInKeyword_2_4_0() { return cInKeyword_2_4_0; }
		
		//scale=TimeUnitEnum
		public Assignment getScaleAssignment_2_4_1() { return cScaleAssignment_2_4_1; }
		
		//TimeUnitEnum
		public RuleCall getScaleTimeUnitEnumEnumRuleCall_2_4_1_0() { return cScaleTimeUnitEnumEnumRuleCall_2_4_1_0; }
		
		//convSpec=ConvSpec?
		public Assignment getConvSpecAssignment_2_5() { return cConvSpecAssignment_2_5; }
		
		//ConvSpec
		public RuleCall getConvSpecConvSpecParserRuleCall_2_5_0() { return cConvSpecConvSpecParserRuleCall_2_5_0; }
		
		//{WipSignal} 'wip' 'of' idAtt=ID convSpec=ConvSpec?
		public Group getGroup_3() { return cGroup_3; }
		
		//{WipSignal}
		public Action getWipSignalAction_3_0() { return cWipSignalAction_3_0; }
		
		//'wip'
		public Keyword getWipKeyword_3_1() { return cWipKeyword_3_1; }
		
		//'of'
		public Keyword getOfKeyword_3_2() { return cOfKeyword_3_2; }
		
		//idAtt=ID
		public Assignment getIdAttAssignment_3_3() { return cIdAttAssignment_3_3; }
		
		//ID
		public RuleCall getIdAttIDTerminalRuleCall_3_3_0() { return cIdAttIDTerminalRuleCall_3_3_0; }
		
		//convSpec=ConvSpec?
		public Assignment getConvSpecAssignment_3_4() { return cConvSpecAssignment_3_4; }
		
		//ConvSpec
		public RuleCall getConvSpecConvSpecParserRuleCall_3_4_0() { return cConvSpecConvSpecParserRuleCall_3_4_0; }
		
		//{ResourceAmountSignal} 'resource-amount' filter=AttributeFilter convSpec=ConvSpec?
		public Group getGroup_4() { return cGroup_4; }
		
		//{ResourceAmountSignal}
		public Action getResourceAmountSignalAction_4_0() { return cResourceAmountSignalAction_4_0; }
		
		//'resource-amount'
		public Keyword getResourceAmountKeyword_4_1() { return cResourceAmountKeyword_4_1; }
		
		//filter=AttributeFilter
		public Assignment getFilterAssignment_4_2() { return cFilterAssignment_4_2; }
		
		//AttributeFilter
		public RuleCall getFilterAttributeFilterParserRuleCall_4_2_0() { return cFilterAttributeFilterParserRuleCall_4_2_0; }
		
		//convSpec=ConvSpec?
		public Assignment getConvSpecAssignment_4_3() { return cConvSpecAssignment_4_3; }
		
		//ConvSpec
		public RuleCall getConvSpecConvSpecParserRuleCall_4_3_0() { return cConvSpecConvSpecParserRuleCall_4_3_0; }
		
		//{ResourceClientSignal} 'resource-clients' filter=AttributeFilter convSpec=ConvSpec?
		public Group getGroup_5() { return cGroup_5; }
		
		//{ResourceClientSignal}
		public Action getResourceClientSignalAction_5_0() { return cResourceClientSignalAction_5_0; }
		
		//'resource-clients'
		public Keyword getResourceClientsKeyword_5_1() { return cResourceClientsKeyword_5_1; }
		
		//filter=AttributeFilter
		public Assignment getFilterAssignment_5_2() { return cFilterAssignment_5_2; }
		
		//AttributeFilter
		public RuleCall getFilterAttributeFilterParserRuleCall_5_2_0() { return cFilterAttributeFilterParserRuleCall_5_2_0; }
		
		//convSpec=ConvSpec?
		public Assignment getConvSpecAssignment_5_3() { return cConvSpecAssignment_5_3; }
		
		//ConvSpec
		public RuleCall getConvSpecConvSpecParserRuleCall_5_3_0() { return cConvSpecConvSpecParserRuleCall_5_3_0; }
	}
	public class ConvSpecElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.ConvSpec");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cOverKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cWindowWidthAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cWindowWidthDOUBLE_TTerminalRuleCall_1_0 = (RuleCall)cWindowWidthAssignment_1.eContents().get(0);
		private final Assignment cWindowUnitAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cWindowUnitTimeUnitEnumEnumRuleCall_2_0 = (RuleCall)cWindowUnitAssignment_2.eContents().get(0);
		
		//ConvSpec:
		//	'over' windowWidth=DOUBLE_T windowUnit=TimeUnitEnum;
		@Override public ParserRule getRule() { return rule; }
		
		//'over' windowWidth=DOUBLE_T windowUnit=TimeUnitEnum
		public Group getGroup() { return cGroup; }
		
		//'over'
		public Keyword getOverKeyword_0() { return cOverKeyword_0; }
		
		//windowWidth=DOUBLE_T
		public Assignment getWindowWidthAssignment_1() { return cWindowWidthAssignment_1; }
		
		//DOUBLE_T
		public RuleCall getWindowWidthDOUBLE_TTerminalRuleCall_1_0() { return cWindowWidthDOUBLE_TTerminalRuleCall_1_0; }
		
		//windowUnit=TimeUnitEnum
		public Assignment getWindowUnitAssignment_2() { return cWindowUnitAssignment_2; }
		
		//TimeUnitEnum
		public RuleCall getWindowUnitTimeUnitEnumEnumRuleCall_2_0() { return cWindowUnitTimeUnitEnumEnumRuleCall_2_0; }
	}
	public class FormulaElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.Formula");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Group cGroup_0 = (Group)cAlternatives.eContents().get(0);
		private final Action cReferenceFormulaAction_0_0 = (Action)cGroup_0.eContents().get(0);
		private final Assignment cDefAssignment_0_1 = (Assignment)cGroup_0.eContents().get(1);
		private final CrossReference cDefDefCrossReference_0_1_0 = (CrossReference)cDefAssignment_0_1.eContents().get(0);
		private final RuleCall cDefDefIDTerminalRuleCall_0_1_0_1 = (RuleCall)cDefDefCrossReference_0_1_0.eContents().get(1);
		private final Group cGroup_0_2 = (Group)cGroup_0.eContents().get(2);
		private final Keyword cLeftParenthesisKeyword_0_2_0 = (Keyword)cGroup_0_2.eContents().get(0);
		private final Assignment cParamAssignment_0_2_1 = (Assignment)cGroup_0_2.eContents().get(1);
		private final RuleCall cParamIDTerminalRuleCall_0_2_1_0 = (RuleCall)cParamAssignment_0_2_1.eContents().get(0);
		private final Group cGroup_0_2_2 = (Group)cGroup_0_2.eContents().get(2);
		private final Keyword cPlusSignKeyword_0_2_2_0 = (Keyword)cGroup_0_2_2.eContents().get(0);
		private final Assignment cValAssignment_0_2_2_1 = (Assignment)cGroup_0_2_2.eContents().get(1);
		private final RuleCall cValINT_TTerminalRuleCall_0_2_2_1_0 = (RuleCall)cValAssignment_0_2_2_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_0_2_3 = (Keyword)cGroup_0_2.eContents().get(3);
		private final Group cGroup_1 = (Group)cAlternatives.eContents().get(1);
		private final Action cApFormulaAction_1_0 = (Action)cGroup_1.eContents().get(0);
		private final Assignment cMtlAPAssignment_1_1 = (Assignment)cGroup_1.eContents().get(1);
		private final RuleCall cMtlAPMtlApParserRuleCall_1_1_0 = (RuleCall)cMtlAPAssignment_1_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cAlternatives.eContents().get(2);
		private final Action cApFormulaAction_2_0 = (Action)cGroup_2.eContents().get(0);
		private final Assignment cStlAPAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cStlAPStlApParserRuleCall_2_1_0 = (RuleCall)cStlAPAssignment_2_1.eContents().get(0);
		private final Group cGroup_3 = (Group)cAlternatives.eContents().get(3);
		private final Action cNotFormulaAction_3_0 = (Action)cGroup_3.eContents().get(0);
		private final Keyword cNotKeyword_3_1 = (Keyword)cGroup_3.eContents().get(1);
		private final Assignment cFormulaAssignment_3_2 = (Assignment)cGroup_3.eContents().get(2);
		private final RuleCall cFormulaFormulaParserRuleCall_3_2_0 = (RuleCall)cFormulaAssignment_3_2.eContents().get(0);
		private final Group cGroup_4 = (Group)cAlternatives.eContents().get(4);
		private final Action cAndOrFormulaAction_4_0 = (Action)cGroup_4.eContents().get(0);
		private final Keyword cLeftParenthesisKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Assignment cLeftAssignment_4_2 = (Assignment)cGroup_4.eContents().get(2);
		private final RuleCall cLeftFormulaParserRuleCall_4_2_0 = (RuleCall)cLeftAssignment_4_2.eContents().get(0);
		private final Assignment cOpAssignment_4_3 = (Assignment)cGroup_4.eContents().get(3);
		private final RuleCall cOpAndOrEnumRuleCall_4_3_0 = (RuleCall)cOpAssignment_4_3.eContents().get(0);
		private final Assignment cRightAssignment_4_4 = (Assignment)cGroup_4.eContents().get(4);
		private final RuleCall cRightFormulaParserRuleCall_4_4_0 = (RuleCall)cRightAssignment_4_4.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4_5 = (Keyword)cGroup_4.eContents().get(5);
		private final Group cGroup_5 = (Group)cAlternatives.eContents().get(5);
		private final Action cIfThenFormulaAction_5_0 = (Action)cGroup_5.eContents().get(0);
		private final Keyword cIfKeyword_5_1 = (Keyword)cGroup_5.eContents().get(1);
		private final Assignment cLeftAssignment_5_2 = (Assignment)cGroup_5.eContents().get(2);
		private final RuleCall cLeftFormulaParserRuleCall_5_2_0 = (RuleCall)cLeftAssignment_5_2.eContents().get(0);
		private final Keyword cThenKeyword_5_3 = (Keyword)cGroup_5.eContents().get(3);
		private final Assignment cRightAssignment_5_4 = (Assignment)cGroup_5.eContents().get(4);
		private final RuleCall cRightFormulaParserRuleCall_5_4_0 = (RuleCall)cRightAssignment_5_4.eContents().get(0);
		private final Group cGroup_6 = (Group)cAlternatives.eContents().get(6);
		private final Action cGloballyUntimedFormulaAction_6_0 = (Action)cGroup_6.eContents().get(0);
		private final Keyword cGloballyKeyword_6_1 = (Keyword)cGroup_6.eContents().get(1);
		private final Assignment cFormulaAssignment_6_2 = (Assignment)cGroup_6.eContents().get(2);
		private final RuleCall cFormulaFormulaParserRuleCall_6_2_0 = (RuleCall)cFormulaAssignment_6_2.eContents().get(0);
		private final Group cGroup_7 = (Group)cAlternatives.eContents().get(7);
		private final Action cGloballyFormulaAction_7_0 = (Action)cGroup_7.eContents().get(0);
		private final Keyword cDuringKeyword_7_1 = (Keyword)cGroup_7.eContents().get(1);
		private final Assignment cIntervalAssignment_7_2 = (Assignment)cGroup_7.eContents().get(2);
		private final RuleCall cIntervalIntervalParserRuleCall_7_2_0 = (RuleCall)cIntervalAssignment_7_2.eContents().get(0);
		private final Assignment cFormulaAssignment_7_3 = (Assignment)cGroup_7.eContents().get(3);
		private final RuleCall cFormulaFormulaParserRuleCall_7_3_0 = (RuleCall)cFormulaAssignment_7_3.eContents().get(0);
		private final Group cGroup_8 = (Group)cAlternatives.eContents().get(8);
		private final Action cFinallyUntimedFormulaAction_8_0 = (Action)cGroup_8.eContents().get(0);
		private final Keyword cFinallyKeyword_8_1 = (Keyword)cGroup_8.eContents().get(1);
		private final Assignment cFormulaAssignment_8_2 = (Assignment)cGroup_8.eContents().get(2);
		private final RuleCall cFormulaFormulaParserRuleCall_8_2_0 = (RuleCall)cFormulaAssignment_8_2.eContents().get(0);
		private final Group cGroup_9 = (Group)cAlternatives.eContents().get(9);
		private final Action cFinallyFormulaAction_9_0 = (Action)cGroup_9.eContents().get(0);
		private final Keyword cWithinKeyword_9_1 = (Keyword)cGroup_9.eContents().get(1);
		private final Assignment cIntervalAssignment_9_2 = (Assignment)cGroup_9.eContents().get(2);
		private final RuleCall cIntervalIntervalParserRuleCall_9_2_0 = (RuleCall)cIntervalAssignment_9_2.eContents().get(0);
		private final Assignment cFormulaAssignment_9_3 = (Assignment)cGroup_9.eContents().get(3);
		private final RuleCall cFormulaFormulaParserRuleCall_9_3_0 = (RuleCall)cFormulaAssignment_9_3.eContents().get(0);
		private final Group cGroup_10 = (Group)cAlternatives.eContents().get(10);
		private final Action cUntilUntimedFormulaAction_10_0 = (Action)cGroup_10.eContents().get(0);
		private final Keyword cUntilKeyword_10_1 = (Keyword)cGroup_10.eContents().get(1);
		private final Assignment cRightAssignment_10_2 = (Assignment)cGroup_10.eContents().get(2);
		private final RuleCall cRightFormulaParserRuleCall_10_2_0 = (RuleCall)cRightAssignment_10_2.eContents().get(0);
		private final Keyword cWeKeyword_10_3 = (Keyword)cGroup_10.eContents().get(3);
		private final Keyword cHaveKeyword_10_4 = (Keyword)cGroup_10.eContents().get(4);
		private final Keyword cThatKeyword_10_5 = (Keyword)cGroup_10.eContents().get(5);
		private final Assignment cLeftAssignment_10_6 = (Assignment)cGroup_10.eContents().get(6);
		private final RuleCall cLeftFormulaParserRuleCall_10_6_0 = (RuleCall)cLeftAssignment_10_6.eContents().get(0);
		private final Group cGroup_11 = (Group)cAlternatives.eContents().get(11);
		private final Action cUntilFormulaAction_11_0 = (Action)cGroup_11.eContents().get(0);
		private final Keyword cByKeyword_11_1 = (Keyword)cGroup_11.eContents().get(1);
		private final Assignment cIntervalAssignment_11_2 = (Assignment)cGroup_11.eContents().get(2);
		private final RuleCall cIntervalIntervalParserRuleCall_11_2_0 = (RuleCall)cIntervalAssignment_11_2.eContents().get(0);
		private final Assignment cRightAssignment_11_3 = (Assignment)cGroup_11.eContents().get(3);
		private final RuleCall cRightFormulaParserRuleCall_11_3_0 = (RuleCall)cRightAssignment_11_3.eContents().get(0);
		private final Keyword cAndKeyword_11_4 = (Keyword)cGroup_11.eContents().get(4);
		private final Keyword cUntilKeyword_11_5 = (Keyword)cGroup_11.eContents().get(5);
		private final Keyword cThenKeyword_11_6 = (Keyword)cGroup_11.eContents().get(6);
		private final Assignment cLeftAssignment_11_7 = (Assignment)cGroup_11.eContents().get(7);
		private final RuleCall cLeftFormulaParserRuleCall_11_7_0 = (RuleCall)cLeftAssignment_11_7.eContents().get(0);
		
		//Formula:
		//	{ReferenceFormula} def=[Def] ('(' param=ID ('+' val=INT_T)? ')')?
		//	| {ApFormula} mtlAP=MtlAp
		//	| {ApFormula} stlAP=StlAp
		//	| {NotFormula} 'not' formula=Formula
		//	| {AndOrFormula} '(' left=Formula op=AndOr right=Formula ')'
		//	| {IfThenFormula} 'if' left=Formula 'then' right=Formula
		//	| {GloballyUntimedFormula} 'globally' formula=Formula
		//	| {GloballyFormula} 'during' interval=Interval formula=Formula
		//	| {FinallyUntimedFormula} 'finally' formula=Formula
		//	| {FinallyFormula} 'within' interval=Interval formula=Formula
		//	| {UntilUntimedFormula} 'until' right=Formula 'we' 'have' 'that' left=Formula
		//	| {UntilFormula} 'by' interval=Interval right=Formula 'and' 'until' 'then' left=Formula;
		@Override public ParserRule getRule() { return rule; }
		
		//{ReferenceFormula} def=[Def] ('(' param=ID ('+' val=INT_T)? ')')? | {ApFormula} mtlAP=MtlAp | {ApFormula} stlAP=StlAp |
		//{NotFormula} 'not' formula=Formula | {AndOrFormula} '(' left=Formula op=AndOr right=Formula ')' | {IfThenFormula} 'if'
		//left=Formula 'then' right=Formula | {GloballyUntimedFormula} 'globally' formula=Formula | {GloballyFormula} 'during'
		//interval=Interval formula=Formula | {FinallyUntimedFormula} 'finally' formula=Formula | {FinallyFormula} 'within'
		//interval=Interval formula=Formula | {UntilUntimedFormula} 'until' right=Formula 'we' 'have' 'that' left=Formula |
		//{UntilFormula} 'by' interval=Interval right=Formula 'and' 'until' 'then' left=Formula
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//{ReferenceFormula} def=[Def] ('(' param=ID ('+' val=INT_T)? ')')?
		public Group getGroup_0() { return cGroup_0; }
		
		//{ReferenceFormula}
		public Action getReferenceFormulaAction_0_0() { return cReferenceFormulaAction_0_0; }
		
		//def=[Def]
		public Assignment getDefAssignment_0_1() { return cDefAssignment_0_1; }
		
		//[Def]
		public CrossReference getDefDefCrossReference_0_1_0() { return cDefDefCrossReference_0_1_0; }
		
		//ID
		public RuleCall getDefDefIDTerminalRuleCall_0_1_0_1() { return cDefDefIDTerminalRuleCall_0_1_0_1; }
		
		//('(' param=ID ('+' val=INT_T)? ')')?
		public Group getGroup_0_2() { return cGroup_0_2; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_0_2_0() { return cLeftParenthesisKeyword_0_2_0; }
		
		//param=ID
		public Assignment getParamAssignment_0_2_1() { return cParamAssignment_0_2_1; }
		
		//ID
		public RuleCall getParamIDTerminalRuleCall_0_2_1_0() { return cParamIDTerminalRuleCall_0_2_1_0; }
		
		//('+' val=INT_T)?
		public Group getGroup_0_2_2() { return cGroup_0_2_2; }
		
		//'+'
		public Keyword getPlusSignKeyword_0_2_2_0() { return cPlusSignKeyword_0_2_2_0; }
		
		//val=INT_T
		public Assignment getValAssignment_0_2_2_1() { return cValAssignment_0_2_2_1; }
		
		//INT_T
		public RuleCall getValINT_TTerminalRuleCall_0_2_2_1_0() { return cValINT_TTerminalRuleCall_0_2_2_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_0_2_3() { return cRightParenthesisKeyword_0_2_3; }
		
		//{ApFormula} mtlAP=MtlAp
		public Group getGroup_1() { return cGroup_1; }
		
		//{ApFormula}
		public Action getApFormulaAction_1_0() { return cApFormulaAction_1_0; }
		
		//mtlAP=MtlAp
		public Assignment getMtlAPAssignment_1_1() { return cMtlAPAssignment_1_1; }
		
		//MtlAp
		public RuleCall getMtlAPMtlApParserRuleCall_1_1_0() { return cMtlAPMtlApParserRuleCall_1_1_0; }
		
		//{ApFormula} stlAP=StlAp
		public Group getGroup_2() { return cGroup_2; }
		
		//{ApFormula}
		public Action getApFormulaAction_2_0() { return cApFormulaAction_2_0; }
		
		//stlAP=StlAp
		public Assignment getStlAPAssignment_2_1() { return cStlAPAssignment_2_1; }
		
		//StlAp
		public RuleCall getStlAPStlApParserRuleCall_2_1_0() { return cStlAPStlApParserRuleCall_2_1_0; }
		
		//{NotFormula} 'not' formula=Formula
		public Group getGroup_3() { return cGroup_3; }
		
		//{NotFormula}
		public Action getNotFormulaAction_3_0() { return cNotFormulaAction_3_0; }
		
		//'not'
		public Keyword getNotKeyword_3_1() { return cNotKeyword_3_1; }
		
		//formula=Formula
		public Assignment getFormulaAssignment_3_2() { return cFormulaAssignment_3_2; }
		
		//Formula
		public RuleCall getFormulaFormulaParserRuleCall_3_2_0() { return cFormulaFormulaParserRuleCall_3_2_0; }
		
		//{AndOrFormula} '(' left=Formula op=AndOr right=Formula ')'
		public Group getGroup_4() { return cGroup_4; }
		
		//{AndOrFormula}
		public Action getAndOrFormulaAction_4_0() { return cAndOrFormulaAction_4_0; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_4_1() { return cLeftParenthesisKeyword_4_1; }
		
		//left=Formula
		public Assignment getLeftAssignment_4_2() { return cLeftAssignment_4_2; }
		
		//Formula
		public RuleCall getLeftFormulaParserRuleCall_4_2_0() { return cLeftFormulaParserRuleCall_4_2_0; }
		
		//op=AndOr
		public Assignment getOpAssignment_4_3() { return cOpAssignment_4_3; }
		
		//AndOr
		public RuleCall getOpAndOrEnumRuleCall_4_3_0() { return cOpAndOrEnumRuleCall_4_3_0; }
		
		//right=Formula
		public Assignment getRightAssignment_4_4() { return cRightAssignment_4_4; }
		
		//Formula
		public RuleCall getRightFormulaParserRuleCall_4_4_0() { return cRightFormulaParserRuleCall_4_4_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_4_5() { return cRightParenthesisKeyword_4_5; }
		
		//{IfThenFormula} 'if' left=Formula 'then' right=Formula
		public Group getGroup_5() { return cGroup_5; }
		
		//{IfThenFormula}
		public Action getIfThenFormulaAction_5_0() { return cIfThenFormulaAction_5_0; }
		
		//'if'
		public Keyword getIfKeyword_5_1() { return cIfKeyword_5_1; }
		
		//left=Formula
		public Assignment getLeftAssignment_5_2() { return cLeftAssignment_5_2; }
		
		//Formula
		public RuleCall getLeftFormulaParserRuleCall_5_2_0() { return cLeftFormulaParserRuleCall_5_2_0; }
		
		//'then'
		public Keyword getThenKeyword_5_3() { return cThenKeyword_5_3; }
		
		//right=Formula
		public Assignment getRightAssignment_5_4() { return cRightAssignment_5_4; }
		
		//Formula
		public RuleCall getRightFormulaParserRuleCall_5_4_0() { return cRightFormulaParserRuleCall_5_4_0; }
		
		//{GloballyUntimedFormula} 'globally' formula=Formula
		public Group getGroup_6() { return cGroup_6; }
		
		//{GloballyUntimedFormula}
		public Action getGloballyUntimedFormulaAction_6_0() { return cGloballyUntimedFormulaAction_6_0; }
		
		//'globally'
		public Keyword getGloballyKeyword_6_1() { return cGloballyKeyword_6_1; }
		
		//formula=Formula
		public Assignment getFormulaAssignment_6_2() { return cFormulaAssignment_6_2; }
		
		//Formula
		public RuleCall getFormulaFormulaParserRuleCall_6_2_0() { return cFormulaFormulaParserRuleCall_6_2_0; }
		
		//{GloballyFormula} 'during' interval=Interval formula=Formula
		public Group getGroup_7() { return cGroup_7; }
		
		//{GloballyFormula}
		public Action getGloballyFormulaAction_7_0() { return cGloballyFormulaAction_7_0; }
		
		//'during'
		public Keyword getDuringKeyword_7_1() { return cDuringKeyword_7_1; }
		
		//interval=Interval
		public Assignment getIntervalAssignment_7_2() { return cIntervalAssignment_7_2; }
		
		//Interval
		public RuleCall getIntervalIntervalParserRuleCall_7_2_0() { return cIntervalIntervalParserRuleCall_7_2_0; }
		
		//formula=Formula
		public Assignment getFormulaAssignment_7_3() { return cFormulaAssignment_7_3; }
		
		//Formula
		public RuleCall getFormulaFormulaParserRuleCall_7_3_0() { return cFormulaFormulaParserRuleCall_7_3_0; }
		
		//{FinallyUntimedFormula} 'finally' formula=Formula
		public Group getGroup_8() { return cGroup_8; }
		
		//{FinallyUntimedFormula}
		public Action getFinallyUntimedFormulaAction_8_0() { return cFinallyUntimedFormulaAction_8_0; }
		
		//'finally'
		public Keyword getFinallyKeyword_8_1() { return cFinallyKeyword_8_1; }
		
		//formula=Formula
		public Assignment getFormulaAssignment_8_2() { return cFormulaAssignment_8_2; }
		
		//Formula
		public RuleCall getFormulaFormulaParserRuleCall_8_2_0() { return cFormulaFormulaParserRuleCall_8_2_0; }
		
		//{FinallyFormula} 'within' interval=Interval formula=Formula
		public Group getGroup_9() { return cGroup_9; }
		
		//{FinallyFormula}
		public Action getFinallyFormulaAction_9_0() { return cFinallyFormulaAction_9_0; }
		
		//'within'
		public Keyword getWithinKeyword_9_1() { return cWithinKeyword_9_1; }
		
		//interval=Interval
		public Assignment getIntervalAssignment_9_2() { return cIntervalAssignment_9_2; }
		
		//Interval
		public RuleCall getIntervalIntervalParserRuleCall_9_2_0() { return cIntervalIntervalParserRuleCall_9_2_0; }
		
		//formula=Formula
		public Assignment getFormulaAssignment_9_3() { return cFormulaAssignment_9_3; }
		
		//Formula
		public RuleCall getFormulaFormulaParserRuleCall_9_3_0() { return cFormulaFormulaParserRuleCall_9_3_0; }
		
		//{UntilUntimedFormula} 'until' right=Formula 'we' 'have' 'that' left=Formula
		public Group getGroup_10() { return cGroup_10; }
		
		//{UntilUntimedFormula}
		public Action getUntilUntimedFormulaAction_10_0() { return cUntilUntimedFormulaAction_10_0; }
		
		//'until'
		public Keyword getUntilKeyword_10_1() { return cUntilKeyword_10_1; }
		
		//right=Formula
		public Assignment getRightAssignment_10_2() { return cRightAssignment_10_2; }
		
		//Formula
		public RuleCall getRightFormulaParserRuleCall_10_2_0() { return cRightFormulaParserRuleCall_10_2_0; }
		
		//'we'
		public Keyword getWeKeyword_10_3() { return cWeKeyword_10_3; }
		
		//'have'
		public Keyword getHaveKeyword_10_4() { return cHaveKeyword_10_4; }
		
		//'that'
		public Keyword getThatKeyword_10_5() { return cThatKeyword_10_5; }
		
		//left=Formula
		public Assignment getLeftAssignment_10_6() { return cLeftAssignment_10_6; }
		
		//Formula
		public RuleCall getLeftFormulaParserRuleCall_10_6_0() { return cLeftFormulaParserRuleCall_10_6_0; }
		
		//{UntilFormula} 'by' interval=Interval right=Formula 'and' 'until' 'then' left=Formula
		public Group getGroup_11() { return cGroup_11; }
		
		//{UntilFormula}
		public Action getUntilFormulaAction_11_0() { return cUntilFormulaAction_11_0; }
		
		//'by'
		public Keyword getByKeyword_11_1() { return cByKeyword_11_1; }
		
		//interval=Interval
		public Assignment getIntervalAssignment_11_2() { return cIntervalAssignment_11_2; }
		
		//Interval
		public RuleCall getIntervalIntervalParserRuleCall_11_2_0() { return cIntervalIntervalParserRuleCall_11_2_0; }
		
		//right=Formula
		public Assignment getRightAssignment_11_3() { return cRightAssignment_11_3; }
		
		//Formula
		public RuleCall getRightFormulaParserRuleCall_11_3_0() { return cRightFormulaParserRuleCall_11_3_0; }
		
		//'and'
		public Keyword getAndKeyword_11_4() { return cAndKeyword_11_4; }
		
		//'until'
		public Keyword getUntilKeyword_11_5() { return cUntilKeyword_11_5; }
		
		//'then'
		public Keyword getThenKeyword_11_6() { return cThenKeyword_11_6; }
		
		//left=Formula
		public Assignment getLeftAssignment_11_7() { return cLeftAssignment_11_7; }
		
		//Formula
		public RuleCall getLeftFormulaParserRuleCall_11_7_0() { return cLeftFormulaParserRuleCall_11_7_0; }
	}
	public class StlApElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.StlAp");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Assignment cRefAssignment_0_0 = (Assignment)cAlternatives_0.eContents().get(0);
		private final CrossReference cRefSignalDefCrossReference_0_0_0 = (CrossReference)cRefAssignment_0_0.eContents().get(0);
		private final RuleCall cRefSignalDefIDTerminalRuleCall_0_0_0_1 = (RuleCall)cRefSignalDefCrossReference_0_0_0.eContents().get(1);
		private final Group cGroup_0_1 = (Group)cAlternatives_0.eContents().get(1);
		private final Action cStlApDerivAction_0_1_0 = (Action)cGroup_0_1.eContents().get(0);
		private final Keyword cDKeyword_0_1_1 = (Keyword)cGroup_0_1.eContents().get(1);
		private final Assignment cRefAssignment_0_1_2 = (Assignment)cGroup_0_1.eContents().get(2);
		private final CrossReference cRefSignalDefCrossReference_0_1_2_0 = (CrossReference)cRefAssignment_0_1_2.eContents().get(0);
		private final RuleCall cRefSignalDefIDTerminalRuleCall_0_1_2_0_1 = (RuleCall)cRefSignalDefCrossReference_0_1_2_0.eContents().get(1);
		private final Keyword cSolidusKeyword_0_1_3 = (Keyword)cGroup_0_1.eContents().get(3);
		private final Keyword cDtKeyword_0_1_4 = (Keyword)cGroup_0_1.eContents().get(4);
		private final Assignment cCompOpAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cCompOpCompOpEnumRuleCall_1_0 = (RuleCall)cCompOpAssignment_1.eContents().get(0);
		private final Assignment cValAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValDOUBLE_TTerminalRuleCall_2_0 = (RuleCall)cValAssignment_2.eContents().get(0);
		
		//StlAp:
		//	(ref=[SignalDef] | {StlApDeriv} 'd' ref=[SignalDef] '/' 'dt') compOp=CompOp val=DOUBLE_T;
		@Override public ParserRule getRule() { return rule; }
		
		//(ref=[SignalDef] | {StlApDeriv} 'd' ref=[SignalDef] '/' 'dt') compOp=CompOp val=DOUBLE_T
		public Group getGroup() { return cGroup; }
		
		//(ref=[SignalDef] | {StlApDeriv} 'd' ref=[SignalDef] '/' 'dt')
		public Alternatives getAlternatives_0() { return cAlternatives_0; }
		
		//ref=[SignalDef]
		public Assignment getRefAssignment_0_0() { return cRefAssignment_0_0; }
		
		//[SignalDef]
		public CrossReference getRefSignalDefCrossReference_0_0_0() { return cRefSignalDefCrossReference_0_0_0; }
		
		//ID
		public RuleCall getRefSignalDefIDTerminalRuleCall_0_0_0_1() { return cRefSignalDefIDTerminalRuleCall_0_0_0_1; }
		
		//{StlApDeriv} 'd' ref=[SignalDef] '/' 'dt'
		public Group getGroup_0_1() { return cGroup_0_1; }
		
		//{StlApDeriv}
		public Action getStlApDerivAction_0_1_0() { return cStlApDerivAction_0_1_0; }
		
		//'d'
		public Keyword getDKeyword_0_1_1() { return cDKeyword_0_1_1; }
		
		//ref=[SignalDef]
		public Assignment getRefAssignment_0_1_2() { return cRefAssignment_0_1_2; }
		
		//[SignalDef]
		public CrossReference getRefSignalDefCrossReference_0_1_2_0() { return cRefSignalDefCrossReference_0_1_2_0; }
		
		//ID
		public RuleCall getRefSignalDefIDTerminalRuleCall_0_1_2_0_1() { return cRefSignalDefIDTerminalRuleCall_0_1_2_0_1; }
		
		//'/'
		public Keyword getSolidusKeyword_0_1_3() { return cSolidusKeyword_0_1_3; }
		
		//'dt'
		public Keyword getDtKeyword_0_1_4() { return cDtKeyword_0_1_4; }
		
		//compOp=CompOp
		public Assignment getCompOpAssignment_1() { return cCompOpAssignment_1; }
		
		//CompOp
		public RuleCall getCompOpCompOpEnumRuleCall_1_0() { return cCompOpCompOpEnumRuleCall_1_0; }
		
		//val=DOUBLE_T
		public Assignment getValAssignment_2() { return cValAssignment_2; }
		
		//DOUBLE_T
		public RuleCall getValDOUBLE_TTerminalRuleCall_2_0() { return cValDOUBLE_TTerminalRuleCall_2_0; }
	}
	public class MtlApElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.MtlAp");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Group cGroup_0_0 = (Group)cAlternatives_0.eContents().get(0);
		private final Action cMtlApStartAction_0_0_0 = (Action)cGroup_0_0.eContents().get(0);
		private final Keyword cStartKeyword_0_0_1 = (Keyword)cGroup_0_0.eContents().get(1);
		private final Group cGroup_0_1 = (Group)cAlternatives_0.eContents().get(1);
		private final Action cMtlApEndAction_0_1_0 = (Action)cGroup_0_1.eContents().get(0);
		private final Keyword cEndKeyword_0_1_1 = (Keyword)cGroup_0_1.eContents().get(1);
		private final Assignment cFilterAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cFilterAttributeFilterParserRuleCall_1_0 = (RuleCall)cFilterAssignment_1.eContents().get(0);
		
		//MtlAp:
		//	({MtlApStart} 'start' | {MtlApEnd} 'end')? filter=AttributeFilter;
		@Override public ParserRule getRule() { return rule; }
		
		//({MtlApStart} 'start' | {MtlApEnd} 'end')? filter=AttributeFilter
		public Group getGroup() { return cGroup; }
		
		//({MtlApStart} 'start' | {MtlApEnd} 'end')?
		public Alternatives getAlternatives_0() { return cAlternatives_0; }
		
		//{MtlApStart} 'start'
		public Group getGroup_0_0() { return cGroup_0_0; }
		
		//{MtlApStart}
		public Action getMtlApStartAction_0_0_0() { return cMtlApStartAction_0_0_0; }
		
		//'start'
		public Keyword getStartKeyword_0_0_1() { return cStartKeyword_0_0_1; }
		
		//{MtlApEnd} 'end'
		public Group getGroup_0_1() { return cGroup_0_1; }
		
		//{MtlApEnd}
		public Action getMtlApEndAction_0_1_0() { return cMtlApEndAction_0_1_0; }
		
		//'end'
		public Keyword getEndKeyword_0_1_1() { return cEndKeyword_0_1_1; }
		
		//filter=AttributeFilter
		public Assignment getFilterAssignment_1() { return cFilterAssignment_1; }
		
		//AttributeFilter
		public RuleCall getFilterAttributeFilterParserRuleCall_1_0() { return cFilterAttributeFilterParserRuleCall_1_0; }
	}
	public class AttributeFilterElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.AttributeFilter");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftCurlyBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cKeyValsAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cKeyValsKeyValParserRuleCall_1_0 = (RuleCall)cKeyValsAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cGroup.eContents().get(2);
		private final Keyword cCommaKeyword_2_0 = (Keyword)cGroup_2.eContents().get(0);
		private final Assignment cKeyValsAssignment_2_1 = (Assignment)cGroup_2.eContents().get(1);
		private final RuleCall cKeyValsKeyValParserRuleCall_2_1_0 = (RuleCall)cKeyValsAssignment_2_1.eContents().get(0);
		private final Keyword cRightCurlyBracketKeyword_3 = (Keyword)cGroup.eContents().get(3);
		
		//AttributeFilter:
		//	'{' keyVals+=KeyVal (',' keyVals+=KeyVal)* '}';
		@Override public ParserRule getRule() { return rule; }
		
		//'{' keyVals+=KeyVal (',' keyVals+=KeyVal)* '}'
		public Group getGroup() { return cGroup; }
		
		//'{'
		public Keyword getLeftCurlyBracketKeyword_0() { return cLeftCurlyBracketKeyword_0; }
		
		//keyVals+=KeyVal
		public Assignment getKeyValsAssignment_1() { return cKeyValsAssignment_1; }
		
		//KeyVal
		public RuleCall getKeyValsKeyValParserRuleCall_1_0() { return cKeyValsKeyValParserRuleCall_1_0; }
		
		//(',' keyVals+=KeyVal)*
		public Group getGroup_2() { return cGroup_2; }
		
		//','
		public Keyword getCommaKeyword_2_0() { return cCommaKeyword_2_0; }
		
		//keyVals+=KeyVal
		public Assignment getKeyValsAssignment_2_1() { return cKeyValsAssignment_2_1; }
		
		//KeyVal
		public RuleCall getKeyValsKeyValParserRuleCall_2_1_0() { return cKeyValsKeyValParserRuleCall_2_1_0; }
		
		//'}'
		public Keyword getRightCurlyBracketKeyword_3() { return cRightCurlyBracketKeyword_3; }
	}
	public class KeyValElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.KeyVal");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Assignment cAttAssignment_0 = (Assignment)cGroup.eContents().get(0);
		private final RuleCall cAttIdStringParserRuleCall_0_0 = (RuleCall)cAttAssignment_0.eContents().get(0);
		private final Keyword cEqualsSignKeyword_1 = (Keyword)cGroup.eContents().get(1);
		private final Assignment cValAssignment_2 = (Assignment)cGroup.eContents().get(2);
		private final RuleCall cValIdStringParserRuleCall_2_0 = (RuleCall)cValAssignment_2.eContents().get(0);
		
		//KeyVal:
		//	att=IdString '=' val=IdString;
		@Override public ParserRule getRule() { return rule; }
		
		//att=IdString '=' val=IdString
		public Group getGroup() { return cGroup; }
		
		//att=IdString
		public Assignment getAttAssignment_0() { return cAttAssignment_0; }
		
		//IdString
		public RuleCall getAttIdStringParserRuleCall_0_0() { return cAttIdStringParserRuleCall_0_0; }
		
		//'='
		public Keyword getEqualsSignKeyword_1() { return cEqualsSignKeyword_1; }
		
		//val=IdString
		public Assignment getValAssignment_2() { return cValAssignment_2; }
		
		//IdString
		public RuleCall getValIdStringParserRuleCall_2_0() { return cValIdStringParserRuleCall_2_0; }
	}
	public class IdStringElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.IdString");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final Assignment cLeftAssignment_0 = (Assignment)cAlternatives.eContents().get(0);
		private final RuleCall cLeftSTRINGTerminalRuleCall_0_0 = (RuleCall)cLeftAssignment_0.eContents().get(0);
		private final Assignment cIdAssignment_1 = (Assignment)cAlternatives.eContents().get(1);
		private final RuleCall cIdIDTerminalRuleCall_1_0 = (RuleCall)cIdAssignment_1.eContents().get(0);
		private final Group cGroup_2 = (Group)cAlternatives.eContents().get(2);
		private final Assignment cLeftAssignment_2_0 = (Assignment)cGroup_2.eContents().get(0);
		private final RuleCall cLeftSTRINGTerminalRuleCall_2_0_0 = (RuleCall)cLeftAssignment_2_0.eContents().get(0);
		private final Keyword cPlusSignKeyword_2_1 = (Keyword)cGroup_2.eContents().get(1);
		private final Assignment cIdAssignment_2_2 = (Assignment)cGroup_2.eContents().get(2);
		private final RuleCall cIdIDTerminalRuleCall_2_2_0 = (RuleCall)cIdAssignment_2_2.eContents().get(0);
		private final Group cGroup_3 = (Group)cAlternatives.eContents().get(3);
		private final Assignment cIdAssignment_3_0 = (Assignment)cGroup_3.eContents().get(0);
		private final RuleCall cIdIDTerminalRuleCall_3_0_0 = (RuleCall)cIdAssignment_3_0.eContents().get(0);
		private final Keyword cPlusSignKeyword_3_1 = (Keyword)cGroup_3.eContents().get(1);
		private final Assignment cRightAssignment_3_2 = (Assignment)cGroup_3.eContents().get(2);
		private final RuleCall cRightSTRINGTerminalRuleCall_3_2_0 = (RuleCall)cRightAssignment_3_2.eContents().get(0);
		private final Group cGroup_4 = (Group)cAlternatives.eContents().get(4);
		private final Assignment cLeftAssignment_4_0 = (Assignment)cGroup_4.eContents().get(0);
		private final RuleCall cLeftSTRINGTerminalRuleCall_4_0_0 = (RuleCall)cLeftAssignment_4_0.eContents().get(0);
		private final Keyword cPlusSignKeyword_4_1 = (Keyword)cGroup_4.eContents().get(1);
		private final Assignment cIdAssignment_4_2 = (Assignment)cGroup_4.eContents().get(2);
		private final RuleCall cIdIDTerminalRuleCall_4_2_0 = (RuleCall)cIdAssignment_4_2.eContents().get(0);
		private final Keyword cPlusSignKeyword_4_3 = (Keyword)cGroup_4.eContents().get(3);
		private final Assignment cRightAssignment_4_4 = (Assignment)cGroup_4.eContents().get(4);
		private final RuleCall cRightSTRINGTerminalRuleCall_4_4_0 = (RuleCall)cRightAssignment_4_4.eContents().get(0);
		
		//IdString:
		//	left=STRING | id=ID | left=STRING '+' id=ID | id=ID '+' right=STRING | left=STRING '+' id=ID '+' right=STRING;
		@Override public ParserRule getRule() { return rule; }
		
		//left=STRING | id=ID | left=STRING '+' id=ID | id=ID '+' right=STRING | left=STRING '+' id=ID '+' right=STRING
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//left=STRING
		public Assignment getLeftAssignment_0() { return cLeftAssignment_0; }
		
		//STRING
		public RuleCall getLeftSTRINGTerminalRuleCall_0_0() { return cLeftSTRINGTerminalRuleCall_0_0; }
		
		//id=ID
		public Assignment getIdAssignment_1() { return cIdAssignment_1; }
		
		//ID
		public RuleCall getIdIDTerminalRuleCall_1_0() { return cIdIDTerminalRuleCall_1_0; }
		
		//left=STRING '+' id=ID
		public Group getGroup_2() { return cGroup_2; }
		
		//left=STRING
		public Assignment getLeftAssignment_2_0() { return cLeftAssignment_2_0; }
		
		//STRING
		public RuleCall getLeftSTRINGTerminalRuleCall_2_0_0() { return cLeftSTRINGTerminalRuleCall_2_0_0; }
		
		//'+'
		public Keyword getPlusSignKeyword_2_1() { return cPlusSignKeyword_2_1; }
		
		//id=ID
		public Assignment getIdAssignment_2_2() { return cIdAssignment_2_2; }
		
		//ID
		public RuleCall getIdIDTerminalRuleCall_2_2_0() { return cIdIDTerminalRuleCall_2_2_0; }
		
		//id=ID '+' right=STRING
		public Group getGroup_3() { return cGroup_3; }
		
		//id=ID
		public Assignment getIdAssignment_3_0() { return cIdAssignment_3_0; }
		
		//ID
		public RuleCall getIdIDTerminalRuleCall_3_0_0() { return cIdIDTerminalRuleCall_3_0_0; }
		
		//'+'
		public Keyword getPlusSignKeyword_3_1() { return cPlusSignKeyword_3_1; }
		
		//right=STRING
		public Assignment getRightAssignment_3_2() { return cRightAssignment_3_2; }
		
		//STRING
		public RuleCall getRightSTRINGTerminalRuleCall_3_2_0() { return cRightSTRINGTerminalRuleCall_3_2_0; }
		
		//left=STRING '+' id=ID '+' right=STRING
		public Group getGroup_4() { return cGroup_4; }
		
		//left=STRING
		public Assignment getLeftAssignment_4_0() { return cLeftAssignment_4_0; }
		
		//STRING
		public RuleCall getLeftSTRINGTerminalRuleCall_4_0_0() { return cLeftSTRINGTerminalRuleCall_4_0_0; }
		
		//'+'
		public Keyword getPlusSignKeyword_4_1() { return cPlusSignKeyword_4_1; }
		
		//id=ID
		public Assignment getIdAssignment_4_2() { return cIdAssignment_4_2; }
		
		//ID
		public RuleCall getIdIDTerminalRuleCall_4_2_0() { return cIdIDTerminalRuleCall_4_2_0; }
		
		//'+'
		public Keyword getPlusSignKeyword_4_3() { return cPlusSignKeyword_4_3; }
		
		//right=STRING
		public Assignment getRightAssignment_4_4() { return cRightAssignment_4_4; }
		
		//STRING
		public RuleCall getRightSTRINGTerminalRuleCall_4_4_0() { return cRightSTRINGTerminalRuleCall_4_4_0; }
	}
	public class IntervalElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.Interval");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Alternatives cAlternatives_0 = (Alternatives)cGroup.eContents().get(0);
		private final Assignment cIssAssignment_0_0 = (Assignment)cAlternatives_0.eContents().get(0);
		private final RuleCall cIssIntervalSSParserRuleCall_0_0_0 = (RuleCall)cIssAssignment_0_0.eContents().get(0);
		private final Assignment cIsnAssignment_0_1 = (Assignment)cAlternatives_0.eContents().get(1);
		private final RuleCall cIsnIntervalSNParserRuleCall_0_1_0 = (RuleCall)cIsnAssignment_0_1.eContents().get(0);
		private final Assignment cInsAssignment_0_2 = (Assignment)cAlternatives_0.eContents().get(2);
		private final RuleCall cInsIntervalNSParserRuleCall_0_2_0 = (RuleCall)cInsAssignment_0_2.eContents().get(0);
		private final Assignment cInnAssignment_0_3 = (Assignment)cAlternatives_0.eContents().get(3);
		private final RuleCall cInnIntervalNNParserRuleCall_0_3_0 = (RuleCall)cInnAssignment_0_3.eContents().get(0);
		private final Assignment cTimeUnitAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cTimeUnitTimeUnitEnumEnumRuleCall_1_0 = (RuleCall)cTimeUnitAssignment_1.eContents().get(0);
		
		//Interval:
		//	(iss=IntervalSS | isn=IntervalSN | ins=IntervalNS | inn=IntervalNN) timeUnit=TimeUnitEnum;
		@Override public ParserRule getRule() { return rule; }
		
		//(iss=IntervalSS | isn=IntervalSN | ins=IntervalNS | inn=IntervalNN) timeUnit=TimeUnitEnum
		public Group getGroup() { return cGroup; }
		
		//(iss=IntervalSS | isn=IntervalSN | ins=IntervalNS | inn=IntervalNN)
		public Alternatives getAlternatives_0() { return cAlternatives_0; }
		
		//iss=IntervalSS
		public Assignment getIssAssignment_0_0() { return cIssAssignment_0_0; }
		
		//IntervalSS
		public RuleCall getIssIntervalSSParserRuleCall_0_0_0() { return cIssIntervalSSParserRuleCall_0_0_0; }
		
		//isn=IntervalSN
		public Assignment getIsnAssignment_0_1() { return cIsnAssignment_0_1; }
		
		//IntervalSN
		public RuleCall getIsnIntervalSNParserRuleCall_0_1_0() { return cIsnIntervalSNParserRuleCall_0_1_0; }
		
		//ins=IntervalNS
		public Assignment getInsAssignment_0_2() { return cInsAssignment_0_2; }
		
		//IntervalNS
		public RuleCall getInsIntervalNSParserRuleCall_0_2_0() { return cInsIntervalNSParserRuleCall_0_2_0; }
		
		//inn=IntervalNN
		public Assignment getInnAssignment_0_3() { return cInnAssignment_0_3; }
		
		//IntervalNN
		public RuleCall getInnIntervalNNParserRuleCall_0_3_0() { return cInnIntervalNNParserRuleCall_0_3_0; }
		
		//timeUnit=TimeUnitEnum
		public Assignment getTimeUnitAssignment_1() { return cTimeUnitAssignment_1; }
		
		//TimeUnitEnum
		public RuleCall getTimeUnitTimeUnitEnumEnumRuleCall_1_0() { return cTimeUnitTimeUnitEnumEnumRuleCall_1_0; }
	}
	public class IntervalSSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.IntervalSS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cLbAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cLbDOUBLE_TTerminalRuleCall_1_0 = (RuleCall)cLbAssignment_1.eContents().get(0);
		private final Keyword cCommaKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cUbAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cUbDOUBLE_TTerminalRuleCall_3_0_0 = (RuleCall)cUbAssignment_3_0.eContents().get(0);
		private final Assignment cInftyAssignment_3_1 = (Assignment)cAlternatives_3.eContents().get(1);
		private final Keyword cInftyInftyKeyword_3_1_0 = (Keyword)cInftyAssignment_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//IntervalSS:
		//	'(' lb=DOUBLE_T ',' (ub=DOUBLE_T | infty='Infty') ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'(' lb=DOUBLE_T ',' (ub=DOUBLE_T | infty='Infty') ')'
		public Group getGroup() { return cGroup; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_0() { return cLeftParenthesisKeyword_0; }
		
		//lb=DOUBLE_T
		public Assignment getLbAssignment_1() { return cLbAssignment_1; }
		
		//DOUBLE_T
		public RuleCall getLbDOUBLE_TTerminalRuleCall_1_0() { return cLbDOUBLE_TTerminalRuleCall_1_0; }
		
		//','
		public Keyword getCommaKeyword_2() { return cCommaKeyword_2; }
		
		//(ub=DOUBLE_T | infty='Infty')
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//ub=DOUBLE_T
		public Assignment getUbAssignment_3_0() { return cUbAssignment_3_0; }
		
		//DOUBLE_T
		public RuleCall getUbDOUBLE_TTerminalRuleCall_3_0_0() { return cUbDOUBLE_TTerminalRuleCall_3_0_0; }
		
		//infty='Infty'
		public Assignment getInftyAssignment_3_1() { return cInftyAssignment_3_1; }
		
		//'Infty'
		public Keyword getInftyInftyKeyword_3_1_0() { return cInftyInftyKeyword_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_4() { return cRightParenthesisKeyword_4; }
	}
	public class IntervalSNElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.IntervalSN");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftParenthesisKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cLbAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cLbDOUBLE_TTerminalRuleCall_1_0 = (RuleCall)cLbAssignment_1.eContents().get(0);
		private final Keyword cCommaKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cUbAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cUbDOUBLE_TTerminalRuleCall_3_0 = (RuleCall)cUbAssignment_3.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//IntervalSN:
		//	'(' lb=DOUBLE_T ',' ub=DOUBLE_T ']';
		@Override public ParserRule getRule() { return rule; }
		
		//'(' lb=DOUBLE_T ',' ub=DOUBLE_T ']'
		public Group getGroup() { return cGroup; }
		
		//'('
		public Keyword getLeftParenthesisKeyword_0() { return cLeftParenthesisKeyword_0; }
		
		//lb=DOUBLE_T
		public Assignment getLbAssignment_1() { return cLbAssignment_1; }
		
		//DOUBLE_T
		public RuleCall getLbDOUBLE_TTerminalRuleCall_1_0() { return cLbDOUBLE_TTerminalRuleCall_1_0; }
		
		//','
		public Keyword getCommaKeyword_2() { return cCommaKeyword_2; }
		
		//ub=DOUBLE_T
		public Assignment getUbAssignment_3() { return cUbAssignment_3; }
		
		//DOUBLE_T
		public RuleCall getUbDOUBLE_TTerminalRuleCall_3_0() { return cUbDOUBLE_TTerminalRuleCall_3_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_4() { return cRightSquareBracketKeyword_4; }
	}
	public class IntervalNSElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.IntervalNS");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftSquareBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cLbAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cLbDOUBLE_TTerminalRuleCall_1_0 = (RuleCall)cLbAssignment_1.eContents().get(0);
		private final Keyword cCommaKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Alternatives cAlternatives_3 = (Alternatives)cGroup.eContents().get(3);
		private final Assignment cUbAssignment_3_0 = (Assignment)cAlternatives_3.eContents().get(0);
		private final RuleCall cUbDOUBLE_TTerminalRuleCall_3_0_0 = (RuleCall)cUbAssignment_3_0.eContents().get(0);
		private final Assignment cInftyAssignment_3_1 = (Assignment)cAlternatives_3.eContents().get(1);
		private final Keyword cInftyInftyKeyword_3_1_0 = (Keyword)cInftyAssignment_3_1.eContents().get(0);
		private final Keyword cRightParenthesisKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//IntervalNS:
		//	'[' lb=DOUBLE_T ',' (ub=DOUBLE_T | infty='Infty') ')';
		@Override public ParserRule getRule() { return rule; }
		
		//'[' lb=DOUBLE_T ',' (ub=DOUBLE_T | infty='Infty') ')'
		public Group getGroup() { return cGroup; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_0() { return cLeftSquareBracketKeyword_0; }
		
		//lb=DOUBLE_T
		public Assignment getLbAssignment_1() { return cLbAssignment_1; }
		
		//DOUBLE_T
		public RuleCall getLbDOUBLE_TTerminalRuleCall_1_0() { return cLbDOUBLE_TTerminalRuleCall_1_0; }
		
		//','
		public Keyword getCommaKeyword_2() { return cCommaKeyword_2; }
		
		//(ub=DOUBLE_T | infty='Infty')
		public Alternatives getAlternatives_3() { return cAlternatives_3; }
		
		//ub=DOUBLE_T
		public Assignment getUbAssignment_3_0() { return cUbAssignment_3_0; }
		
		//DOUBLE_T
		public RuleCall getUbDOUBLE_TTerminalRuleCall_3_0_0() { return cUbDOUBLE_TTerminalRuleCall_3_0_0; }
		
		//infty='Infty'
		public Assignment getInftyAssignment_3_1() { return cInftyAssignment_3_1; }
		
		//'Infty'
		public Keyword getInftyInftyKeyword_3_1_0() { return cInftyInftyKeyword_3_1_0; }
		
		//')'
		public Keyword getRightParenthesisKeyword_4() { return cRightParenthesisKeyword_4; }
	}
	public class IntervalNNElements extends AbstractParserRuleElementFinder {
		private final ParserRule rule = (ParserRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.IntervalNN");
		private final Group cGroup = (Group)rule.eContents().get(1);
		private final Keyword cLeftSquareBracketKeyword_0 = (Keyword)cGroup.eContents().get(0);
		private final Assignment cLbAssignment_1 = (Assignment)cGroup.eContents().get(1);
		private final RuleCall cLbDOUBLE_TTerminalRuleCall_1_0 = (RuleCall)cLbAssignment_1.eContents().get(0);
		private final Keyword cCommaKeyword_2 = (Keyword)cGroup.eContents().get(2);
		private final Assignment cUbAssignment_3 = (Assignment)cGroup.eContents().get(3);
		private final RuleCall cUbDOUBLE_TTerminalRuleCall_3_0 = (RuleCall)cUbAssignment_3.eContents().get(0);
		private final Keyword cRightSquareBracketKeyword_4 = (Keyword)cGroup.eContents().get(4);
		
		//IntervalNN:
		//	'[' lb=DOUBLE_T ',' ub=DOUBLE_T ']';
		@Override public ParserRule getRule() { return rule; }
		
		//'[' lb=DOUBLE_T ',' ub=DOUBLE_T ']'
		public Group getGroup() { return cGroup; }
		
		//'['
		public Keyword getLeftSquareBracketKeyword_0() { return cLeftSquareBracketKeyword_0; }
		
		//lb=DOUBLE_T
		public Assignment getLbAssignment_1() { return cLbAssignment_1; }
		
		//DOUBLE_T
		public RuleCall getLbDOUBLE_TTerminalRuleCall_1_0() { return cLbDOUBLE_TTerminalRuleCall_1_0; }
		
		//','
		public Keyword getCommaKeyword_2() { return cCommaKeyword_2; }
		
		//ub=DOUBLE_T
		public Assignment getUbAssignment_3() { return cUbAssignment_3; }
		
		//DOUBLE_T
		public RuleCall getUbDOUBLE_TTerminalRuleCall_3_0() { return cUbDOUBLE_TTerminalRuleCall_3_0; }
		
		//']'
		public Keyword getRightSquareBracketKeyword_4() { return cRightSquareBracketKeyword_4; }
	}
	
	public class TimeUnitEnumElements extends AbstractElementFinder.AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.TimeUnitEnum");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cSEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cSSKeyword_0_0 = (Keyword)cSEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cNSEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cNSNsKeyword_1_0 = (Keyword)cNSEnumLiteralDeclaration_1.eContents().get(0);
		private final EnumLiteralDeclaration cUSEnumLiteralDeclaration_2 = (EnumLiteralDeclaration)cAlternatives.eContents().get(2);
		private final Keyword cUSUsKeyword_2_0 = (Keyword)cUSEnumLiteralDeclaration_2.eContents().get(0);
		private final EnumLiteralDeclaration cMSEnumLiteralDeclaration_3 = (EnumLiteralDeclaration)cAlternatives.eContents().get(3);
		private final Keyword cMSMsKeyword_3_0 = (Keyword)cMSEnumLiteralDeclaration_3.eContents().get(0);
		private final EnumLiteralDeclaration cMINEnumLiteralDeclaration_4 = (EnumLiteralDeclaration)cAlternatives.eContents().get(4);
		private final Keyword cMINMinKeyword_4_0 = (Keyword)cMINEnumLiteralDeclaration_4.eContents().get(0);
		private final EnumLiteralDeclaration cHREnumLiteralDeclaration_5 = (EnumLiteralDeclaration)cAlternatives.eContents().get(5);
		private final Keyword cHRHrKeyword_5_0 = (Keyword)cHREnumLiteralDeclaration_5.eContents().get(0);
		
		//enum TimeUnitEnum:
		//	S='s' | NS='ns' | US='us' | MS='ms' | MIN='min' | HR='hr';
		public EnumRule getRule() { return rule; }
		
		//S='s' | NS='ns' | US='us' | MS='ms' | MIN='min' | HR='hr'
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//S='s'
		public EnumLiteralDeclaration getSEnumLiteralDeclaration_0() { return cSEnumLiteralDeclaration_0; }
		
		//'s'
		public Keyword getSSKeyword_0_0() { return cSSKeyword_0_0; }
		
		//NS='ns'
		public EnumLiteralDeclaration getNSEnumLiteralDeclaration_1() { return cNSEnumLiteralDeclaration_1; }
		
		//'ns'
		public Keyword getNSNsKeyword_1_0() { return cNSNsKeyword_1_0; }
		
		//US='us'
		public EnumLiteralDeclaration getUSEnumLiteralDeclaration_2() { return cUSEnumLiteralDeclaration_2; }
		
		//'us'
		public Keyword getUSUsKeyword_2_0() { return cUSUsKeyword_2_0; }
		
		//MS='ms'
		public EnumLiteralDeclaration getMSEnumLiteralDeclaration_3() { return cMSEnumLiteralDeclaration_3; }
		
		//'ms'
		public Keyword getMSMsKeyword_3_0() { return cMSMsKeyword_3_0; }
		
		//MIN='min'
		public EnumLiteralDeclaration getMINEnumLiteralDeclaration_4() { return cMINEnumLiteralDeclaration_4; }
		
		//'min'
		public Keyword getMINMinKeyword_4_0() { return cMINMinKeyword_4_0; }
		
		//HR='hr'
		public EnumLiteralDeclaration getHREnumLiteralDeclaration_5() { return cHREnumLiteralDeclaration_5; }
		
		//'hr'
		public Keyword getHRHrKeyword_5_0() { return cHRHrKeyword_5_0; }
	}
	public class AndOrElements extends AbstractElementFinder.AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.AndOr");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cANDEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cANDAndKeyword_0_0 = (Keyword)cANDEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cOREnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cOROrKeyword_1_0 = (Keyword)cOREnumLiteralDeclaration_1.eContents().get(0);
		
		//enum AndOr:
		//	AND='and' | OR='or';
		public EnumRule getRule() { return rule; }
		
		//AND='and' | OR='or'
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//AND='and'
		public EnumLiteralDeclaration getANDEnumLiteralDeclaration_0() { return cANDEnumLiteralDeclaration_0; }
		
		//'and'
		public Keyword getANDAndKeyword_0_0() { return cANDAndKeyword_0_0; }
		
		//OR='or'
		public EnumLiteralDeclaration getOREnumLiteralDeclaration_1() { return cOREnumLiteralDeclaration_1; }
		
		//'or'
		public Keyword getOROrKeyword_1_0() { return cOROrKeyword_1_0; }
	}
	public class CompOpElements extends AbstractElementFinder.AbstractEnumRuleElementFinder {
		private final EnumRule rule = (EnumRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.CompOp");
		private final Alternatives cAlternatives = (Alternatives)rule.eContents().get(1);
		private final EnumLiteralDeclaration cLEEnumLiteralDeclaration_0 = (EnumLiteralDeclaration)cAlternatives.eContents().get(0);
		private final Keyword cLELessThanSignEqualsSignKeyword_0_0 = (Keyword)cLEEnumLiteralDeclaration_0.eContents().get(0);
		private final EnumLiteralDeclaration cEQEnumLiteralDeclaration_1 = (EnumLiteralDeclaration)cAlternatives.eContents().get(1);
		private final Keyword cEQEqualsSignEqualsSignKeyword_1_0 = (Keyword)cEQEnumLiteralDeclaration_1.eContents().get(0);
		private final EnumLiteralDeclaration cGEEnumLiteralDeclaration_2 = (EnumLiteralDeclaration)cAlternatives.eContents().get(2);
		private final Keyword cGEGreaterThanSignEqualsSignKeyword_2_0 = (Keyword)cGEEnumLiteralDeclaration_2.eContents().get(0);
		
		//enum CompOp:
		//	LE='<=' | EQ='==' | GE='>=';
		public EnumRule getRule() { return rule; }
		
		//LE='<=' | EQ='==' | GE='>='
		public Alternatives getAlternatives() { return cAlternatives; }
		
		//LE='<='
		public EnumLiteralDeclaration getLEEnumLiteralDeclaration_0() { return cLEEnumLiteralDeclaration_0; }
		
		//'<='
		public Keyword getLELessThanSignEqualsSignKeyword_0_0() { return cLELessThanSignEqualsSignKeyword_0_0; }
		
		//EQ='=='
		public EnumLiteralDeclaration getEQEnumLiteralDeclaration_1() { return cEQEnumLiteralDeclaration_1; }
		
		//'=='
		public Keyword getEQEqualsSignEqualsSignKeyword_1_0() { return cEQEqualsSignEqualsSignKeyword_1_0; }
		
		//GE='>='
		public EnumLiteralDeclaration getGEEnumLiteralDeclaration_2() { return cGEEnumLiteralDeclaration_2; }
		
		//'>='
		public Keyword getGEGreaterThanSignEqualsSignKeyword_2_0() { return cGEGreaterThanSignEqualsSignKeyword_2_0; }
	}
	
	private final EtlModelElements pEtlModel;
	private final TopLevelModelElementElements pTopLevelModelElement;
	private final SignalElements pSignal;
	private final ConvSpecElements pConvSpec;
	private final FormulaElements pFormula;
	private final StlApElements pStlAp;
	private final MtlApElements pMtlAp;
	private final AttributeFilterElements pAttributeFilter;
	private final KeyValElements pKeyVal;
	private final IdStringElements pIdString;
	private final IntervalElements pInterval;
	private final IntervalSSElements pIntervalSS;
	private final IntervalSNElements pIntervalSN;
	private final IntervalNSElements pIntervalNS;
	private final IntervalNNElements pIntervalNN;
	private final TimeUnitEnumElements eTimeUnitEnum;
	private final AndOrElements eAndOr;
	private final CompOpElements eCompOp;
	private final TerminalRule tINT_T;
	private final TerminalRule tDOUBLE_T;
	
	private final Grammar grammar;
	
	private final TerminalsGrammarAccess gaTerminals;

	@Inject
	public EtlGrammarAccess(GrammarProvider grammarProvider,
			TerminalsGrammarAccess gaTerminals) {
		this.grammar = internalFindGrammar(grammarProvider);
		this.gaTerminals = gaTerminals;
		this.pEtlModel = new EtlModelElements();
		this.pTopLevelModelElement = new TopLevelModelElementElements();
		this.pSignal = new SignalElements();
		this.pConvSpec = new ConvSpecElements();
		this.pFormula = new FormulaElements();
		this.pStlAp = new StlApElements();
		this.pMtlAp = new MtlApElements();
		this.pAttributeFilter = new AttributeFilterElements();
		this.pKeyVal = new KeyValElements();
		this.pIdString = new IdStringElements();
		this.pInterval = new IntervalElements();
		this.pIntervalSS = new IntervalSSElements();
		this.pIntervalSN = new IntervalSNElements();
		this.pIntervalNS = new IntervalNSElements();
		this.pIntervalNN = new IntervalNNElements();
		this.eTimeUnitEnum = new TimeUnitEnumElements();
		this.eAndOr = new AndOrElements();
		this.eCompOp = new CompOpElements();
		this.tINT_T = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.INT_T");
		this.tDOUBLE_T = (TerminalRule) GrammarUtil.findRuleForName(getGrammar(), "org.eclipse.trace4cps.tl.Etl.DOUBLE_T");
	}
	
	protected Grammar internalFindGrammar(GrammarProvider grammarProvider) {
		Grammar grammar = grammarProvider.getGrammar(this);
		while (grammar != null) {
			if ("org.eclipse.trace4cps.tl.Etl".equals(grammar.getName())) {
				return grammar;
			}
			List<Grammar> grammars = grammar.getUsedGrammars();
			if (!grammars.isEmpty()) {
				grammar = grammars.iterator().next();
			} else {
				return null;
			}
		}
		return grammar;
	}
	
	@Override
	public Grammar getGrammar() {
		return grammar;
	}
	
	
	public TerminalsGrammarAccess getTerminalsGrammarAccess() {
		return gaTerminals;
	}

	
	//EtlModel:
	//	elements+=TopLevelModelElement*;
	public EtlModelElements getEtlModelAccess() {
		return pEtlModel;
	}
	
	public ParserRule getEtlModelRule() {
		return getEtlModelAccess().getRule();
	}
	
	///* All TopLevelElements must have a unique name */ TopLevelModelElement:
	//	{SignalDef} 'signal' name=ID ':' signal=Signal
	//	| {Def} 'def' name=ID ('(' param=ID ')')? ':' formula=Formula
	//	| {Check} 'check' name=ID ':' ('forall' '(' var=ID ':' lb=INT_T '...' ub=INT_T ')')? formula=Formula;
	public TopLevelModelElementElements getTopLevelModelElementAccess() {
		return pTopLevelModelElement;
	}
	
	public ParserRule getTopLevelModelElementRule() {
		return getTopLevelModelElementAccess().getRule();
	}
	
	//Signal:
	//	{TraceSignal} filter=AttributeFilter
	//	| {ThroughputSignal} 'throughput' 'of' (idAtt=ID | ap=MtlAp) ('per' scale=TimeUnitEnum)?
	//	convSpec=ConvSpec?
	//	| {LatencySignal} 'latency' 'of' idAtt=ID ('in' scale=TimeUnitEnum)? convSpec=ConvSpec?
	//	| {WipSignal} 'wip' 'of' idAtt=ID convSpec=ConvSpec?
	//	| {ResourceAmountSignal} 'resource-amount' filter=AttributeFilter convSpec=ConvSpec?
	//	| {ResourceClientSignal} 'resource-clients' filter=AttributeFilter convSpec=ConvSpec?;
	public SignalElements getSignalAccess() {
		return pSignal;
	}
	
	public ParserRule getSignalRule() {
		return getSignalAccess().getRule();
	}
	
	//ConvSpec:
	//	'over' windowWidth=DOUBLE_T windowUnit=TimeUnitEnum;
	public ConvSpecElements getConvSpecAccess() {
		return pConvSpec;
	}
	
	public ParserRule getConvSpecRule() {
		return getConvSpecAccess().getRule();
	}
	
	//Formula:
	//	{ReferenceFormula} def=[Def] ('(' param=ID ('+' val=INT_T)? ')')?
	//	| {ApFormula} mtlAP=MtlAp
	//	| {ApFormula} stlAP=StlAp
	//	| {NotFormula} 'not' formula=Formula
	//	| {AndOrFormula} '(' left=Formula op=AndOr right=Formula ')'
	//	| {IfThenFormula} 'if' left=Formula 'then' right=Formula
	//	| {GloballyUntimedFormula} 'globally' formula=Formula
	//	| {GloballyFormula} 'during' interval=Interval formula=Formula
	//	| {FinallyUntimedFormula} 'finally' formula=Formula
	//	| {FinallyFormula} 'within' interval=Interval formula=Formula
	//	| {UntilUntimedFormula} 'until' right=Formula 'we' 'have' 'that' left=Formula
	//	| {UntilFormula} 'by' interval=Interval right=Formula 'and' 'until' 'then' left=Formula;
	public FormulaElements getFormulaAccess() {
		return pFormula;
	}
	
	public ParserRule getFormulaRule() {
		return getFormulaAccess().getRule();
	}
	
	//StlAp:
	//	(ref=[SignalDef] | {StlApDeriv} 'd' ref=[SignalDef] '/' 'dt') compOp=CompOp val=DOUBLE_T;
	public StlApElements getStlApAccess() {
		return pStlAp;
	}
	
	public ParserRule getStlApRule() {
		return getStlApAccess().getRule();
	}
	
	//MtlAp:
	//	({MtlApStart} 'start' | {MtlApEnd} 'end')? filter=AttributeFilter;
	public MtlApElements getMtlApAccess() {
		return pMtlAp;
	}
	
	public ParserRule getMtlApRule() {
		return getMtlApAccess().getRule();
	}
	
	//AttributeFilter:
	//	'{' keyVals+=KeyVal (',' keyVals+=KeyVal)* '}';
	public AttributeFilterElements getAttributeFilterAccess() {
		return pAttributeFilter;
	}
	
	public ParserRule getAttributeFilterRule() {
		return getAttributeFilterAccess().getRule();
	}
	
	//KeyVal:
	//	att=IdString '=' val=IdString;
	public KeyValElements getKeyValAccess() {
		return pKeyVal;
	}
	
	public ParserRule getKeyValRule() {
		return getKeyValAccess().getRule();
	}
	
	//IdString:
	//	left=STRING | id=ID | left=STRING '+' id=ID | id=ID '+' right=STRING | left=STRING '+' id=ID '+' right=STRING;
	public IdStringElements getIdStringAccess() {
		return pIdString;
	}
	
	public ParserRule getIdStringRule() {
		return getIdStringAccess().getRule();
	}
	
	//Interval:
	//	(iss=IntervalSS | isn=IntervalSN | ins=IntervalNS | inn=IntervalNN) timeUnit=TimeUnitEnum;
	public IntervalElements getIntervalAccess() {
		return pInterval;
	}
	
	public ParserRule getIntervalRule() {
		return getIntervalAccess().getRule();
	}
	
	//IntervalSS:
	//	'(' lb=DOUBLE_T ',' (ub=DOUBLE_T | infty='Infty') ')';
	public IntervalSSElements getIntervalSSAccess() {
		return pIntervalSS;
	}
	
	public ParserRule getIntervalSSRule() {
		return getIntervalSSAccess().getRule();
	}
	
	//IntervalSN:
	//	'(' lb=DOUBLE_T ',' ub=DOUBLE_T ']';
	public IntervalSNElements getIntervalSNAccess() {
		return pIntervalSN;
	}
	
	public ParserRule getIntervalSNRule() {
		return getIntervalSNAccess().getRule();
	}
	
	//IntervalNS:
	//	'[' lb=DOUBLE_T ',' (ub=DOUBLE_T | infty='Infty') ')';
	public IntervalNSElements getIntervalNSAccess() {
		return pIntervalNS;
	}
	
	public ParserRule getIntervalNSRule() {
		return getIntervalNSAccess().getRule();
	}
	
	//IntervalNN:
	//	'[' lb=DOUBLE_T ',' ub=DOUBLE_T ']';
	public IntervalNNElements getIntervalNNAccess() {
		return pIntervalNN;
	}
	
	public ParserRule getIntervalNNRule() {
		return getIntervalNNAccess().getRule();
	}
	
	//enum TimeUnitEnum:
	//	S='s' | NS='ns' | US='us' | MS='ms' | MIN='min' | HR='hr';
	public TimeUnitEnumElements getTimeUnitEnumAccess() {
		return eTimeUnitEnum;
	}
	
	public EnumRule getTimeUnitEnumRule() {
		return getTimeUnitEnumAccess().getRule();
	}
	
	//enum AndOr:
	//	AND='and' | OR='or';
	public AndOrElements getAndOrAccess() {
		return eAndOr;
	}
	
	public EnumRule getAndOrRule() {
		return getAndOrAccess().getRule();
	}
	
	//enum CompOp:
	//	LE='<=' | EQ='==' | GE='>=';
	public CompOpElements getCompOpAccess() {
		return eCompOp;
	}
	
	public EnumRule getCompOpRule() {
		return getCompOpAccess().getRule();
	}
	
	//terminal INT_T returns ecore::EInt:
	//	'-'? INT;
	public TerminalRule getINT_TRule() {
		return tINT_T;
	}
	
	//terminal DOUBLE_T returns ecore::EDouble:
	//	'-'? INT '.' INT;
	public TerminalRule getDOUBLE_TRule() {
		return tDOUBLE_T;
	}
	
	//terminal ID:
	//	'^'? ('a'..'z' | 'A'..'Z' | '_') ('a'..'z' | 'A'..'Z' | '_' | '0'..'9')*;
	public TerminalRule getIDRule() {
		return gaTerminals.getIDRule();
	}
	
	//terminal INT returns ecore::EInt:
	//	'0'..'9'+;
	public TerminalRule getINTRule() {
		return gaTerminals.getINTRule();
	}
	
	//terminal STRING:
	//	'"' ('\\' . | !('\\' | '"'))* '"' |
	//	"'" ('\\' . | !('\\' | "'"))* "'";
	public TerminalRule getSTRINGRule() {
		return gaTerminals.getSTRINGRule();
	}
	
	//terminal ML_COMMENT:
	//	'/*'->'*/';
	public TerminalRule getML_COMMENTRule() {
		return gaTerminals.getML_COMMENTRule();
	}
	
	//terminal SL_COMMENT:
	//	'//' !('\n' | '\r')* ('\r'? '\n')?;
	public TerminalRule getSL_COMMENTRule() {
		return gaTerminals.getSL_COMMENTRule();
	}
	
	//terminal WS:
	//	' ' | '\t' | '\r' | '\n'+;
	public TerminalRule getWSRule() {
		return gaTerminals.getWSRule();
	}
	
	//terminal ANY_OTHER:
	//	.;
	public TerminalRule getANY_OTHERRule() {
		return gaTerminals.getANY_OTHERRule();
	}
}
