/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.marker;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.marker.AbstractBaseChartPaintListener;
import org.eclipse.swtchart.extensions.marker.IBaseChartPaintListener;

public class AxisZeroMarker
extends AbstractBaseChartPaintListener
implements IBaseChartPaintListener {
    public AxisZeroMarker(BaseChart baseChart) {
        super(baseChart);
    }

    public void paintControl(PaintEvent e) {
        if (this.isDraw()) {
            BaseChart baseChart = this.getBaseChart();
            Range xRange = baseChart.getAxisSet().getXAxes()[0].getRange();
            Range yRange = baseChart.getAxisSet().getYAxes()[0].getRange();
            if (xRange.lower < 0.0 && xRange.upper > 0.0 && yRange.lower < 0.0 && yRange.upper > 0.0) {
                Point rectangle = baseChart.getPlotArea().getSize();
                int width = rectangle.x;
                int height = rectangle.y;
                double xDelta = xRange.upper - xRange.lower;
                double yDelta = yRange.upper - yRange.lower;
                double xDiff = xRange.lower * -1.0;
                double yDiff = yRange.upper;
                double xPart = 100.0 / xDelta * xDiff / 100.0;
                double yPart = 100.0 / yDelta * yDiff / 100.0;
                int xWidth = (int)((double)width * xPart);
                int yHeight = (int)((double)height * yPart);
                e.gc.setForeground(this.getForegroundColor());
                e.gc.drawLine(xWidth, 0, xWidth, height);
                e.gc.drawLine(0, yHeight, width, yHeight);
            }
        }
    }
}

