/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;

public final class AdapterManager
implements IAdapterManager {
    private final ConcurrentMap<String, AdapterLookup> adapterLookup;
    private final ConcurrentMap<IAdapterFactory, ConcurrentMap<String, Class<?>>> classLookup;
    private final ConcurrentMap<Class<?>, Class<?>[]> classSearchOrderLookup = new ConcurrentHashMap();
    private final ConcurrentMap<String, List<IAdapterFactory>> factories;
    private final Queue<IAdapterManagerProvider> lazyFactoryProviders;
    private static final AdapterManager singleton = new AdapterManager();

    public static AdapterManager getDefault() {
        return singleton;
    }

    private AdapterManager() {
        this.adapterLookup = new ConcurrentHashMap<String, AdapterLookup>();
        this.lazyFactoryProviders = new ConcurrentLinkedQueue<IAdapterManagerProvider>();
        this.factories = new ConcurrentHashMap<String, List<IAdapterFactory>>();
        this.classLookup = new ConcurrentHashMap();
    }

    private static boolean isFactoryLoaded(IAdapterFactory adapterFactory) {
        return !(adapterFactory instanceof IAdapterFactoryExt) || ((IAdapterFactoryExt)((Object)adapterFactory)).loadFactory(false) != null;
    }

    private void addFactoriesFor(String adaptableTypeName, Map<String, List<IAdapterFactory>> table) {
        List<IAdapterFactory> factoryList = this.getFactories().get(adaptableTypeName);
        if (factoryList == null) {
            return;
        }
        for (IAdapterFactory factory : factoryList) {
            Object adapter;
            int n;
            int n2;
            Object[] objectArray;
            Object[] adapters;
            if (factory instanceof IAdapterFactoryExt) {
                objectArray = adapters = ((IAdapterFactoryExt)((Object)factory)).getAdapterNames();
                n2 = adapters.length;
                n = 0;
                while (n < n2) {
                    adapter = objectArray[n];
                    table.computeIfAbsent((String)adapter, any -> new ArrayList(1)).add(factory);
                    ++n;
                }
                continue;
            }
            objectArray = adapters = factory.getAdapterList();
            n2 = adapters.length;
            n = 0;
            while (n < n2) {
                adapter = objectArray[n];
                table.computeIfAbsent(((Class)adapter).getName(), any -> new ArrayList(1)).add(factory);
                ++n;
            }
        }
    }

    private Class<?> classForName(IAdapterFactory adapterFactory, String typeName) {
        return this.classLookup.computeIfAbsent(adapterFactory, factory -> new ConcurrentHashMap()).computeIfAbsent(typeName, type -> AdapterManager.loadFactory(adapterFactory, false).map(arg_0 -> AdapterManager.lambda$4(typeName, arg_0)).orElse(null));
    }

    public String[] computeAdapterTypes(Class<? extends Object> adaptable) {
        Set<String> types = this.getFactories(adaptable).keySet();
        return types.toArray(new String[types.size()]);
    }

    private Map<String, List<IAdapterFactory>> getFactories(Class<? extends Object> adaptable) {
        return this.adapterLookup.computeIfAbsent(adaptable.getName(), adaptableType -> new AdapterLookup(adaptable, this)).getMap();
    }

    @Override
    public <T> Class<? super T>[] computeClassOrder(Class<T> adaptable) {
        Class<T>[] classOrder = this.getClassOrder(adaptable);
        return Arrays.copyOf(classOrder, classOrder.length);
    }

    private <T> Class<? super T>[] getClassOrder(Class<T> adaptable) {
        return this.classSearchOrderLookup.computeIfAbsent(adaptable, AdapterManager::doComputeClassOrder);
    }

    private static Class<?>[] doComputeClassOrder(Class<?> adaptable) {
        Class[] classHierarchy;
        ArrayList classes = new ArrayList();
        Class<?> clazz = adaptable;
        HashSet seen = new HashSet(4);
        while (clazz != null) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        Class[] classArray = classHierarchy = classes.toArray(new Class[classes.size()]);
        int n = classHierarchy.length;
        int n2 = 0;
        while (n2 < n) {
            Class cl = classArray[n2];
            AdapterManager.computeInterfaceOrder(cl.getInterfaces(), classes, seen);
            ++n2;
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static void computeInterfaceOrder(Class<?>[] interfaces, Collection<Class<?>> classes, Set<Class<?>> seen) {
        ArrayList newInterfaces = new ArrayList(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (seen.add(clazz)) {
                classes.add(clazz);
                newInterfaces.add(clazz);
            }
            ++n2;
        }
        for (Class clazz : newInterfaces) {
            AdapterManager.computeInterfaceOrder(clazz.getInterfaces(), classes, seen);
        }
    }

    public void flushLookup() {
        this.adapterLookup.clear();
        this.classLookup.clear();
        this.classSearchOrderLookup.clear();
    }

    @Override
    public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
        Assert.isNotNull(adaptable);
        Assert.isNotNull(adapterType);
        ArrayList incorrectAdapters = new ArrayList();
        T adapterObject = this.getFactories(adaptable.getClass()).getOrDefault(adapterType.getName(), Collections.emptyList()).stream().map(factory -> new AbstractMap.SimpleEntry((IAdapterFactory)factory, factory.getAdapter(adaptable, adapterType))).filter(entry -> {
            Object adapter = entry.getValue();
            if (adapter == null) {
                return false;
            }
            boolean res = adapterType.isInstance(adapter);
            if (!res) {
                IAdapterFactory factory = (IAdapterFactory)entry.getKey();
                incorrectAdapters.add(new AbstractMap.SimpleEntry(factory, adapter.getClass()));
            }
            return res;
        }).map(Map.Entry::getValue).findFirst().orElse(null);
        if (adapterObject == null) {
            if (!incorrectAdapters.isEmpty()) {
                throw new AssertionFailedException(incorrectAdapters.stream().map(entry -> "Adapter factory " + String.valueOf(entry.getKey()) + " returned " + ((Class)entry.getValue()).getName() + " that is not an instance of " + adapterType.getName()).collect(Collectors.joining("\n")));
            }
            if (adapterType.isInstance(adaptable)) {
                return (T)adaptable;
            }
        }
        return adapterObject;
    }

    @Override
    public Object getAdapter(Object adaptable, String adapterType) {
        Assert.isNotNull(adaptable);
        Assert.isNotNull(adapterType);
        return this.getAdapter(adaptable, adapterType, false);
    }

    private Object getAdapter(Object adaptable, String adapterType, boolean force) {
        Assert.isNotNull(adaptable);
        Assert.isNotNull(adapterType);
        return this.getFactories(adaptable.getClass()).getOrDefault(adapterType, Collections.emptyList()).stream().map(factory -> force && factory instanceof IAdapterFactoryExt ? ((IAdapterFactoryExt)((Object)factory)).loadFactory(true) : factory).filter(Objects::nonNull).map(factory -> {
            Class<?> adapterClass = this.classForName((IAdapterFactory)factory, adapterType);
            if (adapterClass == null) {
                return null;
            }
            return factory.getAdapter(adaptable, adapterClass);
        }).filter(Objects::nonNull).findFirst().map(Object.class::cast).orElseGet(() -> adapterType.equals(adaptable.getClass().getName()) ? adaptable : null);
    }

    @Override
    public boolean hasAdapter(Object adaptable, String adapterTypeName) {
        return this.getFactories(adaptable.getClass()).get(adapterTypeName) != null;
    }

    @Override
    public int queryAdapter(Object adaptable, String adapterTypeName) {
        List<IAdapterFactory> eligibleFactories = this.getFactories(adaptable.getClass()).get(adapterTypeName);
        if (eligibleFactories == null || eligibleFactories.isEmpty()) {
            return 0;
        }
        if (eligibleFactories.stream().anyMatch(AdapterManager::isFactoryLoaded)) {
            return 2;
        }
        return 1;
    }

    @Override
    public Object loadAdapter(Object adaptable, String adapterTypeName) {
        return this.getAdapter(adaptable, adapterTypeName, true);
    }

    @Override
    public void registerAdapters(IAdapterFactory factory, Class<?> adaptable) {
        this.registerFactory(factory, adaptable.getName());
        this.flushLookup();
    }

    public void registerFactory(IAdapterFactory factory, String adaptableType) {
        this.factories.computeIfAbsent(adaptableType, any -> new CopyOnWriteArrayList()).add(factory);
    }

    @Override
    public void unregisterAdapters(IAdapterFactory factory) {
        for (List list : this.factories.values()) {
            if (!list.remove(factory)) continue;
            this.flushLookup();
        }
    }

    @Override
    public void unregisterAdapters(IAdapterFactory factory, Class<?> adaptable) {
        List factoryList = (List)this.factories.get(adaptable.getName());
        if (factoryList == null || factoryList.isEmpty()) {
            return;
        }
        if (factoryList.remove(factory)) {
            this.flushLookup();
        }
    }

    public void unregisterAllAdapters() {
        this.lazyFactoryProviders.clear();
        this.factories.clear();
        this.flushLookup();
    }

    public void registerLazyFactoryProvider(IAdapterManagerProvider factoryProvider) {
        this.lazyFactoryProviders.add(factoryProvider);
    }

    public boolean unregisterLazyFactoryProvider(IAdapterManagerProvider factoryProvider) {
        return this.lazyFactoryProviders.remove(factoryProvider);
    }

    public Map<String, List<IAdapterFactory>> getFactories() {
        IAdapterManagerProvider provider;
        while ((provider = this.lazyFactoryProviders.poll()) != null) {
            if (!provider.addFactories(this)) continue;
            this.flushLookup();
        }
        return this.factories;
    }

    private static Optional<IAdapterFactory> loadFactory(IAdapterFactory factory, boolean force) {
        if (factory instanceof IAdapterFactoryExt) {
            return Optional.ofNullable(((IAdapterFactoryExt)((Object)factory)).loadFactory(force));
        }
        return Optional.ofNullable(factory);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ Class lambda$4(String var0, IAdapterFactory factory) {
        try {
            return factory.getClass().getClassLoader().loadClass(var0);
        }
        catch (ClassNotFoundException e) {
            var7_4 = adapterList = factory.getAdapterList();
            var6_5 = adapterList.length;
            var5_6 = 0;
            ** while (var5_6 < var6_5)
        }
lbl-1000:
        // 1 sources

        {
            adapter = var7_4[var5_6];
            if (var0.equals(adapter.getName())) {
                return adapter;
            }
            ++var5_6;
            continue;
        }
lbl13:
        // 1 sources

        return null;
    }

    private static final class AdapterLookup {
        private final Class<?> adaptable;
        private final AdapterManager manager;
        private Map<String, List<IAdapterFactory>> map;

        AdapterLookup(Class<?> adaptable, AdapterManager manager) {
            this.adaptable = adaptable;
            this.manager = manager;
        }

        synchronized Map<String, List<IAdapterFactory>> getMap() {
            if (this.map == null) {
                HashMap<String, List<IAdapterFactory>> table = new HashMap<String, List<IAdapterFactory>>(4);
                Class<?>[] classArray = this.manager.computeClassOrder(this.adaptable);
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> cl = classArray[n2];
                    this.manager.addFactoriesFor(cl.getName(), table);
                    ++n2;
                }
                this.map = Collections.unmodifiableMap(table);
            }
            return this.map;
        }
    }
}

