/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.search.LRUWorkingSetsList;
import org.eclipse.wst.jsdt.internal.ui.search.WorkingSetComparator;

public class SearchUtil {
    public static int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSetsList fgLRUWorkingSets;
    private static final String DIALOG_SETTINGS_KEY = "CallHierarchySearchScope";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static IDialogSettings fgSettingsStore;

    public static void updateLRUWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return;
        }
        SearchUtil.getLRUWorkingSets().add(workingSets);
        SearchUtil.saveState();
    }

    private static void saveState() {
        Iterator iter = fgLRUWorkingSets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            String[] names = new String[workingSets.length];
            int j = 0;
            while (j < workingSets.length) {
                names[j] = workingSets[j].getName();
                ++j;
            }
            fgSettingsStore.put(STORE_LRU_WORKING_SET_NAMES + i, names);
            ++i;
        }
    }

    public static LRUWorkingSetsList getLRUWorkingSets() {
        if (fgLRUWorkingSets == null) {
            SearchUtil.restoreState();
        }
        return fgLRUWorkingSets;
    }

    static void restoreState() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaScriptPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaScriptPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean foundLRU = false;
        int i = LRU_WORKINGSET_LIST_SIZE - 1;
        while (i >= 0) {
            String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES + i);
            if (lruWorkingSetNames != null) {
                HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>(2);
                int j = 0;
                while (j < lruWorkingSetNames.length) {
                    IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[j]);
                    if (workingSet != null) {
                        workingSets.add(workingSet);
                    }
                    ++j;
                }
                foundLRU = true;
                if (!workingSets.isEmpty()) {
                    fgLRUWorkingSets.add(workingSets.toArray(new IWorkingSet[workingSets.size()]));
                }
            }
            --i;
        }
        if (!foundLRU) {
            SearchUtil.restoreFromOldFormat();
        }
    }

    private static void restoreFromOldFormat() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaScriptPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaScriptPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean foundLRU = false;
        String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (lruWorkingSetNames != null) {
            int i = lruWorkingSetNames.length - 1;
            while (i >= 0) {
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[i]);
                if (workingSet != null) {
                    foundLRU = true;
                    fgLRUWorkingSets.add(new IWorkingSet[]{workingSet});
                }
                --i;
            }
        }
        if (foundLRU) {
            SearchUtil.saveState();
        }
    }

    public static String toString(IWorkingSet[] workingSets) {
        Arrays.sort(workingSets, new WorkingSetComparator());
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            boolean firstFound = false;
            int i = 0;
            while (i < workingSets.length) {
                String workingSetName = workingSets[i].getLabel();
                if (firstFound) {
                    result = Messages.format(CallHierarchyMessages.SearchUtil_workingSetConcatenation, new String[]{result, workingSetName});
                } else {
                    result = workingSetName;
                    firstFound = true;
                }
                ++i;
            }
        }
        return result;
    }
}

