/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.text.BreakIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;

public final class DefaultAnalyzer
extends Analyzer {
    private Locale locale;

    public DefaultAnalyzer(String localeString) {
        Locale[] localeArray;
        Locale[] availableLocales;
        Locale userLocale = this.getLocale(localeString);
        Locale[] localeArray2 = availableLocales = BreakIterator.getAvailableLocales();
        int n = availableLocales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale availableLocale = localeArray2[n2];
            if (userLocale.equals(availableLocale)) {
                this.locale = userLocale;
                break;
            }
            ++n2;
        }
        if (this.locale == null && userLocale.getDisplayVariant().length() > 0) {
            Locale countryLocale = Locale.of(userLocale.getLanguage(), userLocale.getCountry());
            localeArray = availableLocales;
            int n3 = availableLocales.length;
            n = 0;
            while (n < n3) {
                Locale availableLocale = localeArray[n];
                if (countryLocale.equals(availableLocale)) {
                    this.locale = countryLocale;
                    break;
                }
                ++n;
            }
        }
        if (this.locale == null && userLocale.getCountry().length() > 0) {
            Locale language = Locale.of(userLocale.getLanguage(), "");
            localeArray = availableLocales;
            int n4 = availableLocales.length;
            n = 0;
            while (n < n4) {
                Locale availableLocale = localeArray[n];
                if (language.equals(availableLocale)) {
                    this.locale = language;
                    break;
                }
                ++n;
            }
        }
        if (this.locale == null) {
            ILog.of(((Object)((Object)this)).getClass()).error("Text Analyzer could not be created for locale {0}.  An analyzer that extends org.eclipse.help.luceneAnalyzer extension point needs to be plugged in for locale " + localeString + ", or Java Virtual Machine needs to be upgraded to version with proper support for locale {0}.", null);
            this.locale = Locale.of("en", "US");
        }
    }

    private Locale getLocale(String clientLocale) {
        StringTokenizer locales;
        if (clientLocale == null) {
            clientLocale = Platform.getNL();
        }
        if (clientLocale == null) {
            clientLocale = Locale.getDefault().toString();
        }
        if ((locales = new StringTokenizer(clientLocale, "_")).countTokens() == 1) {
            return Locale.of(locales.nextToken(), "");
        }
        if (locales.countTokens() == 2) {
            return Locale.of(locales.nextToken(), locales.nextToken());
        }
        if (locales.countTokens() == 3) {
            return Locale.of(locales.nextToken(), locales.nextToken(), locales.nextToken());
        }
        return Locale.getDefault();
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        LowerCaseFilter filter = new LowerCaseFilter((TokenStream)source);
        Analyzer.TokenStreamComponents components = new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
        return components;
    }
}

