/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.impl.helper.Coercions;
import org.apache.felix.scr.impl.inject.BindParameters;
import org.apache.felix.scr.impl.inject.MethodResult;
import org.apache.felix.scr.impl.inject.OpenStatus;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ReferenceMethod;
import org.apache.felix.scr.impl.inject.ReferenceMethods;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.EdgeInfo;
import org.apache.felix.scr.impl.manager.ExtendedServiceEvent;
import org.apache.felix.scr.impl.manager.MultiplePrototypeRefPair;
import org.apache.felix.scr.impl.manager.ReferenceManager;
import org.apache.felix.scr.impl.manager.ServiceTracker;
import org.apache.felix.scr.impl.manager.ServiceTrackerCustomizer;
import org.apache.felix.scr.impl.manager.SinglePrototypeRefPair;
import org.apache.felix.scr.impl.manager.SingleRefPair;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentException;

public class DependencyManager<S, T>
implements ReferenceManager<S, T> {
    public static final String ANY_SERVICE_CLASS = "org.osgi.service.component.AnyService";
    public static final String NEVER_SATIFIED_FILTER = "(&(invalid.target.cannot.resolve=*)(!(invalid.target.cannot.resolve=*)))";
    private final AbstractComponentManager<S> m_componentManager;
    private final ReferenceMetadata m_dependencyMetadata;
    private final int m_index;
    private final Customizer<S, T> m_customizer;
    private volatile ReferenceMethods m_bindMethods;
    private volatile ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> m_tracker;
    private volatile String m_target;
    private volatile int m_minCardinality;
    private static final String OBJECTCLASS_CLAUSE = "(objectClass=";
    private static final String PROTOTYPE_SCOPE_CLAUSE = "(service.scope=prototype)";

    DependencyManager(AbstractComponentManager<S> componentManager, ReferenceMetadata dependency, int index) {
        this.m_componentManager = componentManager;
        this.m_dependencyMetadata = dependency;
        this.m_index = index;
        this.m_customizer = this.newCustomizer();
        this.m_minCardinality = DependencyManager.defaultMinimumCardinality(dependency);
        if (this.m_componentManager.getLogger().isLogEnabled(InternalLogger.Level.DEBUG)) {
            this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "Dependency Manager created {0}", null, dependency.getDebugInfo());
        }
    }

    private static int defaultMinimumCardinality(ReferenceMetadata dependency) {
        return dependency.isOptional() ? 0 : 1;
    }

    int getIndex() {
        return this.m_index;
    }

    void initBindingMethods(ReferenceMethods bindMethods) {
        this.m_bindMethods = bindMethods;
    }

    private String getServiceName() {
        return this.m_dependencyMetadata.getInterface();
    }

    boolean isOptional() {
        return this.m_dependencyMetadata.isOptional();
    }

    private boolean isEffectivelyOptional() {
        return this.m_minCardinality == 0;
    }

    boolean cardinalitySatisfied() {
        ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        return this.cardinalitySatisfied(tracker == null ? 0 : tracker.getServiceCount());
    }

    public boolean cardinalitySatisfied(int serviceCount) {
        return this.m_minCardinality <= serviceCount;
    }

    private boolean cardinalityJustSatisfied(int serviceCount) {
        return this.m_minCardinality == serviceCount;
    }

    private boolean isMultiple() {
        return this.m_dependencyMetadata.isMultiple();
    }

    private boolean isStatic() {
        return this.m_dependencyMetadata.isStatic();
    }

    private boolean isReluctant() {
        return this.m_dependencyMetadata.isReluctant();
    }

    void deactivate() {
        this.m_customizer.close();
    }

    int size() {
        AtomicInteger trackingCount = new AtomicInteger();
        ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        if (tracker == null) {
            return 0;
        }
        return this.m_tracker.getTracked(null, trackingCount).size();
    }

    private ServiceReference<?>[] getFrameworkServiceReferences(String targetFilter) {
        if (this.hasGetPermission()) {
            BundleContext bc = this.m_componentManager.getActivator().getBundleContext();
            if (bc == null) {
                return null;
            }
            try {
                return bc.getServiceReferences(this.m_dependencyMetadata.getInterface(), targetFilter);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (InvalidSyntaxException ise) {
                this.m_componentManager.getLogger().log(InternalLogger.Level.ERROR, "Unexpected problem with filter ''{0}''", ise, targetFilter);
                return null;
            }
        }
        this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "No permission to access the services", null);
        return null;
    }

    private RefPair<S, T> getBestRefPair() {
        Collection<RefPair<S, T>> refs = this.m_customizer.getRefs(new AtomicInteger());
        if (refs.isEmpty()) {
            return null;
        }
        return refs.iterator().next();
    }

    T getService(ComponentContextImpl<S> key) {
        RefPair<S, T> sr = this.getBestRefPair();
        return this.getService(key, sr);
    }

    Object[] getServices(ComponentContextImpl<S> key) {
        Collection<RefPair<S, T>> refs = this.m_customizer.getRefs(new AtomicInteger());
        ArrayList<T> services = new ArrayList<T>(refs.size());
        for (RefPair<S, T> ref : refs) {
            T service = this.getService(key, ref);
            if (service == null) continue;
            services.add(service);
        }
        return services.isEmpty() ? null : services.toArray(new Object[services.size()]);
    }

    @Override
    public List<ServiceReference<?>> getServiceReferences() {
        Collection<RefPair<S, T>> bound = this.m_customizer.getRefs(new AtomicInteger());
        ArrayList result = new ArrayList(bound.size());
        for (RefPair<S, T> ref : bound) {
            result.add(ref.getRef());
        }
        return result;
    }

    private RefPair<S, T> getRefPair(ServiceReference<T> serviceReference) {
        ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        if (tracker != null) {
            AtomicInteger trackingCount = new AtomicInteger();
            return (RefPair)tracker.getTracked(null, trackingCount).get(serviceReference);
        }
        return null;
    }

    T getService(ComponentContextImpl<S> key, ServiceReference<T> serviceReference) {
        RefPair<S, T> refPair = this.getRefPair(serviceReference);
        return this.getService(key, refPair);
    }

    private T getService(ComponentContextImpl<S> key, RefPair<S, T> refPair) {
        if (refPair == null) {
            return null;
        }
        T serviceObject = refPair.getServiceObject(key);
        if (serviceObject != null) {
            return serviceObject;
        }
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        if (bundleContext == null) {
            this.m_componentManager.getLogger().log(InternalLogger.Level.ERROR, "Bundle shut down while getting service {0} ({1}/{2,number,#})", null, this.getName(), this.m_dependencyMetadata.getInterface(), refPair.getRef().getProperty("service.id"));
            return null;
        }
        try {
            refPair.getServiceObject(key, bundleContext);
            serviceObject = refPair.getServiceObject(key);
        }
        catch (Exception e) {
            this.m_componentManager.getLogger().log(InternalLogger.Level.ERROR, "Failed getting service {0} ({1}/{2,number,#})", e, this.getName(), this.m_dependencyMetadata.getInterface(), refPair.getRef().getProperty("service.id"));
            return null;
        }
        return serviceObject;
    }

    @Override
    public String getName() {
        return this.m_dependencyMetadata.getName();
    }

    public ReferenceMetadata getReferenceMetadata() {
        return this.m_dependencyMetadata;
    }

    @Override
    public boolean isSatisfied() {
        return this.m_customizer.isSatisfied();
    }

    public boolean hasGetPermission() {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(this.getServiceName(), "get");
            return this.m_componentManager.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    boolean prebind(ComponentContextImpl<S> key) {
        return this.m_customizer.prebind(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenStatus<S, T> open(ComponentContextImpl<S> componentContext, EdgeInfo edgeInfo) {
        CountDownLatch openLatch;
        Collection<RefPair<S, T>> refs;
        int serviceCount = 0;
        OpenStatusImpl status = new OpenStatusImpl(this);
        AtomicInteger trackingCount = new AtomicInteger();
        ServiceTracker.Tracked tracked = this.m_tracker.tracked();
        synchronized (tracked) {
            refs = this.m_customizer.getRefs(trackingCount);
            edgeInfo.setOpen(trackingCount.get());
            openLatch = edgeInfo.getOpenLatch();
        }
        this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "For dependency {0}, optional: {1}; to bind: {2}", null, this.getName(), this.isOptional(), refs);
        for (RefPair refPair : refs) {
            if (refPair.isDeleted() || refPair.isFailed()) continue;
            ++serviceCount;
        }
        openLatch.countDown();
        return this.cardinalitySatisfied(serviceCount) ? status : null;
    }

    boolean bind(ComponentContextImpl<S> componentContext, OpenStatus<S, T> status) {
        if (!this.invokeInitMethod(componentContext)) {
            this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "For dependency {0}, failed to initialize object", null, this.getName());
            return false;
        }
        ReferenceMethod bindMethod = this.m_bindMethods.getBind();
        return this.bindDependency(componentContext, bindMethod, status);
    }

    boolean bindDependency(ComponentContextImpl<S> componentContext, ReferenceMethod bindMethod, OpenStatus<S, T> status) {
        int serviceCount = 0;
        AtomicInteger trackingCount = new AtomicInteger();
        for (RefPair<S, T> refPair : status.getRefs(trackingCount)) {
            if (refPair.isDeleted() || refPair.isFailed()) continue;
            if (!this.doInvokeBindMethod(componentContext, bindMethod, refPair, trackingCount.get())) {
                this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "For dependency {0}, failed to invoke bind method on object {1}", null, this.getName(), refPair);
            }
            ++serviceCount;
        }
        return this.cardinalitySatisfied(serviceCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ComponentContextImpl<S> componentContext, EdgeInfo edgeInfo) {
        CountDownLatch latch;
        Collection<RefPair<S, T>> refPairs;
        boolean doUnbind = componentContext != null && (this.m_dependencyMetadata.getField() != null || this.m_dependencyMetadata.getUnbind() != null);
        AtomicInteger trackingCount = new AtomicInteger();
        ServiceTracker.Tracked tracked = this.m_tracker.tracked();
        synchronized (tracked) {
            refPairs = this.m_customizer.getRefs(trackingCount);
            edgeInfo.setClose(trackingCount.get());
            latch = edgeInfo.getCloseLatch();
        }
        this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "DependencyManager: {0} close component unbinding from {1} at tracking count {2} refpairs: {3}", null, this.getName(), componentContext, trackingCount.get(), refPairs);
        this.m_componentManager.waitForTracked(trackingCount.get());
        for (RefPair refPair : refPairs) {
            if (doUnbind && !refPair.isFailed()) {
                this.invokeUnbindMethod(componentContext, refPair, trackingCount.get(), edgeInfo);
            }
            refPair.ungetServiceObject(componentContext);
        }
        latch.countDown();
    }

    public void invokeBindMethodLate(ServiceReference<T> ref, int trackingCount) {
        RefPair<S, T> refPair;
        ServiceTracker<T, RefPair<T, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        if (tracker == null || !tracker.isActive()) {
            this.m_componentManager.notifyWaiters();
            return;
        }
        if (!this.isSatisfied()) {
            return;
        }
        if (!this.isMultiple()) {
            Collection<RefPair<S, T>> refs = this.m_customizer.getRefs(new AtomicInteger());
            if (refs.isEmpty()) {
                return;
            }
            RefPair<S, T> test = refs.iterator().next();
            if (ref != test.getRef()) {
                return;
            }
        }
        if ((refPair = tracker.getService(ref)) == null) {
            return;
        }
        this.m_componentManager.invokeBindMethod(this, refPair, trackingCount);
    }

    boolean invokeInitMethod(ComponentContextImpl<S> componentContext) {
        S componentInstance;
        if (this.m_bindMethods.getInit() != null && (componentInstance = componentContext.getImplementationObject(false)) != null) {
            return this.m_bindMethods.getInit().init(componentInstance, componentContext.getLogger());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeBindMethod(ComponentContextImpl<S> componentContext, RefPair<S, T> refPair, int trackingCount, EdgeInfo info) {
        if (componentContext.getImplementationObject(false) != null) {
            ServiceTracker.Tracked monitor = this.m_tracker.tracked();
            if (monitor == null) {
                return true;
            }
            ServiceTracker.Tracked tracked = monitor;
            synchronized (tracked) {
                if (info.outOfRange(trackingCount)) {
                    return true;
                }
            }
            return this.doInvokeBindMethod(componentContext, this.m_bindMethods.getBind(), refPair, trackingCount);
        }
        this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "DependencyManager : component not yet created, assuming bind method call succeeded", null);
        return true;
    }

    private boolean doInvokeBindMethod(ComponentContextImpl<S> componentContext, ReferenceMethod bindMethod, RefPair<S, T> refPair, int trackingCount) {
        if (!this.getServiceObject(componentContext, bindMethod, refPair)) {
            this.m_componentManager.getLogger().log(InternalLogger.Level.WARN, "DependencyManager : invokeBindMethod : Service not available from service registry for ServiceReference {0} for reference {1}", null, refPair.getRef(), this.getName());
            return false;
        }
        MethodResult result = bindMethod.invoke(componentContext.getImplementationObject(false), new BindParameters(componentContext, refPair), MethodResult.VOID);
        if (result == null) {
            return false;
        }
        this.m_componentManager.setServiceProperties(result, trackingCount);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeUpdatedMethod(ComponentContextImpl<S> componentContext, RefPair<S, T> refPair, int trackingCount, EdgeInfo info) {
        ServiceTracker.Tracked monitor;
        ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
        if (monitor == null) {
            return false;
        }
        if (this.m_dependencyMetadata.getUpdated() == null && this.m_dependencyMetadata.getField() == null) {
            return false;
        }
        if (componentContext != null) {
            ServiceTracker.Tracked tracked2 = monitor;
            synchronized (tracked2) {
                if (info.outOfRange(trackingCount)) {
                    return false;
                }
            }
            info.waitForOpen(this.m_componentManager, this.getName(), "invokeUpdatedMethod");
            if (!this.getServiceObject(componentContext, this.m_bindMethods.getUpdated(), refPair)) {
                this.m_componentManager.getLogger().log(InternalLogger.Level.WARN, "DependencyManager : invokeUpdatedMethod : Service not available from service registry for ServiceReference {0} for reference {1}", null, refPair.getRef(), this.getName());
                return false;
            }
            MethodResult methodResult = this.m_bindMethods.getUpdated().invoke(componentContext.getImplementationObject(false), new BindParameters(componentContext, refPair), MethodResult.VOID);
            if (methodResult != null) {
                this.m_componentManager.setServiceProperties(methodResult, trackingCount);
            }
            return methodResult == MethodResult.REACTIVATE;
        }
        this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "DependencyManager : Component not set, no need to call updated method", null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeUnbindMethod(ComponentContextImpl<S> componentContext, RefPair<S, T> refPair, int trackingCount, EdgeInfo info) {
        ServiceTracker.Tracked monitor;
        ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
        if (monitor == null) {
            return;
        }
        if (componentContext != null) {
            boolean outOfRange;
            ServiceTracker.Tracked tracked2 = monitor;
            synchronized (tracked2) {
                if (info.beforeRange(trackingCount)) {
                    return;
                }
            }
            info.waitForOpen(this.m_componentManager, this.getName(), "invokeUnbindMethod");
            ServiceTracker.Tracked tracked3 = monitor;
            synchronized (tracked3) {
                outOfRange = info.afterRange(trackingCount);
            }
            if (outOfRange) {
                info.waitForClose(this.m_componentManager, this.getName(), "invokeUnbindMethod");
                return;
            }
            if (!this.getServiceObject(componentContext, this.m_bindMethods.getUnbind(), refPair)) {
                this.m_componentManager.getLogger().log(InternalLogger.Level.WARN, "DependencyManager : invokeUnbindMethod : Service not available from service registry for ServiceReference {0} for reference {1}", null, refPair.getRef(), this.getName());
                return;
            }
            MethodResult methodResult = this.m_bindMethods.getUnbind().invoke(componentContext.getImplementationObject(false), new BindParameters(componentContext, refPair), MethodResult.VOID);
            if (methodResult != null) {
                this.m_componentManager.setServiceProperties(methodResult, trackingCount);
            }
            componentContext.getComponentServiceObjectsHelper().closeServiceObjects(refPair.getRef());
        } else {
            this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "DependencyManager : Component not set, no need to call unbind method", null);
        }
    }

    boolean canUpdateDynamically(Map<String, Object> properties) {
        String newTarget = (String)properties.get(this.m_dependencyMetadata.getTargetPropertyName());
        String currentTarget = this.getTarget();
        int newMinimumCardinality = this.getMinimumCardinality(properties);
        if (this.m_minCardinality == newMinimumCardinality && (currentTarget == null && newTarget == null || currentTarget != null && currentTarget.equals(newTarget))) {
            return true;
        }
        if (this.m_dependencyMetadata.isStatic()) {
            return false;
        }
        if (newMinimumCardinality == 0) {
            return true;
        }
        ServiceReference<?>[] refs = this.getFrameworkServiceReferences(newTarget);
        if (refs != null) {
            return newMinimumCardinality <= refs.length;
        }
        return false;
    }

    void setTargetFilter(Map<String, Object> properties) {
        Integer minimumCardinality = this.getMinimumCardinality(properties);
        this.setTargetFilter((String)properties.get(this.m_dependencyMetadata.getTargetPropertyName()), minimumCardinality);
    }

    private int getMinimumCardinality(Map<String, Object> properties) {
        Integer minimumCardinality = null;
        try {
            minimumCardinality = Coercions.coerceToInteger(properties.get(this.m_dependencyMetadata.getMinCardinalityName()));
        }
        catch (ComponentException e) {
            this.m_componentManager.getLogger().log(InternalLogger.Level.WARN, "Invalid minimum cardinality property for dependency {0}: {1}", null, this.getName(), e.getMessage());
        }
        if (minimumCardinality != null && (minimumCardinality < DependencyManager.defaultMinimumCardinality(this.m_dependencyMetadata) || !this.m_dependencyMetadata.isMultiple() && minimumCardinality > 1)) {
            minimumCardinality = null;
        }
        if (minimumCardinality == null) {
            minimumCardinality = DependencyManager.defaultMinimumCardinality(this.m_dependencyMetadata);
        }
        return minimumCardinality;
    }

    private void setTargetFilter(String target, int minimumCardinality) {
        if (target == null) {
            target = this.m_dependencyMetadata.getTarget();
        }
        if (this.m_target == null && target == null || this.m_target != null && this.m_target.equals(target)) {
            this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "No change in target property for dependency {0}: currently registered: {1}", null, this.getName(), this.m_tracker != null);
            if (this.m_tracker != null) {
                this.m_minCardinality = minimumCardinality;
                return;
            }
        }
        if (target != null) {
            try {
                FrameworkUtil.createFilter((String)target);
            }
            catch (InvalidSyntaxException e) {
                this.m_componentManager.getLogger().log(InternalLogger.Level.ERROR, "Invalid syntax in target property for dependency {0} to {1}", null, this.getName(), target);
                target = NEVER_SATIFIED_FILTER;
            }
        }
        this.m_target = target;
        String classFilterString = this.getClassFilter();
        String initialReferenceFilterString = this.getInitialReferenceFilter(classFilterString, target);
        ServiceTracker<RefPair<S, T>, RefPair<T, RefPair<S, T>>, ExtendedServiceEvent> oldTracker = this.m_tracker;
        AtomicInteger trackingCount = new AtomicInteger();
        SortedMap<ServiceReference<T>, RefPair<S, T>> refMap = this.unregisterServiceListener(trackingCount);
        if (trackingCount.get() != -1) {
            this.m_componentManager.waitForTracked(trackingCount.get());
        }
        this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "Setting target property for dependency {0} to {1}", null, this.getName(), target);
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        this.m_customizer.setPreviousRefMap(refMap);
        boolean initialActive = oldTracker != null && oldTracker.isActive();
        this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "New service tracker for {0}, initial active: {1}, previous references: {2}, classFilter: {3}, initialReferenceFilter {4}", null, this.getName(), initialActive, refMap, classFilterString, initialReferenceFilterString);
        ServiceReference<T> trueReference = this.getTrueConditionRef();
        ServiceTracker tracker = new ServiceTracker(bundleContext, this.m_customizer, initialActive, this.m_componentManager.getActivator(), initialReferenceFilterString, trueReference);
        this.m_customizer.setTracker(tracker);
        this.m_minCardinality = minimumCardinality;
        tracker.open(this.m_componentManager.getTrackingCount());
        this.m_customizer.setTrackerOpened();
        if (oldTracker != null) {
            oldTracker.completeClose(refMap);
        }
        this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "registering service listener for dependency {0}", null, this.getName());
    }

    private String getClassFilter() {
        String objectClass = this.m_dependencyMetadata.getInterface();
        if (ANY_SERVICE_CLASS.equals(objectClass)) {
            objectClass = "*";
        }
        StringBuilder classFilterSB = new StringBuilder();
        classFilterSB.append(OBJECTCLASS_CLAUSE);
        classFilterSB.append(objectClass);
        classFilterSB.append(')');
        return classFilterSB.toString();
    }

    private String getInitialReferenceFilter(String classFilterString, String target) {
        if (target == null && ANY_SERVICE_CLASS.equals(this.m_dependencyMetadata.getInterface())) {
            this.m_componentManager.getLogger().log(InternalLogger.Level.ERROR, "The dependency reference {0} is an AnyService reference with no target specified.", null, this.getName());
            target = NEVER_SATIFIED_FILTER;
        }
        boolean multipleExpr = target != null || this.m_dependencyMetadata.getScope() == ReferenceMetadata.ReferenceScope.prototype_required;
        StringBuilder initialReferenceFilterSB = new StringBuilder();
        if (multipleExpr) {
            initialReferenceFilterSB.append("(&");
        }
        initialReferenceFilterSB.append(classFilterString);
        if (this.m_dependencyMetadata.getScope() == ReferenceMetadata.ReferenceScope.prototype_required) {
            initialReferenceFilterSB.append(PROTOTYPE_SCOPE_CLAUSE);
        }
        if (target != null) {
            initialReferenceFilterSB.append(target);
        }
        if (multipleExpr) {
            initialReferenceFilterSB.append(')');
        }
        return initialReferenceFilterSB.toString();
    }

    private ServiceReference<T> getTrueConditionRef() {
        if (this.m_dependencyMetadata.getScope() == ReferenceMetadata.ReferenceScope.prototype_required) {
            return null;
        }
        if (!"osgi.ds.satisfying.condition".equals(this.m_dependencyMetadata.getName())) {
            return null;
        }
        if (!"(osgi.condition.id=true)".equals(this.m_target)) {
            return null;
        }
        if (!"org.osgi.service.condition.Condition".equals(this.m_dependencyMetadata.getInterface())) {
            return null;
        }
        return this.m_componentManager.getActivator().getTrueCondition();
    }

    private Customizer<S, T> newCustomizer() {
        Customizer customizer;
        if (!this.hasGetPermission()) {
            customizer = new NoPermissionsCustomizer();
            this.m_componentManager.getLogger().log(InternalLogger.Level.INFO, "No permission to get services for {0}", null, this.getName());
        } else {
            customizer = this.m_componentManager.isFactory() ? new FactoryCustomizer() : (this.isMultiple() ? (this.isStatic() ? (this.isReluctant() ? new MultipleStaticReluctantCustomizer() : new MultipleStaticGreedyCustomizer()) : new MultipleDynamicCustomizer()) : (this.isStatic() ? new SingleStaticCustomizer() : new SingleDynamicCustomizer()));
        }
        return customizer;
    }

    SortedMap<ServiceReference<T>, RefPair<S, T>> unregisterServiceListener(AtomicInteger trackingCount) {
        SortedMap<ServiceReference<T>, RefPair<S, T>> refMap;
        ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker = this.m_tracker;
        if (tracker != null) {
            refMap = tracker.close(trackingCount);
            this.m_tracker = null;
            this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "unregistering service listener for dependency {0}", null, this.getName());
        } else {
            refMap = new TreeMap(Collections.reverseOrder());
            this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, " No existing service listener to unregister for dependency {0}", null, this.getName());
            trackingCount.set(-1);
        }
        return refMap;
    }

    @Override
    public String getTarget() {
        return this.m_target;
    }

    public String toString() {
        return "DependencyManager: Component [" + this.m_componentManager + "] reference [" + this.getName() + "]";
    }

    boolean getServiceObject(ComponentContextImpl<S> key, ReferenceMethod bindMethod, RefPair<S, T> refPair) {
        BundleContext bundleContext = this.m_componentManager.getBundleContext();
        if (bundleContext != null) {
            return bindMethod.getServiceObject(new BindParameters(key, refPair), bundleContext);
        }
        refPair.markFailed();
        return false;
    }

    RefPair<S, T> newRefPair(ServiceReference<T> serviceReference) {
        if (this.m_dependencyMetadata.getScope() == ReferenceMetadata.ReferenceScope.bundle) {
            return new SingleRefPair(serviceReference);
        }
        if (this.m_componentManager.getComponentMetadata().getServiceScope() == ServiceMetadata.Scope.singleton) {
            return new SinglePrototypeRefPair(serviceReference);
        }
        return new MultiplePrototypeRefPair(serviceReference);
    }

    private void deactivateComponentManager() {
        this.m_componentManager.deactivateInternal(2, false, false);
    }

    private static interface Customizer<S, T>
    extends ServiceTrackerCustomizer<T, RefPair<S, T>, ExtendedServiceEvent> {
        public boolean prebind(ComponentContextImpl<S> var1);

        public void close();

        public Collection<RefPair<S, T>> getRefs(AtomicInteger var1);

        public boolean isSatisfied();

        public void setTracker(ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> var1);

        public void setTrackerOpened();

        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<S, T>> var1);
    }

    public static final class OpenStatusImpl<S, T>
    implements OpenStatus<S, T> {
        private final DependencyManager<S, T> dm;

        OpenStatusImpl(DependencyManager<S, T> dm) {
            this.dm = dm;
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            return ((DependencyManager)this.dm).m_customizer.getRefs(trackingCount);
        }
    }

    private class NoPermissionsCustomizer
    implements Customizer<S, T> {
        private NoPermissionsCustomizer() {
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            return Collections.emptyList();
        }

        @Override
        public boolean isSatisfied() {
            return DependencyManager.this.isOptional();
        }

        @Override
        public void setTracker(ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tRefPairServiceTracker) {
        }

        @Override
        public void setTrackerOpened() {
        }

        @Override
        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<S, T>> previousRefMap) {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> tServiceReference) {
            return null;
        }

        @Override
        public void addedService(ServiceReference<T> tServiceReference, RefPair<S, T> service, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
        }

        @Override
        public void modifiedService(ServiceReference<T> tServiceReference, RefPair<S, T> service, int trackingCount, ExtendedServiceEvent event) {
        }

        @Override
        public void removedService(ServiceReference<T> tServiceReference, RefPair<S, T> service, int trackingCount, ExtendedServiceEvent event) {
        }
    }

    private class FactoryCustomizer
    extends AbstractCustomizer {
        private FactoryCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = DependencyManager.this.newRefPair(serviceReference);
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            if (DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                DependencyManager.this.m_componentManager.activateInternal();
            }
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            refPair.markDeleted();
            if (!DependencyManager.this.cardinalitySatisfied()) {
                DependencyManager.this.deactivateComponentManager();
            }
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            ServiceTracker tracker = this.getTracker();
            if (tracker == null) {
                return false;
            }
            AtomicInteger trackingCount = new AtomicInteger();
            int serviceCount = tracker.getTracked(true, trackingCount).size();
            return DependencyManager.this.cardinalitySatisfied(serviceCount);
        }

        @Override
        public void close() {
            this.deactivateTracker();
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            return Collections.emptyList();
        }
    }

    private class MultipleStaticReluctantCustomizer
    extends AbstractCustomizer {
        private final AtomicReference<Collection<RefPair<S, T>>> refs;
        private int trackingCount;

        private MultipleStaticReluctantCustomizer() {
            this.refs = new AtomicReference();
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = DependencyManager.this.newRefPair(serviceReference);
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticReluctant added {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            this.tracked(trackingCount);
            if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount) && !this.isActive()) {
                DependencyManager.this.m_componentManager.activateInternal();
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticReluctant added {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticReluctant modified {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            boolean reactivate = false;
            Collection refs = this.refs.get();
            if (this.isActive() && refs != null && refs.contains(refPair)) {
                reactivate = DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.tracked(trackingCount);
            if (reactivate) {
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticReluctant modified {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticReluctant removed {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            refPair.markDeleted();
            this.tracked(trackingCount);
            Collection refs = this.refs.get();
            if (this.isActive() && refs != null) {
                if (refs.contains(refPair)) {
                    DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "Dependency Manager: Static dependency on {0}/{1} is broken", null, DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface());
                    DependencyManager.this.deactivateComponentManager();
                    if (event != null) {
                        event.addComponentManager(DependencyManager.this.m_componentManager);
                    }
                }
            } else if (!DependencyManager.this.cardinalitySatisfied()) {
                DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "Dependency Manager: Static dependency on {0}/{1} is broken", null, DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface());
                DependencyManager.this.deactivateComponentManager();
            }
            this.ungetService(refPair);
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticReluctant removed {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            int serviceCount = 0;
            Collection refs = this.refs.get();
            if (refs != null) {
                for (RefPair refPair : refs) {
                    if (!DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair)) continue;
                    ++serviceCount;
                }
                return DependencyManager.this.cardinalitySatisfied(serviceCount);
            }
            refs = new ArrayList();
            AtomicInteger trackingCount = new AtomicInteger();
            ServiceTracker tracker = this.getTracker();
            Map<Object, Object> tracked = tracker == null ? Collections.emptyMap() : tracker.getTracked(true, trackingCount);
            for (RefPair refPair : tracked.values()) {
                if (DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair)) {
                    ++serviceCount;
                }
                refs.add(refPair);
            }
            if (this.refs.compareAndSet(null, refs)) {
                this.trackingCount = trackingCount.get();
            } else {
                Collection actualRefs = this.refs.get();
                refs.removeAll(actualRefs);
                for (RefPair ref : refs) {
                    this.ungetService(ref);
                }
            }
            return DependencyManager.this.cardinalitySatisfied(serviceCount);
        }

        @Override
        public void close() {
            Collection refs = this.refs.getAndSet(null);
            if (refs != null) {
                for (RefPair ref : refs) {
                    this.ungetService(ref);
                }
            }
            this.deactivateTracker();
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            trackingCount.set(this.trackingCount);
            Collection refs = this.refs.get();
            return refs == null ? Collections.emptyList() : refs;
        }
    }

    private class MultipleStaticGreedyCustomizer
    extends AbstractCustomizer {
        private MultipleStaticGreedyCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = DependencyManager.this.newRefPair(serviceReference);
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticGreedy added {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            this.tracked(trackingCount);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "Dependency Manager: Static dependency on {0}/{1} is broken", null, DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface());
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            } else if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                DependencyManager.this.m_componentManager.activateInternal();
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticGreedy added {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticGreedy modified {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            boolean reactivate = false;
            if (this.isActive()) {
                reactivate = DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.tracked(trackingCount);
            if (reactivate) {
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticGreedy modified {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticGreedy removed {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            refPair.markDeleted();
            this.tracked(trackingCount);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "Dependency Manager: Static dependency on {0}/{1} is broken", null, DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface());
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            } else if (!DependencyManager.this.cardinalitySatisfied()) {
                DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "Dependency Manager: Static dependency on {0}/{1} is broken", null, DependencyManager.this.getName(), DependencyManager.this.m_dependencyMetadata.getInterface());
                DependencyManager.this.deactivateComponentManager();
            }
            this.ungetService(refPair);
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleStaticGreedy removed {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            ServiceTracker tracker = this.getTracker();
            if (tracker == null) {
                return false;
            }
            int serviceCount = 0;
            AtomicInteger trackingCount = new AtomicInteger();
            SortedMap tracked = tracker.getTracked(DependencyManager.this.cardinalitySatisfied(tracker.getServiceCount()), trackingCount);
            for (RefPair refPair : tracked.values()) {
                if (!DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair)) continue;
                ++serviceCount;
            }
            return DependencyManager.this.cardinalitySatisfied(serviceCount);
        }

        @Override
        public void close() {
            AtomicInteger trackingCount = new AtomicInteger();
            for (RefPair ref : this.getRefs(trackingCount)) {
                this.ungetService(ref);
            }
            this.deactivateTracker();
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker tracker = this.getTracker();
            if (tracker == null) {
                return Collections.emptyList();
            }
            return tracker.getTracked(null, trackingCount).values();
        }
    }

    private class MultipleDynamicCustomizer
    extends AbstractCustomizer {
        private RefPair<S, T> lastRefPair;
        private int lastRefPairTrackingCount;

        private MultipleDynamicCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = this.getPreviousRefMap().get(serviceReference);
            if (refPair == null) {
                refPair = DependencyManager.this.newRefPair(serviceReference);
            }
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.TRACE, "dm {0} tracking {1} MultipleDynamic added {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            boolean tracked = false;
            if (this.getPreviousRefMap().remove(serviceReference) == null) {
                if (this.isActive()) {
                    DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleDynamic already active, binding {2}", null, DependencyManager.this.getName(), trackingCount, serviceReference);
                    DependencyManager.this.m_componentManager.invokeBindMethod(DependencyManager.this, refPair, trackingCount);
                    if (refPair.isFailed()) {
                        DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, serviceReference, trackingCount);
                    }
                } else if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                    DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleDynamic, activating", null, DependencyManager.this.getName(), trackingCount);
                    this.tracked(trackingCount);
                    tracked = true;
                    DependencyManager.this.m_componentManager.activateInternal();
                } else {
                    DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleDynamic, inactive, doing nothing: tracker opened: {2}, optional: {3}", null, DependencyManager.this.getName(), trackingCount, this.isTrackerOpened(), DependencyManager.this.isOptional());
                }
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.TRACE, "dm {0} tracking {1} MultipleDynamic added {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            if (!tracked) {
                this.tracked(trackingCount);
            }
        }

        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleDynamic modified {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            if (this.isActive()) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleDynamic modified {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            this.tracked(trackingCount);
        }

        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleDynamic removed {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            refPair.markDeleted();
            boolean unbind = DependencyManager.this.cardinalitySatisfied();
            if (unbind) {
                if (this.isActive()) {
                    DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, refPair, trackingCount);
                }
                DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleDynamic removed (unbind) {2}", null, DependencyManager.this.getName(), trackingCount, serviceReference);
                this.tracked(trackingCount);
            } else {
                this.lastRefPair = refPair;
                this.lastRefPairTrackingCount = trackingCount;
                this.tracked(trackingCount);
                DependencyManager.this.deactivateComponentManager();
                this.lastRefPair = null;
                DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} MultipleDynamic removed (deactivate) {2}", null, DependencyManager.this.getName(), trackingCount, serviceReference);
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            this.ungetService(refPair);
        }

        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            ServiceTracker tracker = this.getTracker();
            if (tracker == null) {
                return false;
            }
            int serviceCount = 0;
            AtomicInteger trackingCount = new AtomicInteger();
            SortedMap tracked = tracker.getTracked(true, trackingCount);
            ArrayList failed = new ArrayList();
            for (RefPair refPair : tracked.values()) {
                if (DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair)) {
                    ++serviceCount;
                    continue;
                }
                failed.add(refPair);
            }
            if (DependencyManager.this.cardinalitySatisfied(serviceCount)) {
                for (RefPair refPair : failed) {
                    DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
                }
                return true;
            }
            return false;
        }

        @Override
        public void close() {
            AtomicInteger trackingCount = new AtomicInteger();
            for (RefPair ref : this.getRefs(trackingCount)) {
                this.ungetService(ref);
            }
            this.deactivateTracker();
        }

        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            if (this.lastRefPair == null) {
                ServiceTracker tracker = this.getTracker();
                if (tracker == null) {
                    trackingCount.set(this.lastRefPairTrackingCount);
                    return Collections.emptyList();
                }
                return tracker.getTracked(null, trackingCount).values();
            }
            trackingCount.set(this.lastRefPairTrackingCount);
            return Collections.singletonList(this.lastRefPair);
        }
    }

    private class SingleStaticCustomizer
    extends AbstractCustomizer {
        private RefPair<S, T> refPair;
        private int trackingCount;

        private SingleStaticCustomizer() {
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = DependencyManager.this.newRefPair(serviceReference);
            return refPair;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            ServiceTracker.Tracked monitor;
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleStatic added {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            this.trackingCount = trackingCount;
            this.tracked(trackingCount);
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null && this.isActive()) {
                boolean reactivate;
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    reactivate = !DependencyManager.this.isReluctant() && (this.refPair == null || refPair.getRef().compareTo(this.refPair.getRef()) > 0);
                }
                if (reactivate) {
                    DependencyManager.this.deactivateComponentManager();
                    if (event != null) {
                        event.addComponentManager(DependencyManager.this.m_componentManager);
                    }
                } else {
                    DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleStatic active but new {2} is worse match than old {3}", null, DependencyManager.this.getName(), trackingCount, refPair, this.refPair);
                }
            } else if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                DependencyManager.this.m_componentManager.activateInternal();
            } else {
                DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleStatic active: {2} trackerOpened: {3} optional: {4}", null, DependencyManager.this.getName(), trackingCount, this.isActive(), this.isTrackerOpened(), DependencyManager.this.isOptional());
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleStatic added {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleStatic modified {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            boolean invokeUpdated = false;
            ServiceTracker.Tracked monitor = this.getTracker().tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked = monitor;
                synchronized (tracked) {
                    invokeUpdated = this.isActive() && refPair == this.refPair;
                }
            }
            boolean reactivate = false;
            if (invokeUpdated) {
                reactivate = DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.trackingCount = trackingCount;
            this.tracked(trackingCount);
            if (reactivate) {
                DependencyManager.this.deactivateComponentManager();
                ServiceTracker.Tracked tracked = monitor;
                synchronized (tracked) {
                    if (refPair == this.refPair) {
                        this.refPair = null;
                    }
                }
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleStatic modified {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            ServiceTracker.Tracked monitor;
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleStatic removed {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            refPair.markDeleted();
            this.trackingCount = trackingCount;
            this.tracked(trackingCount);
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null) {
                boolean reactivate;
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    boolean bl = reactivate = this.isActive() && refPair == this.refPair || !DependencyManager.this.cardinalitySatisfied(tracker.getServiceCount());
                    if (!reactivate && refPair == this.refPair) {
                        this.refPair = null;
                    }
                }
                if (reactivate) {
                    DependencyManager.this.deactivateComponentManager();
                    tracked2 = monitor;
                    synchronized (tracked2) {
                        if (refPair == this.refPair) {
                            this.refPair = null;
                        }
                    }
                    if (event != null) {
                        event.addComponentManager(DependencyManager.this.m_componentManager);
                    }
                }
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleStatic removed {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            ServiceTracker.Tracked monitor;
            RefPair refPair = null;
            boolean success = DependencyManager.this.cardinalitySatisfied(0);
            AtomicInteger trackingCount = new AtomicInteger();
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    SortedMap tracked3;
                    if (!(!success && tracker.isEmpty() || (tracked3 = tracker.getTracked(true, trackingCount)).isEmpty())) {
                        refPair = tracked3.values().iterator().next();
                        this.refPair = refPair;
                    }
                }
            }
            if (refPair != null) {
                success |= DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair);
                if (refPair.isFailed()) {
                    DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
                }
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ServiceTracker.Tracked monitor;
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null) {
                RefPair ref;
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    ref = this.refPair;
                    this.refPair = null;
                }
                if (ref != null) {
                    this.ungetService(ref);
                }
                tracker.deactivate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker.Tracked monitor;
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    trackingCount.set(this.trackingCount);
                    return this.refPair == null ? Collections.emptyList() : Collections.singleton(this.refPair);
                }
            }
            return Collections.emptyList();
        }
    }

    private class SingleDynamicCustomizer
    extends AbstractCustomizer {
        private RefPair<S, T> currentRefPair;
        private RefPair<S, T> bindingRefPair;
        private Collection<RefPair<S, T>> queuedRefPairs;
        private Thread bindingThread;
        private int trackingCount;

        private SingleDynamicCustomizer() {
            this.queuedRefPairs = new ArrayList();
        }

        @Override
        public RefPair<S, T> addingService(ServiceReference<T> serviceReference) {
            RefPair refPair = this.getPreviousRefMap().get(serviceReference);
            if (refPair == null) {
                refPair = DependencyManager.this.newRefPair(serviceReference);
            }
            return refPair;
        }

        @Override
        public void addedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, int serviceCount, ExtendedServiceEvent event) {
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleDynamic added {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            boolean tracked = false;
            if (this.getPreviousRefMap().remove(serviceReference) == null) {
                if (this.isActive()) {
                    ServiceTracker.Tracked monitor;
                    ServiceTracker tracker = this.getTracker();
                    ServiceTracker.Tracked tracked2 = monitor = tracker == null ? null : tracker.tracked();
                    if (monitor != null) {
                        this.tryInvokeBind(tracker, monitor, refPair, trackingCount);
                    }
                } else if (this.isTrackerOpened() && DependencyManager.this.cardinalityJustSatisfied(serviceCount)) {
                    this.tracked(trackingCount);
                    tracked = true;
                    DependencyManager.this.m_componentManager.activateInternal();
                }
            }
            this.trackingCount = trackingCount;
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleDynamic added {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            if (!tracked) {
                this.tracked(trackingCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryInvokeBind(ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker, Object monitor, RefPair<S, T> next, int trackingCount) {
            boolean checkQueue = false;
            do {
                try {
                    while ((next = this.tryInvokeBind0(tracker, monitor, next, trackingCount)) != null) {
                    }
                }
                finally {
                    Object object = monitor;
                    synchronized (object) {
                        if (this.bindingThread != null && this.bindingThread.equals(Thread.currentThread())) {
                            if (this.queuedRefPairs.isEmpty()) {
                                this.bindingRefPair = null;
                                this.bindingThread = null;
                            } else {
                                next = this.getBestFromQueue();
                                checkQueue = true;
                            }
                        }
                    }
                }
            } while (checkQueue);
        }

        private RefPair<S, T> getBestFromQueue() {
            RefPair currentBest = null;
            for (RefPair betterCandidate : this.queuedRefPairs) {
                if (currentBest != null && betterCandidate.getRef().compareTo(currentBest.getRef()) <= 0) continue;
                currentBest = betterCandidate;
            }
            this.queuedRefPairs.clear();
            return currentBest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RefPair<S, T> tryInvokeBind0(ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker, Object monitor, RefPair<S, T> refPair, int trackingCount) {
            RefPair current;
            boolean invokeBind = false;
            Object object = monitor;
            synchronized (object) {
                current = this.currentRefPair;
                boolean bl = invokeBind = current == null || current.isDeleted() || !DependencyManager.this.isReluctant() && refPair.getRef().compareTo(current.getRef()) > 0;
                if (invokeBind) {
                    if (this.bindingThread != null && !this.bindingThread.equals(Thread.currentThread())) {
                        if (refPair.getRef().compareTo(this.bindingRefPair.getRef()) > 0) {
                            this.queuedRefPairs.add(refPair);
                        }
                        return null;
                    }
                    this.bindingRefPair = refPair;
                    this.bindingThread = Thread.currentThread();
                }
            }
            if (invokeBind) {
                boolean invokedUnbind = false;
                DependencyManager.this.m_componentManager.invokeBindMethod(DependencyManager.this, refPair, trackingCount);
                if (!refPair.isFailed()) {
                    if (current != null) {
                        DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, current, trackingCount);
                        invokedUnbind = true;
                        this.ungetService(current);
                    }
                } else if (DependencyManager.this.cardinalitySatisfied(0)) {
                    DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount);
                }
                RefPair next = null;
                Object object2 = monitor;
                synchronized (object2) {
                    if (!this.queuedRefPairs.isEmpty()) {
                        next = this.getBestFromQueue();
                        this.bindingRefPair = next;
                        if (invokedUnbind) {
                            this.currentRefPair = null;
                        }
                    } else if (this.bindingRefPair.isDeleted()) {
                        Iterator iNext = this.getTracker().getTracked(null, new AtomicInteger()).values().iterator();
                        next = iNext.hasNext() ? iNext.next() : null;
                        this.bindingRefPair = next;
                        if (invokedUnbind) {
                            this.currentRefPair = null;
                        }
                    } else {
                        this.currentRefPair = this.bindingRefPair;
                        this.bindingRefPair = null;
                        this.bindingThread = null;
                        return null;
                    }
                }
                DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, refPair, trackingCount);
                this.ungetService(refPair);
                return next;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modifiedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            ServiceTracker.Tracked monitor;
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleDynamic modified {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            boolean invokeUpdated = false;
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    invokeUpdated = this.isActive() && refPair == this.currentRefPair;
                }
            }
            if (invokeUpdated) {
                DependencyManager.this.m_componentManager.invokeUpdatedMethod(DependencyManager.this, refPair, trackingCount);
            }
            this.trackingCount = trackingCount;
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleDynamic modified {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            this.tracked(trackingCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removedService(ServiceReference<T> serviceReference, RefPair<S, T> refPair, int trackingCount, ExtendedServiceEvent event) {
            ServiceTracker.Tracked tracked;
            ServiceTracker.Tracked monitor;
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleDynamic removed {2} (enter)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
            boolean deactivate = false;
            boolean untracked = true;
            RefPair oldRefPair = null;
            RefPair nextRefPair = null;
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked2 = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null) {
                tracked = monitor;
                synchronized (tracked) {
                    refPair.markDeleted();
                    if (refPair == this.currentRefPair && this.isActive()) {
                        if (!this.getTracker().isEmpty()) {
                            SortedMap tracked3 = this.getTracker().getTracked(null, new AtomicInteger());
                            nextRefPair = tracked3.values().iterator().next();
                        }
                        if (DependencyManager.this.isEffectivelyOptional() || nextRefPair != null) {
                            oldRefPair = this.currentRefPair;
                        } else {
                            deactivate = true;
                        }
                    } else if (!DependencyManager.this.cardinalitySatisfied() && this.currentRefPair == null) {
                        deactivate = true;
                    }
                }
            }
            if (nextRefPair != null) {
                this.tryInvokeBind(tracker, monitor, nextRefPair, trackingCount);
            }
            if (oldRefPair != null) {
                this.trackingCount = trackingCount;
                tracked = monitor;
                synchronized (tracked) {
                    if (oldRefPair != this.currentRefPair) {
                        oldRefPair = null;
                        if (this.currentRefPair == null) {
                            deactivate = !DependencyManager.this.isEffectivelyOptional();
                        }
                    } else {
                        this.currentRefPair = null;
                    }
                }
                if (oldRefPair != null) {
                    DependencyManager.this.m_componentManager.invokeUnbindMethod(DependencyManager.this, oldRefPair, trackingCount);
                    this.ungetService(oldRefPair);
                }
                this.tracked(trackingCount);
                untracked = false;
            }
            if (deactivate) {
                this.trackingCount = trackingCount;
                this.tracked(trackingCount);
                untracked = false;
                DependencyManager.this.deactivateComponentManager();
                if (event != null) {
                    event.addComponentManager(DependencyManager.this.m_componentManager);
                }
            }
            if (untracked) {
                this.trackingCount = trackingCount;
                this.tracked(trackingCount);
            }
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracking {1} SingleDynamic removed {2} (exit)", null, DependencyManager.this.getName(), trackingCount, serviceReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean prebind(ComponentContextImpl<S> key) {
            ServiceTracker.Tracked monitor;
            RefPair refPair = null;
            boolean success = DependencyManager.this.cardinalitySatisfied(0);
            AtomicInteger trackingCount = new AtomicInteger();
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    SortedMap tracked3;
                    if (!(!success && tracker.isEmpty() || (tracked3 = tracker.getTracked(true, trackingCount)).isEmpty())) {
                        refPair = tracked3.values().iterator().next();
                        this.currentRefPair = refPair;
                    }
                }
            }
            if (refPair != null) {
                success |= DependencyManager.this.getServiceObject(key, DependencyManager.this.m_bindMethods.getBind(), refPair);
                if (refPair.isFailed() && DependencyManager.this.cardinalitySatisfied(0)) {
                    DependencyManager.this.m_componentManager.registerMissingDependency(DependencyManager.this, refPair.getRef(), trackingCount.get());
                }
            }
            return success;
        }

        @Override
        public void close() {
            this.closeRefPair();
            this.deactivateTracker();
        }

        private void closeRefPair() {
            if (this.currentRefPair != null) {
                this.ungetService(this.currentRefPair);
            }
            this.currentRefPair = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<RefPair<S, T>> getRefs(AtomicInteger trackingCount) {
            ServiceTracker.Tracked monitor;
            ServiceTracker tracker = this.getTracker();
            ServiceTracker.Tracked tracked = monitor = tracker == null ? null : tracker.tracked();
            if (monitor != null) {
                ServiceTracker.Tracked tracked2 = monitor;
                synchronized (tracked2) {
                    trackingCount.set(this.trackingCount);
                    RefPair current = this.bindingRefPair != null ? this.bindingRefPair : this.currentRefPair;
                    return current == null ? Collections.emptyList() : Collections.singleton(current);
                }
            }
            return Collections.emptyList();
        }
    }

    private abstract class AbstractCustomizer
    implements Customizer<S, T> {
        private final Map<ServiceReference<T>, RefPair<S, T>> EMPTY_REF_MAP = Collections.emptyMap();
        private volatile boolean trackerOpened;
        private volatile Map<ServiceReference<T>, RefPair<S, T>> previousRefMap = this.EMPTY_REF_MAP;

        private AbstractCustomizer() {
        }

        @Override
        public void setTracker(ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> tracker) {
            DependencyManager.this.m_tracker = tracker;
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracker reset (closed)", null, DependencyManager.this.getName());
            this.trackerOpened = false;
        }

        @Override
        public boolean isSatisfied() {
            return DependencyManager.this.cardinalitySatisfied();
        }

        protected ServiceTracker<T, RefPair<S, T>, ExtendedServiceEvent> getTracker() {
            return DependencyManager.this.m_tracker;
        }

        protected boolean isActive() {
            ServiceTracker tracker = this.getTracker();
            return tracker != null && tracker.isActive();
        }

        protected boolean isTrackerOpened() {
            return this.trackerOpened;
        }

        @Override
        public void setTrackerOpened() {
            this.trackerOpened = true;
            DependencyManager.this.m_componentManager.getLogger().log(InternalLogger.Level.DEBUG, "dm {0} tracker opened", null, DependencyManager.this.getName());
        }

        protected void deactivateTracker() {
            ServiceTracker tracker = this.getTracker();
            if (tracker != null) {
                tracker.deactivate();
            }
        }

        protected Map<ServiceReference<T>, RefPair<S, T>> getPreviousRefMap() {
            return this.previousRefMap;
        }

        @Override
        public void setPreviousRefMap(Map<ServiceReference<T>, RefPair<S, T>> previousRefMap) {
            this.previousRefMap = previousRefMap != null ? previousRefMap : this.EMPTY_REF_MAP;
        }

        protected void ungetService(RefPair<S, T> ref) {
            ref.ungetServiceObjects(DependencyManager.this.m_componentManager.getBundleContext());
        }

        protected void tracked(int trackingCount) {
            DependencyManager.this.m_componentManager.tracked(trackingCount);
        }
    }
}

