/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.internal.texteditor.stickyscroll.IStickyLine;

public class StickyLine
implements IStickyLine {
    private int lineNumber;
    private String text;
    private StyledText textWidget;

    public StickyLine(int lineNumber, StyledText textWidget) {
        this.lineNumber = lineNumber;
        this.textWidget = textWidget;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.textWidget.getLine(this.lineNumber);
        }
        return this.text;
    }

    @Override
    public StyleRange[] getStyleRanges() {
        StyleRange[] styleRanges;
        int offsetAtLine = this.textWidget.getOffsetAtLine(this.lineNumber);
        StyleRange[] styleRangeArray = styleRanges = this.textWidget.getStyleRanges(offsetAtLine, this.getText().length());
        int n = styleRanges.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange styleRange = styleRangeArray[n2];
            styleRange.start -= offsetAtLine;
            ++n2;
        }
        return styleRanges;
    }
}

