/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;

public final class EnumDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private static final int CACHE_SIZE = 4096;
    private IntervalNode fEnumRoot;
    private final IntegerDeclaration fContainerType;
    private Pair fLastAdded = new Pair(-1L, -1L);
    private @Nullable String[] fCache = new String[4096];

    public EnumDeclaration(IntegerDeclaration containerType) {
        this.fContainerType = containerType;
    }

    public EnumDeclaration(IntegerDeclaration containerType, Map<Pair, String> enumTree) {
        this.fContainerType = containerType;
        enumTree.entrySet().forEach(entry -> this.insert((Pair)entry.getKey(), (String)entry.getValue()));
    }

    public IntegerDeclaration getContainerType() {
        return this.fContainerType;
    }

    @Override
    public long getAlignment() {
        return this.getContainerType().getAlignment();
    }

    @Override
    public int getMaximumSize() {
        return this.fContainerType.getMaximumSize();
    }

    @Override
    public boolean isByteOrderSet() {
        return this.fContainerType.isByteOrderSet();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fContainerType.getByteOrder();
    }

    @Override
    public EnumDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        IntegerDefinition value = this.getContainerType().createDefinition(definitionScope, fieldName, input);
        return new EnumDefinition(this, definitionScope, fieldName, value);
    }

    public boolean add(long low, long high, @Nullable String label) {
        if (high < low) {
            return false;
        }
        if (low < 0L || low >= 4095L || high < 0L || high >= 4095L) {
            this.fCache = null;
        }
        int i = (int)low;
        while ((long)i <= high) {
            if (this.fCache == null) break;
            if (this.fCache[i] != null) {
                this.fCache = null;
                break;
            }
            this.fCache[i] = label;
            ++i;
        }
        Pair key = new Pair(low, high);
        this.insert(key, label);
        this.fLastAdded = key;
        return true;
    }

    private void insert(Pair interval, String label) {
        this.fEnumRoot = this.insertNode(this.fEnumRoot, interval, label);
    }

    private IntervalNode insertNode(IntervalNode node, Pair interval, String label) {
        if (node == null) {
            return new IntervalNode(interval, label);
        }
        if (interval.equals(node.interval)) {
            node.labels.add(label);
            return node;
        }
        if (interval.getFirst() < node.interval.getFirst()) {
            node.left = this.insertNode(node.left, interval, label);
        } else {
            node.right = this.insertNode(node.right, interval, label);
        }
        node.maxEnd = Math.max(node.maxEnd, interval.getSecond());
        return node;
    }

    public boolean add(@Nullable String label) {
        return this.add(this.fLastAdded.fSecond + 1L, this.fLastAdded.fSecond + 1L, label);
    }

    public @Nullable String query(long value) {
        if (this.fCache != null) {
            if (value < 0L || value >= 4096L) {
                return null;
            }
            return this.fCache[(int)value];
        }
        ArrayList<String> strValues = new ArrayList<String>();
        this.queryIntersecting(this.fEnumRoot, value, strValues);
        if (!strValues.isEmpty()) {
            return strValues.size() == 1 ? (String)strValues.get(0) : ((Object)strValues).toString();
        }
        ArrayList<String> flagsSet = new ArrayList<String>();
        int i = 0;
        while (i < 64) {
            Long bitValue = 1L << i;
            if ((bitValue & value) != 0L) {
                ArrayList<String> bitFlags = new ArrayList<String>();
                this.queryExact(this.fEnumRoot, bitValue, bitFlags);
                if (bitFlags.isEmpty()) {
                    return null;
                }
                flagsSet.add(bitFlags.size() == 1 ? (String)bitFlags.get(0) : ((Object)bitFlags).toString());
            }
            ++i;
        }
        return flagsSet.isEmpty() ? null : String.join((CharSequence)" | ", flagsSet);
    }

    private void queryIntersecting(IntervalNode node, long value, List<String> result) {
        if (node == null || node.maxEnd < value) {
            return;
        }
        if (value >= node.interval.getFirst() && value <= node.interval.getSecond()) {
            result.addAll(node.labels);
        }
        if (node.left != null && node.left.maxEnd >= value) {
            this.queryIntersecting(node.left, value, result);
        }
        this.queryIntersecting(node.right, value, result);
    }

    private void queryExact(IntervalNode node, long value, List<String> result) {
        if (node == null) {
            return;
        }
        if (node.interval.getFirst() == value && node.interval.getSecond() == value) {
            result.addAll(node.labels);
        }
        if (value < node.interval.getFirst()) {
            this.queryExact(node.left, value, result);
        } else if (value > node.interval.getFirst()) {
            this.queryExact(node.right, value, result);
        } else {
            this.queryExact(node.left, value, result);
            this.queryExact(node.right, value, result);
        }
    }

    public Map<Pair, String> getLookupTable() {
        LinkedHashMap<Pair, String> table = new LinkedHashMap<Pair, String>();
        this.collectEntries(this.fEnumRoot, table);
        return table;
    }

    private void collectEntries(IntervalNode node, Map<Pair, String> table) {
        if (node == null) {
            return;
        }
        String value = node.labels.size() == 1 ? node.labels.get(0) : node.labels.toString();
        table.put(node.interval, value);
        this.collectEntries(node.left, table);
        this.collectEntries(node.right, table);
    }

    public Set<String> getLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        this.collectLabels(this.fEnumRoot, labels);
        return ImmutableSet.copyOf(labels);
    }

    private void collectLabels(IntervalNode node, List<String> labels) {
        if (node == null) {
            return;
        }
        labels.addAll(node.labels);
        this.collectLabels(node.left, labels);
        this.collectLabels(node.right, labels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] enum[");
        for (String label : this.getLabels()) {
            sb.append("label:").append(label).append(' ');
        }
        sb.append("type:").append(this.fContainerType.toString());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fContainerType, this.getLookupTable());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.equals(other.fContainerType)) {
            return false;
        }
        return Objects.equals(this.getLookupTable(), other.getLookupTable());
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.isBinaryEquivalent((IDeclaration)other.fContainerType)) {
            return false;
        }
        return Objects.equals(this.getLookupTable(), other.getLookupTable());
    }

    private static class IntervalNode {
        final Pair interval;
        final List<String> labels;
        long maxEnd;
        IntervalNode left;
        IntervalNode right;

        IntervalNode(Pair interval, String label) {
            this.interval = interval;
            this.labels = new ArrayList<String>();
            this.labels.add(label);
            this.maxEnd = interval.getSecond();
        }
    }

    public static class Pair {
        private final long fFirst;
        private final long fSecond;

        private Pair(long first, long second) {
            this.fFirst = first;
            this.fSecond = second;
        }

        public long getFirst() {
            return this.fFirst;
        }

        public long getSecond() {
            return this.fSecond;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return this.fFirst == other.fFirst && this.fSecond == other.fSecond;
        }

        public int hashCode() {
            return Objects.hash(this.fFirst, this.fSecond);
        }

        public String toString() {
            return Arrays.toString(new long[]{this.fFirst, this.fSecond});
        }
    }
}

