/*******************************************************************************
 * Copyright (c) 2015, 2016 EfficiOS Inc., Alexandre Montplaisir
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/

package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module;

import java.util.List;

import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysisReport;

import com.google.common.collect.ImmutableList;

/**
 * Report generated by LAMI analyses.
 *
 * @author Alexandre Montplaisir
 */
public class LamiAnalysisReport implements IOnDemandAnalysisReport {

    private final String fReportName;
    private final List<LamiResultTable> fTables;

    /**
     * Constructor
     *
     * @param reportName
     *            Name of the report (to be shown in the UI)
     * @param tables
     *            The result tables that are part of this report
     */
    public LamiAnalysisReport(String reportName, List<LamiResultTable> tables) {
        fReportName = reportName;
        fTables = ImmutableList.copyOf(tables);
    }

    @Override
    public String getName() {
        return fReportName;
    }

    /**
     * Get the result tables of this report
     *
     * @return The result tables
     */
    public List<LamiResultTable> getTables() {
        return fTables;
    }

}
