/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTArrayRangeDesignator;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTArrayRangeDesignator
extends ASTNode
implements IGPPASTArrayRangeDesignator,
IASTAmbiguityParent {
    private ICPPASTExpression floor;
    private ICPPASTExpression ceiling;

    public CPPASTArrayRangeDesignator() {
    }

    public CPPASTArrayRangeDesignator(ICPPASTExpression floor, ICPPASTExpression ceiling) {
        this.setRangeFloor(floor);
        this.setRangeCeiling(ceiling);
    }

    @Override
    public CPPASTArrayRangeDesignator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTArrayRangeDesignator copy(IASTNode.CopyStyle style) {
        CPPASTArrayRangeDesignator copy = new CPPASTArrayRangeDesignator();
        copy.setRangeFloor(this.floor == null ? null : (ICPPASTExpression)this.floor.copy(style));
        copy.setRangeCeiling(this.ceiling == null ? null : (ICPPASTExpression)this.ceiling.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public ICPPASTExpression getRangeFloor() {
        return this.floor;
    }

    @Override
    public void setRangeFloor(ICPPASTExpression expression) {
        this.assertNotFrozen();
        this.floor = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(SUBSCRIPT_FLOOR_EXPRESSION);
        }
    }

    @Override
    public ICPPASTExpression getRangeCeiling() {
        return this.ceiling;
    }

    @Override
    public void setRangeCeiling(ICPPASTExpression expression) {
        this.assertNotFrozen();
        this.ceiling = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(SUBSCRIPT_CEILING_EXPRESSION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDesignators) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.floor != null && !this.floor.accept(action)) {
            return false;
        }
        if (this.ceiling != null && !this.ceiling.accept(action)) {
            return false;
        }
        return !action.shouldVisitDesignators || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.floor) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.floor = (ICPPASTExpression)other;
        }
        if (child == this.ceiling) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.ceiling = (ICPPASTExpression)other;
        }
    }
}

