/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.matching;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.matching.EventMatchingBuildRequest;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.IMatchProcessingUnit;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfEventMatching;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.Messages;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatches;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class TmfEventMatching
implements ITmfEventMatching {
    private static final Set<ITmfMatchEventDefinition> MATCH_DEFINITIONS = new HashSet<ITmfMatchEventDefinition>();
    private final @NonNull Collection<@NonNull ITmfTrace> fTraces;
    private final @NonNull Collection<@NonNull ITmfTrace> fIndividualTraces;
    private final @NonNull Collection<@NonNull String> fDistinctHosts;
    private final IMatchProcessingUnit fMatches;
    private final Multimap<ITmfTrace, ITmfMatchEventDefinition> fMatchMap = HashMultimap.create();
    private final Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> fUnmatchedIn = HashBasedTable.create();
    private final Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> fUnmatchedOut = HashBasedTable.create();
    private final Map<Class<? extends IEventMatchingKey>, Table<String, String, TmfEventDependency>> fLastMatches = new HashMap<Class<? extends IEventMatchingKey>, Table<String, String, TmfEventDependency>>();
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$tmf$core$event$matching$TmfEventMatching$Direction;

    public TmfEventMatching(Collection<@NonNull ITmfTrace> traces) {
        this(traces, new TmfEventMatches());
    }

    public TmfEventMatching(Collection<@NonNull ITmfTrace> traces, IMatchProcessingUnit tmfEventMatches) {
        if (tmfEventMatches == null) {
            throw new IllegalArgumentException();
        }
        this.fTraces = new HashSet<ITmfTrace>(traces);
        this.fMatches = tmfEventMatches;
        HashSet<@NonNull ITmfTrace> individualTraces = new HashSet<ITmfTrace>();
        for (ITmfTrace trace : traces) {
            individualTraces.addAll(TmfTraceManager.getTraceSet(trace));
        }
        this.fIndividualTraces = individualTraces;
        this.fDistinctHosts = individualTraces.stream().map(ITmfTrace::getHostId).collect(Collectors.toSet());
    }

    protected Collection<ITmfTrace> getTraces() {
        return new HashSet<ITmfTrace>(this.fTraces);
    }

    protected Collection<ITmfTrace> getIndividualTraces() {
        return this.fIndividualTraces;
    }

    protected IMatchProcessingUnit getProcessingUnit() {
        return this.fMatches;
    }

    protected Collection<ITmfMatchEventDefinition> getEventDefinitions(ITmfTrace trace) {
        return ImmutableList.copyOf((Collection)this.fMatchMap.get((Object)trace));
    }

    public void initMatching() {
        this.fUnmatchedIn.clear();
        this.fUnmatchedOut.clear();
        this.fMatches.init(this.fTraces);
        for (ITmfTrace trace : this.getIndividualTraces()) {
            for (ITmfMatchEventDefinition def : MATCH_DEFINITIONS) {
                if (!def.canMatchTrace(trace)) continue;
                this.fMatchMap.put((Object)trace, (Object)def);
            }
        }
    }

    protected void finalizeMatching() {
        this.fMatches.matchingEnded();
    }

    public String toString() {
        String cr = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        b.append(this.getProcessingUnit());
        int i = 0;
        for (ITmfTrace trace : this.getIndividualTraces()) {
            b.append("Trace " + i++ + ":" + cr + "  " + this.fUnmatchedIn.row((Object)trace).size() + " unmatched incoming events" + cr + "  " + this.fUnmatchedOut.row((Object)trace).size() + " unmatched outgoing events" + cr);
        }
        return b.toString();
    }

    public void matchEvent(ITmfEvent event, ITmfTrace trace, @NonNull IProgressMonitor monitor) {
        Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> companionTbl;
        Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> unmatchedTbl;
        ITmfMatchEventDefinition def = null;
        Enum evType = null;
        IEventMatchingKey eventKey = null;
        for (ITmfMatchEventDefinition oneDef : this.getEventDefinitions(event.getTrace())) {
            def = oneDef;
            evType = def.getDirection(event);
            if (evType != null && (eventKey = def.getEventKey(event)) != null) break;
        }
        if (def == null || evType == null || eventKey == null) {
            return;
        }
        switch (TmfEventMatching.$SWITCH_TABLE$org$eclipse$tracecompass$tmf$core$event$matching$TmfEventMatching$Direction()[evType.ordinal()]) {
            case 2: {
                unmatchedTbl = this.fUnmatchedIn;
                companionTbl = this.fUnmatchedOut;
                break;
            }
            case 1: {
                unmatchedTbl = this.fUnmatchedOut;
                companionTbl = this.fUnmatchedIn;
                break;
            }
            default: {
                return;
            }
        }
        TmfEventDependency dep = null;
        TmfEventDependency.DependencyEvent depEvent = new TmfEventDependency.DependencyEvent(event);
        for (ITmfTrace mTrace : this.getIndividualTraces()) {
            if (!companionTbl.contains((Object)mTrace, (Object)eventKey)) continue;
            TmfEventDependency.DependencyEvent companionEvent = (TmfEventDependency.DependencyEvent)companionTbl.remove((Object)mTrace, (Object)eventKey);
            switch (TmfEventMatching.$SWITCH_TABLE$org$eclipse$tracecompass$tmf$core$event$matching$TmfEventMatching$Direction()[evType.ordinal()]) {
                case 2: {
                    dep = new TmfEventDependency(companionEvent, depEvent);
                    break;
                }
                case 1: {
                    if (!companionEvent.getTrace().getHostId().equals(depEvent.getTrace().getHostId())) {
                        dep = new TmfEventDependency(depEvent, companionEvent);
                        break;
                    }
                    companionTbl.put((Object)mTrace, (Object)eventKey, (Object)companionEvent);
                    break;
                }
            }
        }
        if (dep != null) {
            this.processDependency(eventKey, dep);
            monitor.subTask(NLS.bind((String)Messages.TmfEventMatching_MatchesFound, (Object)this.getProcessingUnit().countMatches()));
        } else if (!unmatchedTbl.contains((Object)event.getTrace(), (Object)eventKey)) {
            unmatchedTbl.put((Object)event.getTrace(), (Object)eventKey, (Object)depEvent);
        }
    }

    private void processDependency(@NonNull IEventMatchingKey eventKey, @NonNull TmfEventDependency dep) {
        this.getProcessingUnit().addMatch(eventKey, dep);
        String sourceHost = dep.getSource().getTrace().getHostId();
        String destHost = dep.getDestination().getTrace().getHostId();
        Table<String, String, TmfEventDependency> lastMatches = this.getLastMatchTable(eventKey);
        lastMatches.put((Object)sourceHost, (Object)destHost, (Object)dep);
        this.cleanupList(eventKey, lastMatches.row((Object)sourceHost), dep.getSource(), evDep -> evDep.getSource().getTimestamp().toNanos(), this.fUnmatchedOut);
        this.cleanupList(eventKey, lastMatches.column((Object)destHost), dep.getDestination(), evDep -> evDep.getDestination().getTimestamp().toNanos(), this.fUnmatchedIn);
    }

    private Table<String, String, TmfEventDependency> getLastMatchTable(@NonNull IEventMatchingKey eventKey) {
        return this.fLastMatches.computeIfAbsent(eventKey.getClass(), k -> HashBasedTable.create());
    }

    private void cleanupList(@NonNull IEventMatchingKey eventKey, Map<String, TmfEventDependency> lastMatches, TmfEventDependency.DependencyEvent lastDep, ToLongFunction<TmfEventDependency> mapToTime, Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> toClean) {
        long earliest;
        long otherHosts = lastMatches.keySet().stream().filter(s -> !s.equals(lastDep.getTrace().getHostId())).count();
        if (otherHosts == (long)(this.fDistinctHosts.size() - 1) && (earliest = lastMatches.values().stream().mapToLong(mapToTime).min().orElse(0L)) > 0L) {
            ArrayList<IEventMatchingKey> toRemove = new ArrayList<IEventMatchingKey>();
            for (Map.Entry entry : toClean.row((Object)lastDep.getTrace()).entrySet()) {
                if (((TmfEventDependency.DependencyEvent)entry.getValue()).getTimestamp().toNanos() >= earliest || !((IEventMatchingKey)entry.getKey()).getClass().isAssignableFrom(eventKey.getClass())) continue;
                toRemove.add((IEventMatchingKey)entry.getKey());
            }
            toRemove.forEach(m -> {
                Object object = toClean.remove((Object)lastDep.getTrace(), m);
            });
        }
    }

    @Override
    public boolean matchEvents() {
        if (this.fTraces.isEmpty()) {
            return false;
        }
        this.initMatching();
        Job job = new Job(Messages.TmfEventMatching_MatchingEvents){

            protected IStatus run(IProgressMonitor monitor) {
                for (ITmfTrace trace : TmfEventMatching.this.fTraces) {
                    monitor.beginTask(NLS.bind((String)Messages.TmfEventMatching_LookingEventsFrom, (Object)trace.getName()), -1);
                    this.setName(NLS.bind((String)Messages.TmfEventMatching_RequestingEventsFrom, (Object)trace.getName()));
                    EventMatchingBuildRequest request = new EventMatchingBuildRequest(TmfEventMatching.this, trace, monitor);
                    trace.sendRequest(request);
                    try {
                        request.waitForCompletion();
                    }
                    catch (InterruptedException e) {
                        Activator.logInfo(e.getMessage());
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finalizeMatching();
        return true;
    }

    public static void registerMatchObject(ITmfMatchEventDefinition match) {
        MATCH_DEFINITIONS.add(match);
    }

    @VisibleForTesting
    protected Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> getUnmatchedIn() {
        return this.fUnmatchedIn;
    }

    @VisibleForTesting
    protected Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> getUnmatchedOut() {
        return this.fUnmatchedOut;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$tmf$core$event$matching$TmfEventMatching$Direction() {
        if ($SWITCH_TABLE$org$eclipse$tracecompass$tmf$core$event$matching$TmfEventMatching$Direction != null) {
            return $SWITCH_TABLE$org$eclipse$tracecompass$tmf$core$event$matching$TmfEventMatching$Direction;
        }
        int[] nArray = new int[Direction.values().length];
        try {
            nArray[Direction.CAUSE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.EFFECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$tracecompass$tmf$core$event$matching$TmfEventMatching$Direction = nArray;
        return nArray;
    }

    public static enum Direction {
        CAUSE,
        EFFECT;

    }
}

