/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.hook;

import java.util.Collection;
import org.eclipse.equinox.internal.region.EquinoxStateHelper;
import org.eclipse.equinox.internal.region.hook.RegionDigraphVisitorBase;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

final class RegionResolverHook
implements ResolverHook {
    private static final Boolean DEBUG = false;
    private final RegionDigraph regionDigraph;

    RegionResolverHook(RegionDigraph regionDigraph) {
        this.regionDigraph = regionDigraph;
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        this.filterCandidates(requirement.getRevision(), candidates, false);
    }

    private void filterCandidates(BundleRevision requirer, Collection<BundleCapability> candidates, boolean singleton) {
        try {
            if (DEBUG.booleanValue()) {
                this.debugEntry(requirer, candidates, singleton);
            }
            if (this.getBundleId(requirer) == 0L) {
                return;
            }
            Region requirerRegion = this.getRegion(requirer);
            if (requirerRegion == null) {
                if (!singleton) {
                    candidates.clear();
                }
                return;
            }
            Visitor visitor = new Visitor(candidates);
            requirerRegion.visitSubgraph(visitor);
            Collection allowed = visitor.getAllowed();
            candidates.retainAll(allowed);
        }
        finally {
            if (DEBUG.booleanValue()) {
                this.debugExit(requirer, candidates);
            }
        }
    }

    Region getRegion(BundleRevision bundleRevision) {
        Bundle bundle = bundleRevision.getBundle();
        if (bundle != null) {
            return this.getRegion(bundle);
        }
        Long bundleId = this.getBundleId(bundleRevision);
        return this.getRegion(bundleId);
    }

    private Region getRegion(Long bundleId) {
        return this.regionDigraph.getRegion(bundleId);
    }

    private Long getBundleId(BundleRevision bundleRevision) {
        return EquinoxStateHelper.getBundleId(bundleRevision);
    }

    private Region getRegion(Bundle bundle) {
        return this.regionDigraph.getRegion(bundle);
    }

    public void end() {
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
        this.filterCandidates(singleton.getRevision(), collisionCandidates, true);
    }

    private void debugEntry(BundleRevision requirer, Collection<BundleCapability> candidates, boolean singleton) {
        System.out.println(String.valueOf(singleton ? "Singleton" : "Requirer: ") + requirer.getSymbolicName() + "_" + requirer.getVersion() + "[" + this.getBundleId(requirer) + "]");
        System.out.println("  Candidates: ");
        for (BundleCapability c : candidates) {
            BundleRevision providerRevision;
            String namespace = c.getNamespace();
            if ("osgi.wiring.package".equals(namespace)) {
                providerRevision = c.getRevision();
                String pkg = (String)c.getAttributes().get("osgi.wiring.package");
                System.out.println("    Package " + pkg + " from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
                if (!pkg.equals("slow")) continue;
                System.out.println(">>> put breakpoint here <<<");
                continue;
            }
            providerRevision = c.getRevision();
            System.out.println("    Bundle from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
        }
    }

    private void debugExit(BundleRevision requirer, Collection<BundleCapability> candidates) {
        System.out.println("  Filtered candidates: ");
        for (BundleCapability c : candidates) {
            BundleRevision providerRevision;
            String namespace = c.getNamespace();
            if ("osgi.wiring.package".equals(namespace)) {
                providerRevision = c.getRevision();
                String pkg = (String)c.getAttributes().get("osgi.wiring.package");
                System.out.println("    Package " + pkg + " from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
                if (!pkg.equals("slow")) continue;
                System.out.println(">>> put breakpoint here <<<");
                continue;
            }
            providerRevision = c.getRevision();
            System.out.println("    Bundle from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
        }
    }

    class Visitor
    extends RegionDigraphVisitorBase<BundleCapability> {
        Visitor(Collection<BundleCapability> candidates) {
            super(candidates);
        }

        @Override
        protected boolean contains(Region region, BundleCapability candidate) {
            return region.equals(RegionResolverHook.this.getRegion(candidate.getRevision()));
        }

        @Override
        protected boolean isAllowed(BundleCapability candidate, RegionFilter filter) {
            return filter.isAllowed(candidate) || filter.isAllowed(candidate.getRevision());
        }
    }
}

