/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform.base;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.synch.SynchronizeClassesJob;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.PackageGenerator;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.wizards.GenerateEntitiesWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class EntitiesGenerator {
    private JpaProject project;
    private IStructuredSelection selection;

    public static void generate(JpaProject project, IStructuredSelection selection) {
        if (project == null) {
            throw new NullPointerException();
        }
        new EntitiesGenerator(project, selection).generate();
    }

    public EntitiesGenerator() {
    }

    private EntitiesGenerator(JpaProject project, IStructuredSelection selection) {
        this.project = project;
        this.selection = selection;
    }

    protected void generate() {
        GenerateEntitiesWizard wizard = new GenerateEntitiesWizard(this.project, this.selection);
        WizardDialog dialog = new WizardDialog(this.getCurrentShell(), (IWizard)wizard);
        dialog.create();
        int returnCode = dialog.open();
        if (returnCode == 0) {
            PersistenceXml persistenceXml;
            GenerateEntitiesRunnable genEntitiesRunnable = new GenerateEntitiesRunnable(wizard.getPackageGeneratorConfig(), wizard.getEntityGeneratorConfig(), wizard.getSelectedTables(), wizard.synchronizePersistenceXml(), new OverwriteConfirmer(this.getCurrentShell()));
            SynchronizeClassesJob synchClassesRunnable = null;
            if (wizard.synchronizePersistenceXml() && (persistenceXml = this.project.getRootContext().getPersistenceXml()) != null) {
                synchClassesRunnable = new SynchronizeClassesJob((IFile)persistenceXml.getResource());
            }
            genEntitiesRunnable.schedule();
            if (synchClassesRunnable != null) {
                synchClassesRunnable.schedule();
            }
        }
    }

    private Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GenerateEntitiesRunnable
    extends WorkspaceJob {
        private final PackageGenerator.Config packageConfig;
        private final EntityGenerator.Config entityConfig;
        private final Collection<Table> selectedTables;
        private final EntityGenerator.OverwriteConfirmer overwriteConfirmer;

        GenerateEntitiesRunnable(PackageGenerator.Config packageConfig, EntityGenerator.Config entityConfig, Collection<Table> selectedTables, boolean synchronizePersistenceXml, EntityGenerator.OverwriteConfirmer overwriteConfirmer) {
            super("Generating Entities");
            this.packageConfig = packageConfig;
            this.entityConfig = entityConfig;
            this.selectedTables = selectedTables;
            this.overwriteConfirmer = overwriteConfirmer;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.setRule(ruleFactory.modifyRule((IResource)packageConfig.getPackageFragment().getJavaProject().getProject()));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            PackageGenerator.generateEntities((PackageGenerator.Config)this.packageConfig, (EntityGenerator.Config)this.entityConfig, this.selectedTables, (EntityGenerator.OverwriteConfirmer)this.overwriteConfirmer, (IProgressMonitor)monitor);
            return Status.OK_STATUS;
        }
    }

    static class OverwriteConfirmer
    implements EntityGenerator.OverwriteConfirmer {
        private Shell shell;
        private boolean overwriteAll = false;
        private boolean skipAll = false;

        OverwriteConfirmer(Shell shell) {
            this.shell = shell;
        }

        public boolean overwrite(String className) {
            if (this.overwriteAll) {
                return true;
            }
            if (this.skipAll) {
                return false;
            }
            return this.promptUser(className);
        }

        private boolean promptUser(String className) {
            final OverwriteConfirmerDialog dialog = new OverwriteConfirmerDialog(this.shell, className);
            this.shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
            if (dialog.getReturnCode() == 1) {
                throw new OperationCanceledException();
            }
            if (dialog.yes()) {
                return true;
            }
            if (dialog.yesToAll()) {
                this.overwriteAll = true;
                return true;
            }
            if (dialog.no()) {
                return false;
            }
            if (dialog.noToAll()) {
                this.skipAll = true;
                return false;
            }
            throw new IllegalStateException();
        }
    }

    static class OverwriteConfirmerDialog
    extends Dialog {
        private final String className;
        private boolean yes = false;
        private boolean yesToAll = false;
        private boolean no = false;
        private boolean noToAll = false;

        OverwriteConfirmerDialog(Shell parent, String className) {
            super(parent);
            this.className = className;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(JptUiMessages.OverwriteConfirmerDialog_title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout gridLayout = (GridLayout)composite.getLayout();
            gridLayout.numColumns = 2;
            Label text = new Label(composite, 16384);
            text.setText(NLS.bind((String)JptUiMessages.OverwriteConfirmerDialog_text, (Object)this.className));
            text.setLayoutData((Object)new GridData());
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
            this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 2: {
                    this.yesPressed();
                    break;
                }
                case 4: {
                    this.yesToAllPressed();
                    break;
                }
                case 3: {
                    this.noPressed();
                    break;
                }
                case 21: {
                    this.noToAllPressed();
                    break;
                }
                case 1: {
                    this.cancelPressed();
                    break;
                }
            }
        }

        private void yesPressed() {
            this.yes = true;
            this.setReturnCode(0);
            this.close();
        }

        private void yesToAllPressed() {
            this.yesToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noPressed() {
            this.no = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noToAllPressed() {
            this.noToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        boolean yes() {
            return this.yes;
        }

        boolean yesToAll() {
            return this.yesToAll;
        }

        boolean no() {
            return this.no;
        }

        boolean noToAll() {
            return this.noToAll;
        }
    }
}

