/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IDocumentSelectionMediator;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

class StructuredTextViewerUndoManager
implements IUndoManager {
    private StructuredTextViewer fTextViewer = null;
    private IStructuredTextUndoManager fUndoManager = null;
    private ISelectionChangedListener fUndoNotifier = new UndoNotifier();

    StructuredTextViewerUndoManager() {
    }

    public void beginCompoundChange() {
        if (this.fUndoManager != null) {
            this.fUndoManager.beginRecording((Object)this.fTextViewer);
        }
    }

    public void connect(ITextViewer viewer) {
        this.disconnect();
        this.fTextViewer = (StructuredTextViewer)viewer;
        IDocument doc = this.fTextViewer.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            this.setDocument(structuredDocument);
        }
    }

    public void disconnect() {
        if (this.fUndoManager != null) {
            this.fTextViewer.removeSelectionChangedListener(this.fUndoNotifier);
            this.fUndoManager.disconnect((IDocumentSelectionMediator)this.fTextViewer);
        }
        this.fTextViewer = null;
        this.fUndoManager = null;
    }

    public void endCompoundChange() {
        if (this.fUndoManager != null) {
            this.fUndoManager.endRecording((Object)this.fTextViewer);
        }
    }

    public void redo() {
        if (this.fUndoManager != null) {
            this.fUndoManager.redo((IDocumentSelectionMediator)this.fTextViewer);
        }
    }

    public boolean redoable() {
        boolean canRedo = false;
        if (this.fUndoManager != null) {
            canRedo = this.fUndoManager.redoable();
        }
        return canRedo;
    }

    public void reset() {
    }

    public void setDocument(IStructuredDocument document) {
        if (this.fUndoManager != null) {
            this.fTextViewer.removeSelectionChangedListener(this.fUndoNotifier);
            this.fUndoManager.disconnect((IDocumentSelectionMediator)this.fTextViewer);
        }
        this.fUndoManager = document.getUndoManager();
        if (this.fUndoManager != null) {
            this.fUndoManager.connect((IDocumentSelectionMediator)this.fTextViewer);
            this.fTextViewer.addSelectionChangedListener(this.fUndoNotifier);
        }
    }

    public void setMaximalUndoLevel(int undoLevel) {
    }

    public void undo() {
        if (this.fUndoManager != null) {
            this.fUndoManager.undo((IDocumentSelectionMediator)this.fTextViewer);
        }
    }

    public boolean undoable() {
        boolean canUndo = false;
        if (this.fUndoManager != null) {
            canUndo = this.fUndoManager.undoable();
        }
        return canUndo;
    }

    class UndoNotifier
    implements ISelectionChangedListener {
        UndoNotifier() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (StructuredTextViewerUndoManager.this.fUndoManager != null && event != null && event.getSelection() instanceof ITextSelection) {
                StructuredTextViewerUndoManager.this.fUndoManager.forceEndOfPendingCommand((Object)this, ((ITextSelection)event.getSelection()).getOffset(), ((ITextSelection)event.getSelection()).getLength());
            }
        }
    }
}

