/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.navigator.internal.J2EELabelProvider;
import org.eclipse.jst.j2ee.navigator.internal.plugin.J2EENavigatorPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.GroupEARProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class Ear5LabelProvider
extends J2EELabelProvider {
    private static ImageDescriptor IMG_MODULES_NODE;
    private static ImageDescriptor IMG_MODULE_UTIL;
    private static ImageDescriptor IMG_MODULE_WEB;
    private static ImageDescriptor IMG_MODULE_EJB;
    private static ImageDescriptor IMG_MODULE_CLIENT;
    private static ImageDescriptor IMG_MODULE_CONNECTOR;

    static {
        try {
            IMG_MODULES_NODE = J2EENavigatorPlugin.getDefault().getImageDescriptor("folder.gif");
            IMG_MODULE_UTIL = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("utiljar_obj")));
            IMG_MODULE_WEB = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("full/obj16/module_web_obj")));
            IMG_MODULE_EJB = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("full/obj16/module_ejb_obj")));
            IMG_MODULE_CLIENT = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("module_clientapp_obj")));
            IMG_MODULE_CONNECTOR = ImageDescriptor.createFromURL((URL)((URL)J2EEPlugin.getPlugin().getImage("full/obj16/connector_module")));
        }
        catch (RuntimeException e) {
            String msg = e.getMessage() != null ? e.getMessage() : e.toString();
            JEEUIPlugin.getDefault();
            JEEUIPlugin.logError(msg, e);
            IMG_MODULES_NODE = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_UTIL = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_WEB = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_EJB = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_CLIENT = ImageDescriptor.getMissingImageDescriptor();
            IMG_MODULE_CONNECTOR = ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public Image getImage(Object element) {
        Image ret = null;
        if (element instanceof AbstractEarNode) {
            ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULES_NODE);
        } else if (element instanceof IVirtualReference) {
            IVirtualComponent component = ((IVirtualReference)element).getReferencedComponent();
            if (component.isBinary()) {
                ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULE_UTIL);
            } else if (JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
                ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULE_WEB);
            } else if (JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)component)) {
                ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULE_EJB);
            } else if (JavaEEProjectUtilities.isApplicationClientComponent((IVirtualComponent)component)) {
                ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULE_CLIENT);
            } else if (JavaEEProjectUtilities.isJCAComponent((IVirtualComponent)component)) {
                ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULE_CONNECTOR);
            } else if (JavaEEProjectUtilities.isUtilityProject((IProject)component.getProject())) {
                ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULE_UTIL);
            } else if (component instanceof VirtualArchiveComponent) {
                ret = J2EENavigatorPlugin.getDefault().getImage(IMG_MODULE_UTIL);
            }
        } else if (element instanceof GroupEARProvider) {
            ret = ((GroupEARProvider)element).getImage();
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getText(Object element) {
        String ret = null;
        if (element instanceof AbstractEarNode) {
            return ((AbstractEarNode)element).getText();
        }
        if (element instanceof IVirtualReference) {
            IVirtualComponent component = ((IVirtualReference)element).getReferencedComponent();
            if (JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
                if (!component.isBinary()) {
                    return "Web " + component.getName() + ".war";
                }
                Path path = new Path(component.getDeployedName());
                return path.lastSegment();
            }
            if (JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)component)) {
                if (!component.isBinary()) {
                    return "EJB " + component.getName() + ".jar";
                }
                Path path = new Path(component.getDeployedName());
                return path.lastSegment();
            }
            if (JavaEEProjectUtilities.isApplicationClientComponent((IVirtualComponent)component)) {
                if (!component.isBinary()) {
                    return "APP Client " + component.getName() + ".jar";
                }
                Path path = new Path(component.getDeployedName());
                return path.lastSegment();
            }
            if (JavaEEProjectUtilities.isJCAProject((IProject)component.getProject())) {
                return "Connector " + component.getName() + ".jar";
            }
            if (JavaEEProjectUtilities.isUtilityProject((IProject)component.getProject())) {
                return String.valueOf(component.getName()) + ".jar";
            }
            if (!component.isBinary()) return ret;
            VirtualArchiveComponent virtualArchiveComponent = (VirtualArchiveComponent)component;
            String deployedName = virtualArchiveComponent.getDeployedName();
            Path path = new Path(deployedName);
            return path.lastSegment();
        }
        if (!(element instanceof GroupEARProvider)) return ret;
        return ((GroupEARProvider)element).getText();
    }
}

