/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingManager;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingPresenter;

public class SemanticHighlightingReconciler
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument fDocument;
    private StructuredTextEditor fEditor;
    private SemanticHighlightingPresenter fPresenter;
    private List fAddedPositions = new ArrayList();
    private List fRemovedPositions = new ArrayList();
    private int fNOfRemovedPositions;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private SemanticHighlightingPresenter fJobPresenter;

    public void install(StructuredTextEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter presenter) {
        this.fEditor = editor;
        this.fPresenter = presenter;
    }

    public void uninstall() {
        this.fEditor = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconcile(IRegion partition) {
        var2_2 = this.fReconcileLock;
        synchronized (var2_2) {
            if (this.fIsReconciling) {
                return;
            }
            this.fIsReconciling = true;
        }
        this.fJobPresenter = this.fPresenter;
        try {
            if (this.fJobPresenter == null) {
                var9_3 = null;
                this.fJobPresenter = null;
                var11_6 = this.fReconcileLock;
                synchronized (var11_6) {
                    this.fIsReconciling = false;
                    return;
                }
            }
            this.fJobPresenter.setCanceled(false);
            this.startReconcilingPositions();
            document = (IStructuredDocument)this.fDocument;
            regions = document.getStructuredDocumentRegions(partition.getOffset(), partition.getLength());
            i = 0;
            if (true) ** GOTO lbl33
            {
                catch (Throwable v1) {
                    throw v1;
                }
            }
            do {
                if (document.containsReadOnly(regions[i].getStartOffset(), regions[i].getLength())) {
                    this.addPosition(new Position(regions[i].getStartOffset(), regions[i].getLength()), null, true);
                }
                ++i;
lbl33:
                // 2 sources

            } while (i < regions.length);
            oldPositions = this.fRemovedPositions;
            newPositions = new ArrayList<E>(this.fNOfRemovedPositions);
            i = 0;
            n = oldPositions.size();
            while (i < n) {
                current = oldPositions.get(i);
                if (current != null) {
                    newPositions.add(current);
                }
                ++i;
            }
            this.fRemovedPositions = newPositions;
            presentation = null;
            if (!this.fJobPresenter.isCanceled()) {
                presentation = this.fJobPresenter.createPresentation(this.fAddedPositions, this.fRemovedPositions);
            }
            if (!this.fJobPresenter.isCanceled()) {
                this.updatePresentation(presentation, this.fAddedPositions, this.fRemovedPositions);
            }
            this.stopReconcilingPositions();
            var9_5 = null;
            this.fJobPresenter = null;
            var11_8 = this.fReconcileLock;
            ** GOTO lbl66
        }
        catch (Throwable var10_17) {
            var9_4 = null;
            this.fJobPresenter = null;
            var11_7 = this.fReconcileLock;
            synchronized (var11_7) {
                ** try [egrp 2[TRYBLOCK] [6 : 322->333)] { 
lbl64:
                // 1 sources

                this.fIsReconciling = false;
                throw var10_17;
            }
lbl66:
            // 1 sources

            synchronized (var11_8) {
                ** try [egrp 2[TRYBLOCK] [6 : 322->333)] { 
lbl68:
                // 1 sources

                this.fIsReconciling = false;
                return;
            }
lbl-1000:
            // 1 sources

            {
                catch (Throwable v2) {
                    throw v2;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            catch (Throwable v3) {
                throw v3;
            }
        }
    }

    private void addPosition(Position position, SemanticHighlightingManager.HighlightingStyle highlighting, boolean isReadOnly) {
        boolean isExisting = false;
        int i = 0;
        int n = this.fRemovedPositions.size();
        while (i < n) {
            SemanticHighlightingManager.HighlightedPosition highlightedPosition = (SemanticHighlightingManager.HighlightedPosition)((Object)this.fRemovedPositions.get(i));
            if (highlightedPosition != null && highlightedPosition.isEqual(position, highlighting)) {
                isExisting = true;
                this.fRemovedPositions.set(i, null);
                --this.fNOfRemovedPositions;
                break;
            }
            ++i;
        }
        if (!isExisting) {
            this.fAddedPositions.add(this.fPresenter.createHighlightedPosition(position, highlighting, isReadOnly));
        }
    }

    private void updatePresentation(TextPresentation textPresentation, List addedPositions, List removedPositions) {
        Runnable runnable = this.fPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        StructuredTextEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void startReconcilingPositions() {
        this.fPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile((IRegion)dirtyRegion);
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.refresh();
    }

    public void initialReconcile() {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            this.fJob = new Job("Semantic Highlighting Job"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    if (oldJob != null) {
                        try {
                            oldJob.join();
                        }
                        catch (InterruptedException e) {
                            Logger.logException(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    SemanticHighlightingReconciler.this.reconcile((IRegion)new Region(0, SemanticHighlightingReconciler.this.fDocument.getLength()));
                    Object object = SemanticHighlightingReconciler.this.fJobLock;
                    synchronized (object) {
                        if (SemanticHighlightingReconciler.this.fJob == this) {
                            SemanticHighlightingReconciler.this.fJob = null;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fJob.setSystem(true);
            this.fJob.setPriority(50);
            this.fJob.schedule();
        }
    }

    public void refresh() {
        if (this.fDocument != null) {
            this.scheduleJob();
        }
    }
}

