/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

class FileTransferDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    FileTransferDropAdapter(AbstractTreeViewer viewer) {
        super((StructuredViewer)viewer, 24);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IJavaScriptElement || target instanceof IResource;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        boolean isPackageFragment = target instanceof IPackageFragment;
        boolean isJavaProject = target instanceof IJavaScriptProject;
        boolean isPackageFragmentRoot = target instanceof IPackageFragmentRoot;
        boolean isContainer = target instanceof IContainer;
        if (!(isPackageFragment || isJavaProject || isPackageFragmentRoot || isContainer)) {
            return;
        }
        if (isContainer) {
            IContainer container = (IContainer)target;
            if (container.isAccessible() && !Resources.isReadOnly((IResource)container)) {
                event.detail = 1;
            }
        } else {
            IJavaScriptElement element = (IJavaScriptElement)target;
            if (!element.isReadOnly()) {
                event.detail = 1;
            }
        }
    }

    public void drop(Object dropTarget, final DropTargetEvent event) {
        try {
            int operation = event.detail;
            event.detail = 0;
            final Object data = event.data;
            if (data == null || !(data instanceof String[]) || operation != 1) {
                return;
            }
            final IContainer target = this.getActualTarget(dropTarget);
            if (target == null) {
                return;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    FileTransferDropAdapter.this.getShell().forceActive();
                    new CopyFilesAndFoldersOperation(FileTransferDropAdapter.this.getShell()).copyFiles((String[])data, target);
                    event.detail = 1;
                }
            });
        }
        catch (JavaScriptModelException e) {
            String title = PackagesMessages.DropAdapter_errorTitle;
            String message = PackagesMessages.DropAdapter_errorMessage;
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
        }
    }

    private IContainer getActualTarget(Object dropTarget) throws JavaScriptModelException {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof IJavaScriptElement) {
            return this.getActualTarget(((IJavaScriptElement)dropTarget).getCorrespondingResource());
        }
        return null;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

