/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StateController {
    private PropertyChangeListener booleanChangeListener;
    private PropertyValueModel<Boolean> booleanHolder;
    private Collection<IControlHolder> controlHolders;
    private boolean defaultValue;

    StateController() {
        this.initialize();
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, Collection<IControlHolder> controlHolders) {
        this(booleanHolder, controlHolders, false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, Collection<IControlHolder> controlHolders, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, controlHolders, defaultValue);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, IControlHolder controlHolder) {
        this(booleanHolder, controlHolder, false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, IControlHolder ... controlHolders) {
        this(booleanHolder, CollectionTools.collection((Object[])controlHolders), false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, IControlHolder controlHolder, boolean defaultValue) {
        this(booleanHolder, new IControlHolder[]{controlHolder}, false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, IControlHolder[] controlHolders, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, CollectionTools.collection((Object[])controlHolders), defaultValue);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, Iterator<IControlHolder> controlHolders) {
        this(booleanHolder, CollectionTools.collection(controlHolders), false);
    }

    StateController(PropertyValueModel<Boolean> booleanHolder, Iterator<IControlHolder> controlHolders, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, CollectionTools.collection(controlHolders), defaultValue);
    }

    protected boolean booleanValue(Boolean value) {
        return value == null ? this.defaultValue : value;
    }

    private PropertyChangeListener buildBooleanChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildBooleanChangeListener_()){

            public String toString() {
                return "StateController.SWTPropertyChangeListenerWrapper";
            }
        };
    }

    private PropertyChangeListener buildBooleanChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                StateController.this.updateState(StateController.this.booleanValue((Boolean)StateController.this.booleanHolder.getValue()));
            }

            public String toString() {
                return "StateController.PropertyChangeListener";
            }
        };
    }

    protected final Iterator<IControlHolder> controlHolders() {
        return new CloneIterator(this.controlHolders);
    }

    protected void initialize() {
        this.booleanChangeListener = this.buildBooleanChangeListener();
    }

    protected void initialize(PropertyValueModel<Boolean> booleanHolder, Collection<IControlHolder> controlHolders, boolean defaultValue) {
        Assert.isNotNull(booleanHolder, (String)"The holder of the boolean value cannot be null");
        Assert.isNotNull(controlHolders, (String)"The collection of ControlHolders cannot be null");
        this.controlHolders = new ArrayList<IControlHolder>(controlHolders);
        this.defaultValue = defaultValue;
        this.booleanHolder = booleanHolder;
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.updateState();
    }

    protected void updateState() {
        this.updateState(this.booleanValue((Boolean)this.booleanHolder.getValue()));
    }

    protected void updateState(boolean state) {
        for (IControlHolder controlHolder : this.controlHolders) {
            controlHolder.updateState(state);
        }
    }

    static interface IControlHolder {
        public void updateState(boolean var1);
    }
}

