/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.entity;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassWizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class EntityClassWizardPage
extends NewJavaClassWizardPage {
    private static final String JPA_FACET = "jpt.jpa";
    private static final String XML_EXTENSION = ".xml";
    private static final String PERSISTENCE_XML = "persistence.xml";
    private static final String META_INF = "META-INF";
    private static final String EMPTY = "";
    private static final char SLASH = '/';
    private static final String SINGLE_TABLE = "SINGLE_TABLE";
    private static final String TABLE_PER_CLASS = "TABLE_PER_CLASS";
    private static final String JOINED = "JOINED";
    private static final String[] INHERITANCE_STRATEGIES = new String[]{"", "SINGLE_TABLE", "TABLE_PER_CLASS", "JOINED"};
    private Combo inheritanceStrategyCombo;
    private Button entityButton;
    private Button mapedAsSuperclassButton;
    private Button inheritanceButton;
    private Label displayNameLabel;
    private Button xmlSupportButton;
    private boolean isFirstCheck = true;
    private Text ormXmlName;
    private Button browseButton;

    public EntityClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super(model, pageName, pageDesc, pageTitle, moduleType);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        this.createInheritanceControl(composite);
        this.inheritanceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = EntityClassWizardPage.this.inheritanceButton.getSelection();
                if (isChecked) {
                    EntityClassWizardPage.this.entityButton.setSelection(true);
                    EntityClassWizardPage.this.mapedAsSuperclassButton.setSelection(false);
                }
                EntityClassWizardPage.this.inheritanceStrategyCombo.setEnabled(isChecked);
                ((DataModelWizardPage)EntityClassWizardPage.this).model.setBooleanProperty("IEntityDataModelProperties.ENTITY", true);
                ((DataModelWizardPage)EntityClassWizardPage.this).model.setBooleanProperty("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS", false);
                EntityClassWizardPage.this.entityButton.setEnabled(!isChecked);
                EntityClassWizardPage.this.mapedAsSuperclassButton.setEnabled(!isChecked);
            }
        });
        this.createXMLstorageControl(composite);
        this.xmlSupportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = EntityClassWizardPage.this.xmlSupportButton.getSelection();
                EntityClassWizardPage.this.ormXmlName.setEnabled(isChecked);
                EntityClassWizardPage.this.browseButton.setEnabled(isChecked);
                if (EntityClassWizardPage.this.isFirstCheck) {
                    EntityClassWizardPage.this.ormXmlName.setText("META-INF/orm.xml");
                    EntityClassWizardPage.this.isFirstCheck = false;
                }
                EntityClassWizardPage.this.disableMappingXMLChooseGroup();
            }
        });
        return composite;
    }

    private void createInheritanceControl(Composite parent) {
        Group group = this.createGroup(parent, EntityWizardMsg.INHERITANCE_GROUP);
        this.entityButton = this.createRadioButton((Composite)group, EntityWizardMsg.ENTITY, "IEntityDataModelProperties.ENTITY");
        this.mapedAsSuperclassButton = this.createRadioButton((Composite)group, EntityWizardMsg.MAPPED_AS_SUPERCLASS, "IEntityDataModelProperties.MAPPED_AS_SUPERCLASS");
        this.inheritanceButton = this.createCheckButton((Composite)group, 256, 1, EntityWizardMsg.INHERITANCE_CHECK_BOX, "IEntityDataModelProperties.INHERITANCE");
        this.createComboBox((Composite)group, "IEntityDataModelProperties.INHERITANCE_STRATEGY");
    }

    private void createXMLstorageControl(Composite parent) {
        Group group = this.createGroup(parent, EntityWizardMsg.XML_STORAGE_GROUP);
        this.xmlSupportButton = this.createCheckButton((Composite)group, 768, 3, EntityWizardMsg.XML_SUPPORT, "IEntityDataModelProperties.XML_SUPPORT");
        this.createBrowseGroup((Composite)group, EntityWizardMsg.CHOOSE_XML, "IEntityDataModelProperties.XML_NAME");
        this.ormXmlName.setEnabled(false);
        this.browseButton.setEnabled(false);
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(text);
        return group;
    }

    private Button createRadioButton(Composite parent, String text, String property) {
        Button button = new Button(parent, 16);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        button.setLayoutData((Object)groupGridData);
        button.setText(text);
        this.synchHelper.synchRadio(button, property, null);
        return button;
    }

    private Button createCheckButton(Composite parent, int fillStrategy, int horizontalSpan, String text, String property) {
        Button button = new Button(parent, 32);
        GridData groupGridData = new GridData(fillStrategy);
        groupGridData.horizontalSpan = horizontalSpan;
        button.setLayoutData((Object)groupGridData);
        button.setText(text);
        this.synchHelper.synchCheckbox(button, property, null);
        return button;
    }

    private Combo createComboBox(Composite parent, String property) {
        this.inheritanceStrategyCombo = new Combo(parent, 2056);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 2;
        this.inheritanceStrategyCombo.setLayoutData((Object)groupGridData);
        this.inheritanceStrategyCombo.setItems(INHERITANCE_STRATEGIES);
        this.synchHelper.synchCombo(this.inheritanceStrategyCombo, property, null);
        this.inheritanceStrategyCombo.setEnabled(false);
        return this.inheritanceStrategyCombo;
    }

    private void createBrowseGroup(Composite parent, String label, String property) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        this.displayNameLabel = new Label(composite, 16384);
        this.displayNameLabel.setText(label);
        this.displayNameLabel.setLayoutData((Object)new GridData(32));
        this.ormXmlName = new Text(composite, 2052);
        this.ormXmlName.setLayoutData((Object)new GridData(768));
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(EntityWizardMsg.BROWSE_BUTTON_LABEL);
        GridData browseButtonData = new GridData(256);
        browseButtonData.horizontalSpan = 1;
        this.browseButton.setLayoutData((Object)browseButtonData);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntityClassWizardPage.this.handleChooseXmlButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.synchHelper.synchText(this.ormXmlName, property, null);
        this.ormXmlName.setEnabled(false);
        this.disableMappingXMLChooseGroup();
    }

    private void handleChooseXmlButtonPressed() {
        IProject project = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
        if (project == null) {
            return;
        }
        ISelectionStatusValidator validator = this.getDialogSelectionValidator();
        ViewerFilter filter = this.getDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        SelectMappingXMLDialog dialog = new SelectMappingXMLDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(EntityWizardMsg.MAPPING_XML_TITLE);
        dialog.setMessage(EntityWizardMsg.CHOOSE_MAPPING_XML_MESSAGE);
        dialog.addFilter(filter);
        IFile rootFolder = project.getFile(String.valueOf(J2EEProjectUtilities.getSourceContainers((IProject)project)[0].getResource().getName()) + '/' + this.ormXmlName.getText().trim());
        dialog.setInput(J2EEProjectUtilities.getManifestFile((IProject)project).getParent().getParent());
        if (project != null) {
            dialog.setInitialSelection(rootFolder);
        }
        if (dialog.open() == 0) {
            this.ormXmlName.setText(dialog.getChosenName());
            this.model.validateProperty("IEntityDataModelProperties.XML_NAME");
        }
    }

    protected ISelectionStatusValidator getDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] != null && !(selection[0] instanceof IProject)) {
                    return WTPCommonPlugin.OK_STATUS;
                }
                return WTPCommonPlugin.createErrorStatus((String)EntityWizardMsg.INCORRECT_XML_NAME);
            }
        };
    }

    protected ViewerFilter getDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                IFile file;
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    IProject project = (IProject)EntityClassWizardPage.this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
                    return folder.contains((ISchedulingRule)J2EEProjectUtilities.getManifestFile((IProject)project));
                }
                return element instanceof IFile && (file = (IFile)element).getName().endsWith(EntityClassWizardPage.XML_EXTENSION) && !file.getName().equals(EntityClassWizardPage.PERSISTENCE_XML);
            }
        };
    }

    private void disableMappingXMLChooseGroup() {
        this.displayNameLabel.setEnabled(false);
        this.ormXmlName.setEnabled(false);
        this.browseButton.setEnabled(false);
    }

    protected boolean isProjectValid(IProject project) {
        IProjectFacet jpaFacet = ProjectFacetsManager.getProjectFacet((String)JPA_FACET);
        IFacetedProject fProject = null;
        try {
            fProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        return project.isAccessible() && fProject != null && fProject.hasProjectFacet(jpaFacet);
    }

    private class SelectMappingXMLDialog
    extends ElementTreeSelectionDialog {
        private Text newXmlName;
        private String xmlName;
        private IStatus currentStatus;

        public SelectMappingXMLDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
            this.xmlName = EntityClassWizardPage.EMPTY;
            this.currentStatus = new Status(0, "org.eclipse.ui", 0, EntityClassWizardPage.EMPTY, null);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label fileNameLabel = new Label(composite, 16384);
            fileNameLabel.setText(EntityWizardMsg.XML_NAME_TITLE);
            fileNameLabel.setLayoutData((Object)new GridData(32));
            this.newXmlName = new Text(composite, 2052);
            this.newXmlName.setLayoutData((Object)new GridData(768));
            this.newXmlName.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    super.keyReleased(e);
                    SelectMappingXMLDialog.this.xmlName = SelectMappingXMLDialog.this.newXmlName.getText();
                    TreeSelection selection = (TreeSelection)SelectMappingXMLDialog.this.getTreeViewer().getSelection();
                    IResource selectedResource = (IResource)selection.getFirstElement();
                    if (selectedResource instanceof IFile) {
                        SelectMappingXMLDialog.this.getTreeViewer().setSelection((ISelection)new TreeSelection(new TreePath(SelectMappingXMLDialog.this.getSegments((IResource)selectedResource.getParent()))));
                    }
                    SelectMappingXMLDialog.this.updateOKStatus();
                }
            });
            return composite;
        }

        public String getChosenName() {
            String result = EntityClassWizardPage.EMPTY;
            Object element = this.getFirstResult();
            if (element instanceof IContainer) {
                IContainer container = (IContainer)element;
                result = String.valueOf(container.getFullPath().toString()) + File.separatorChar + this.xmlName;
            } else {
                IFile f = (IFile)element;
                result = f.getFullPath().toOSString();
            }
            result = this.removeRedundantSegmentFromName(result);
            return result;
        }

        protected void updateOKStatus() {
            super.updateOKStatus();
            TreeSelection selection = (TreeSelection)this.getTreeViewer().getSelection();
            IResource selectedResource = (IResource)selection.getFirstElement();
            if (selectedResource instanceof IFile) {
                IFile file = (IFile)selectedResource;
                this.xmlName = file.getName();
                this.newXmlName.setText(this.xmlName);
                this.currentStatus = new Status(0, "org.eclipse.ui", 0, EntityClassWizardPage.EMPTY, null);
            }
            this.currentStatus = !this.xmlName.endsWith(EntityClassWizardPage.XML_EXTENSION) ? new Status(4, "org.eclipse.ui", 4, EntityWizardMsg.INCORRECT_XML_NAME, null) : new Status(0, "org.eclipse.ui", 0, EntityClassWizardPage.EMPTY, null);
            this.updateStatus(this.currentStatus);
        }

        private String removeRedundantSegmentFromName(String input) {
            String output = input.substring(input.indexOf(EntityClassWizardPage.META_INF));
            output = output.replace(File.separatorChar, '/');
            return output;
        }

        private Object[] getSegments(IResource resource) {
            Object[] segments = new Object[resource.getFullPath().segments().length];
            int i = segments.length - 1;
            while (i > -1) {
                segments[i] = resource;
                resource = resource.getParent();
                --i;
            }
            return segments;
        }
    }
}

