/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class WSDDArtifactEditFVTest
extends TestCase {
    private IProject webProject;
    private String webModuleName;
    private String serverContextData = "WebContentTest";

    public WSDDArtifactEditFVTest() {
        if (TestWorkspace.init()) {
            this.webProject = TestWorkspace.getTargetProject("WebArtifactEditTest");
            this.webModuleName = "WebArtifactEditModule";
        } else {
            WSDDArtifactEditFVTest.fail();
        }
    }

    public void testCreationDisposeFunction() {
        WSDDArtifactEdit edit = null;
        try {
            edit = WSDDArtifactEdit.getWSDDArtifactEditForWrite((IProject)this.webProject);
            edit.addListener(new EditModelListener(){

                public void editModelChanged(EditModelEvent anEvent) {
                    WSDDArtifactEditFVTest.this.pass();
                }
            });
            WebServices client = edit.getWebServices();
            this.updateClient(client);
            edit.save((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private void updateClient(WebServices client) {
        client.setDescription("FVT Description Test");
        client.setDisplayName("FVT DisplayName Test");
        client.setLargeIcon("fvtLargeIcon.gif");
    }

    private void pass() {
        WSDDArtifactEditFVTest.assertTrue((boolean)true);
    }

    public void testPersistenceFunction() {
        WSDDArtifactEdit edit = null;
        try {
            edit = WSDDArtifactEdit.getWSDDArtifactEditForWrite((IProject)this.webProject);
            WebServices web = edit.getWebServices();
            WSDDArtifactEditFVTest.pass(web);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private static void pass(WebServices webservice) {
        boolean pass = webservice.getDescription().equals("FVT Description Test") && webservice.getDisplayName().equals("FVT DisplayName Test") && webservice.getLargeIcon().equals("fvtLargeIcon.gif");
        WSDDArtifactEditFVTest.assertTrue((boolean)pass);
    }

    private void validateResource() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.webProject);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

