/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebapplicationFactoryImpl;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class WebArtifactEditTest
extends TestCase {
    private IProject webProject;
    private String webModuleName;
    private String serverContextData = "WebContentTest";

    public WebArtifactEditTest() {
        if (TestWorkspace.init()) {
            this.webProject = TestWorkspace.getTargetProject("WebArtifactEditTest");
            this.webModuleName = "WebArtifactEditModule";
        } else {
            WebArtifactEditTest.fail();
        }
    }

    public void testGetJ2EEVersion() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
            edit.getWebApp().setDescription("test");
            int version = edit.getJ2EEVersion();
            Integer integer = new Integer(version);
            WebArtifactEditTest.assertTrue((boolean)integer.equals("2.4"));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetDeploymentDescriptorResource() {
        WebArtifactEdit edit = null;
        try {
            try {
                edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
                edit.getDeploymentDescriptorResource().getURI().toString();
            }
            catch (Exception exception) {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetDeploymentDescriptorRoot() {
        block8: {
            WebArtifactEdit edit = null;
            try {
                try {
                    edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
                    edit.getDeploymentDescriptorRoot();
                    EObject object = edit.getDeploymentDescriptorRoot();
                    WebArtifactEditTest.assertNotNull((Object)object);
                }
                catch (Exception exception) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
            WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
    }

    public void testCreateModelRoot() {
        block8: {
            WebArtifactEdit edit = null;
            try {
                try {
                    edit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.webProject);
                    edit.createModelRoot();
                }
                catch (Exception exception) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
            WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
    }

    public void testCreateModelRootint() {
        block8: {
            WebArtifactEdit edit = null;
            try {
                try {
                    edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
                    edit.createModelRoot(14);
                }
                catch (Exception exception) {
                    if (edit != null) {
                        edit.dispose();
                    }
                    WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
            WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
    }

    public void testWebArtifactEditComponentHandleboolean() {
        WebArtifactEdit edit = null;
        try {
            edit = new WebArtifactEdit(this.webProject, true);
            WebArtifactEditTest.assertNotNull((Object)edit);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetWebArtifactEditForReadComponentHandle() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
            WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetWebArtifactEditForWriteComponentHandle() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.webProject);
        }
        catch (Throwable throwable) {
            if (edit != null) {
                edit.dispose();
            }
            WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
            throw throwable;
        }
        if (edit != null) {
            edit.dispose();
        }
        WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
    }

    public void testGetWebArtifactEditForReadWorkbenchComponent() {
    }

    public void testGetWebArtifactEditForWriteWorkbenchComponent() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
            WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIsValidWebModule() {
        IVirtualComponent component = null;
        try {
            component = ComponentCore.createComponent((IProject)this.webProject);
            WebArtifactEdit.isValidWebModule((IVirtualComponent)component);
        }
        catch (UnresolveableURIException unresolveableURIException) {
            WebArtifactEditTest.fail();
        }
        ArtifactEdit.isValidEditableModule((IVirtualComponent)component);
        WebArtifactEditTest.assertTrue((boolean)ArtifactEdit.isValidEditableModule((IVirtualComponent)component));
    }

    public void testIsValidEditModule() {
        IVirtualComponent component = null;
        try {
            component = ComponentCore.createComponent((IProject)this.webProject);
            WebArtifactEdit.isValidWebModule((IVirtualComponent)component);
        }
        catch (UnresolveableURIException unresolveableURIException) {
            WebArtifactEditTest.fail();
        }
        ArtifactEdit.isValidEditableModule((IVirtualComponent)component);
        WebArtifactEditTest.assertTrue((boolean)ArtifactEdit.isValidEditableModule((IVirtualComponent)component));
    }

    public void testWebArtifactEditArtifactEditModel() {
        WebArtifactEdit edit = new WebArtifactEdit(this.getArtifactEditModelforRead());
        WebArtifactEditTest.assertNotNull((Object)edit);
        edit.dispose();
    }

    public void testWebArtifactEditModuleCoreNatureWorkbenchComponentboolean() {
        WebArtifactEdit edit = null;
        try {
            try {
                edit = new WebArtifactEdit(this.webProject, true);
                WebArtifactEditTest.assertNotNull((Object)edit);
            }
            catch (Exception exception) {
                WebArtifactEditTest.fail();
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetServletVersion() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
            WebArtifactEditTest.assertTrue((edit.getServletVersion() == 24 ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAddWebAppIfNecessary() {
    }

    public void testGetJSPVersion() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
            WebArtifactEditTest.assertTrue((edit.getJSPVersion() == 20 ? 1 : 0) != 0);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetDeploymentDescriptorPath() {
        WebArtifactEdit edit = null;
        try {
            edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
            edit.getDeploymentDescriptorPath();
            WebArtifactEditTest.assertNotNull((Object)edit.getDeploymentDescriptorPath());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetLibModules() {
        WebArtifactEdit edit = null;
        try {
            try {
                edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
                edit.getLibModules();
            }
            catch (Exception exception) {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAddLibModules() {
        WebArtifactEdit edit = null;
        try {
            try {
                edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
                ReferencedComponent refComp = ComponentcoreFactory.eINSTANCE.createReferencedComponent();
                edit.addLibModules(new ReferencedComponent[]{refComp});
            }
            catch (Exception exception) {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testGetServerContextRoot() {
        WebArtifactEdit edit = null;
        try {
            try {
                edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
                edit.getServerContextRoot();
            }
            catch (Exception exception) {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSetServerContextRoot() {
        WebArtifactEdit edit = null;
        try {
            try {
                edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)this.webProject);
                edit.setServerContextRoot(this.serverContextData);
            }
            catch (Exception exception) {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public ArtifactEditModel getArtifactEditModelforRead() {
        EMFWorkbenchContext context = new EMFWorkbenchContext(this.webProject);
        return new ArtifactEditModel(this.toString(), context, true, TestWorkspace.APP_CLIENT_MODULE_URI);
    }

    public WebArtifactEdit getArtifactEditForRead() {
        return new WebArtifactEdit(this.getArtifactEditModelforRead());
    }

    public void testCreateServlet() {
        block8: {
            WebArtifactEdit edit = null;
            try {
                try {
                    WebapplicationFactoryImpl factory = new WebapplicationFactoryImpl();
                    edit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)this.webProject);
                    WebApp webapp = edit.getWebApp();
                    Servlet servlet = factory.createServlet();
                    ServletType servletType = factory.createServletType();
                    servlet.setWebType((WebType)servletType);
                    servlet.setServletName("servletDescriptor._name");
                    servletType.setClassName("servletDescriptor._className");
                    servlet.setDisplayName("servletDescriptor._displayName");
                    webapp.getServlets().add((Object)servlet);
                    webapp.setDescription("test");
                    edit.save((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (edit != null) {
                        edit.dispose();
                    }
                    WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (edit != null) {
                    edit.dispose();
                }
                WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
                throw throwable;
            }
            if (edit != null) {
                edit.dispose();
            }
            WebArtifactEditTest.assertTrue((edit != null ? 1 : 0) != 0);
        }
    }
}

