/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class DeleteProjectTest
extends TestCase {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite(DeleteProjectTest.class);
        return suite;
    }

    private static void createProjectContent(IFacetedProject facetedProject) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)facetedProject.getProject());
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        IPackageFragment fragment = root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
        DeleteProjectTest.createSessionBean(fragment);
        DeleteProjectTest.createSessionBeanLocal(fragment);
        DeleteProjectTest.createBeanWithName(fragment);
    }

    private static void createBeanWithName(IPackageFragment fragment) throws JavaModelException {
        String content = String.format("package com.sap;import javax.ejb.Stateless;@Stateless(name=\"%s\") public class BeanWithName implements SessionBeanLocal {}", "beanWithName");
        fragment.createCompilationUnit("BeanWithName.java", content, true, null);
    }

    private static void createSessionBeanLocal(IPackageFragment fragment) throws JavaModelException {
        fragment.createCompilationUnit("SessionBeanLocal.java", "package com.sap;import javax.ejb.Local;@Local public interface SessionBeanLocal {}", true, null);
    }

    private static void createSessionBean(IPackageFragment fragment) throws JavaModelException {
        fragment.createCompilationUnit("SessionBean.java", "package com.sap;import javax.ejb.Stateless;@Stateless public class SessionBean implements SessionBeanLocal {}", true, null);
    }

    public void testDeleteProjectSameProvider() throws Exception {
        IProject project = ProjectUtil.createEJBProject(String.valueOf(DeleteProjectTest.class.getSimpleName()) + "testDeleteProjectSameProvider", null, 30, true);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        DeleteProjectTest.createProjectContent(facetedProject);
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
        EJBJar firstModel = (EJBJar)provider.getModelObject();
        DeleteProjectTest.assertNotNull((Object)firstModel);
        DeleteProjectTest.assertEquals((Object)firstModel, (Object)provider.getModelObject());
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        provider.addListener((IModelProviderListener)listener);
        AbstractTest.deleteProject(facetedProject.getProject().getName());
        DeleteProjectTest.assertTrue((boolean)listener.waitForEvents());
        provider.removeListener((IModelProviderListener)listener);
        try {
            EJBJar cfr_ignored_0 = (EJBJar)provider.getModelObject();
            DeleteProjectTest.fail((String)"IllegalStateException expected because the project is deleted and can not be accessed.");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testProviderForNonExistingProject() {
        try {
            IProject nonExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("testProviderForNonExistingProject");
            DeleteProjectTest.assertFalse((boolean)nonExistingProject.exists());
            ModelProviderManager.getModelProvider((IProject)nonExistingProject);
            DeleteProjectTest.fail((String)"IllgalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testCloseProjectSameProvider() throws Exception {
        IProject project = ProjectUtil.createEJBProject(String.valueOf(DeleteProjectTest.class.getSimpleName()) + "testClose", null, 30, true);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        DeleteProjectTest.createProjectContent(facetedProject);
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
        EJBJar firstModel = (EJBJar)provider.getModelObject();
        DeleteProjectTest.assertNotNull((Object)firstModel);
        DeleteProjectTest.assertEquals((Object)firstModel, (Object)provider.getModelObject());
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        provider.addListener((IModelProviderListener)listener);
        AbstractTest.closeProject(facetedProject.getProject().getName());
        DeleteProjectTest.assertTrue((boolean)listener.waitForEvents());
        provider.removeListener((IModelProviderListener)listener);
        try {
            EJBJar cfr_ignored_0 = (EJBJar)provider.getModelObject();
            DeleteProjectTest.fail((String)"IllegalStateExceptino expected because the project is deleted and can not be accessed.");
        }
        catch (IllegalStateException illegalStateException) {}
    }
}

