/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import java.util.Collection;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.model.internal.Ejb3ModelProvider;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class Ejb3ModelProviderTest
extends TestCase {
    private static final String EAR_PROJECT_NAME = "earProject";
    private static final String EJB_PROJECT_NAME = "ejbProject";

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(Ejb3ModelProviderTest.class);
        Ejb3ModelProviderTest.setUpProject();
        return suite;
    }

    public static void setUpProject() throws Exception {
    }

    public void testModifyOnlyModelWithOperation() throws Exception {
        ProjectUtil.createEARProject(EAR_PROJECT_NAME);
        IProject project = ProjectUtil.createEJBProject(EJB_PROJECT_NAME, EAR_PROJECT_NAME, 30, true);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        final Ejb3ModelProvider modelProvider = new Ejb3ModelProvider(facetedProject.getProject());
        Ejb3ModelProviderTest.assertNotNull((Object)modelProvider.getModelObject());
        modelProvider.addListener((IModelProviderListener)listener);
        modelProvider.modify(new Runnable(){

            public void run() {
                EJBJar modelObject = (EJBJar)modelProvider.getModelObject();
                this.changeModelObject(modelObject);
            }

            private void changeModelObject(EJBJar modelObject) {
                Description description = JavaeeFactory.eINSTANCE.createDescription();
                modelObject.getDescriptions().add(description);
            }
        }, null);
        Ejb3ModelProviderTest.assertTrue((boolean)listener.waitForEvents());
        Collection<IModelProviderEvent> events = listener.getReceivedEvents();
        Ejb3ModelProviderTest.assertEquals((int)1, (int)events.size());
        modelProvider.removeListener((IModelProviderListener)listener);
    }
}

