/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangeListenerWithSemaphore
implements IResourceChangeListener {
    private final Semaphore s;
    private final Collection<IResourceDelta> deltas;
    private final int expectedEvents;
    private final List<IResourceChangeEvent> receivedEvents;

    public ChangeListenerWithSemaphore(int expectedEvents) throws InterruptedException {
        this.expectedEvents = expectedEvents;
        this.s = new Semaphore(1);
        this.s.acquire();
        this.deltas = Collections.synchronizedList(new LinkedList());
        this.receivedEvents = Collections.synchronizedList(new LinkedList());
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        this.receivedEvents.add(event);
        if (this.receivedEvents.size() > this.expectedEvents) {
            throw new IllegalStateException("The expected events were already reached");
        }
        try {
            try {
                this.deltas.add(event.getDelta());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (this.expectedEvents == this.receivedEvents.size()) {
                this.s.release();
            }
        }
    }

    public boolean waitForEvents() throws InterruptedException {
        return this.s.tryAcquire(5L, TimeUnit.SECONDS);
    }

    public synchronized Collection<IResourceDelta> getDeltas() {
        return this.deltas;
    }

    public synchronized int getEvents() {
        return this.receivedEvents.size();
    }

    public List<IResourceChangeEvent> getReceivedEvents() {
        return this.receivedEvents;
    }
}

