/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.layout.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class TestLayout
extends TestCase {
    private static final String EXTENSION_JAR = ".jar";
    private static final String EXTENSION_ZIP = ".zip";
    private static final String PROPERTY_BUNDLE_ID = "Bundle-SymbolicName";
    private static final String CONFIG = "config.properties";
    private static final String KEY_DFT_BIN_JAR = "default.binary.jar";
    private static final String KEY_DFT_SRC_JAR = "default.source.jar";
    private static final String KEY_DFT_BIN_ZIP = "default.binary.zip";
    private static final String KEY_DFT_SRC_ZIP = "default.source.zip";
    private Properties config;
    private List errors = new ArrayList();

    public static Test suite() {
        return new TestSuite(TestLayout.class);
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public void testBundleLayout() {
        String property = System.getProperty("org.eclipse.wtp.inputDir");
        TestLayout.assertNotNull((String)"Need to set inputDir for tests.", (Object)property);
        File inputdir = new File(property);
        TestLayout.assertTrue((String)("inputDir (" + property + ") must be an existing directory."), (inputdir.exists() && inputdir.isDirectory() ? 1 : 0) != 0);
        File[] children = inputdir.listFiles();
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            String id = this.getBundleId(child);
            if (id != null) {
                if (id.endsWith(".source") || id.endsWith(".infopop") || id.endsWith(".doc.user") || id.endsWith(".doc") || id.endsWith(".doc.isv") || id.endsWith(".doc.dev") || id.endsWith(".doc.api") || id.endsWith("standard.schemas") || id.endsWith(".branding")) {
                    this.processBundle(child, this.getExpected(id, true, child.getName().endsWith(EXTENSION_ZIP)));
                } else {
                    this.processBundle(child, this.getExpected(id, false, child.getName().endsWith(EXTENSION_ZIP)));
                }
            }
            ++i;
        }
        if (this.errors.size() > 0) {
            Iterator iter = this.errors.iterator();
            while (iter.hasNext()) {
                System.err.println(iter.next());
            }
            TestLayout.fail((String)"Errors in bundle layout. Check error log for details.");
        }
    }

    private Set getExpected(String id, boolean source, boolean zip) {
        String line;
        block20: {
            if (this.config == null) {
                this.config = new Properties();
                InputStream input = null;
                try {
                    try {
                        input = ((Object)((Object)this)).getClass().getResourceAsStream(CONFIG);
                        TestLayout.assertNotNull((String)"Unable to load configuration file.", (Object)input);
                        this.config.load(input);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        TestLayout.fail((String)e.getMessage());
                        try {
                            if (input != null) {
                                input.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException) {}
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((line = this.config.getProperty(id)) == null) {
            if (source) {
                line = zip ? this.config.getProperty(KEY_DFT_SRC_ZIP) : this.config.getProperty(KEY_DFT_SRC_JAR);
            } else {
                String string = line = zip ? this.config.getProperty(KEY_DFT_BIN_ZIP) : this.config.getProperty(KEY_DFT_BIN_JAR);
            }
        }
        if (line == null) {
            TestLayout.fail((String)("Unable to load settings for: " + id));
        }
        HashSet<String> result = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result;
    }

    private void processBundle(File file, Set expected) {
        if (file.isDirectory()) {
            String[] array = expected.toArray(new String[expected.size()]);
            this.processDir("", file, array);
            int i = 0;
            while (i < array.length) {
                if (array[i] != null) {
                    this.addError("Missing pattern: " + array[i] + " in dir: " + file.getAbsolutePath());
                }
                ++i;
            }
        } else {
            this.processArchive(file, expected.toArray(new String[expected.size()]));
        }
    }

    private void processArchive(File file, String[] expected) {
        block22: {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(file, 1);
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String name = entry.getName();
                        int i = 0;
                        while (i < expected.length) {
                            String pattern = expected[i];
                            if (pattern != null) {
                                try {
                                    if (name.matches(pattern)) {
                                        expected[i] = null;
                                    }
                                }
                                catch (PatternSyntaxException ex) {
                                    ex.printStackTrace();
                                    TestLayout.fail((String)ex.getMessage());
                                }
                            }
                            ++i;
                        }
                    }
                    int i = 0;
                    while (i < expected.length) {
                        if (expected[i] != null) {
                            this.addError("Missing pattern: " + expected[i] + " in file: " + file.getAbsolutePath());
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    TestLayout.fail((String)e.getMessage());
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processDir(String root, File dir, String[] expected) {
        File[] children = dir.listFiles();
        int index = 0;
        while (index < children.length) {
            String name;
            File child = children[index];
            String string = name = root.length() == 0 ? child.getName() : String.valueOf(root) + '/' + child.getName();
            if (child.isDirectory()) {
                this.processDir(name, child, expected);
            } else {
                int i = 0;
                while (i < expected.length) {
                    String pattern = expected[i];
                    if (pattern != null) {
                        try {
                            if (name.matches(pattern)) {
                                expected[i] = null;
                            }
                        }
                        catch (PatternSyntaxException ex) {
                            ex.printStackTrace();
                            this.addError(ex.getMessage());
                        }
                    }
                    ++i;
                }
            }
            ++index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBundleIdFromManifest(InputStream input, String path) {
        String id = null;
        try {
            Map attributes = ManifestElement.parseBundleManifest((InputStream)input, null);
            id = (String)attributes.get(PROPERTY_BUNDLE_ID);
            if (id == null || id.length() == 0) {
                this.addError("BundleSymbolicName header not set in manifest for bundle: " + path);
            } else {
                int pos = id.indexOf(59);
                if (pos > 0) {
                    id = id.substring(0, pos);
                }
            }
        }
        catch (BundleException e) {
            e.printStackTrace();
            this.addError(e.getMessage());
            if (input == null) return id;
            try {
                input.close();
                return id;
            }
            catch (IOException iOException) {}
            return id;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                this.addError(e.getMessage());
                if (input == null) return id;
            }
            catch (Throwable throwable) {
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
                return id;
            }
            catch (IOException iOException) {}
            return id;
        }
        if (input == null) return id;
        try {
            input.close();
            return id;
        }
        catch (IOException iOException) {}
        return id;
    }

    private String getBundleId(File file) {
        String id = null;
        if (file.isDirectory()) {
            id = this.getBundleIdFromDir(file);
        } else if (file.getName().toLowerCase().endsWith(EXTENSION_ZIP)) {
            id = this.getBundleIdFromZIP(file);
        } else if (file.getName().toLowerCase().endsWith(EXTENSION_JAR)) {
            id = this.getBundleIdFromJAR(file);
        }
        return id;
    }

    /*
     * Exception decompiling
     */
    private String getBundleIdFromZIP(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getBundleIdFromDir(File dir) {
        String id = null;
        File manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        if (!manifestFile.exists() || !manifestFile.isFile()) {
            this.addError("Bundle manifest (MANIFEST.MF) not found at: " + manifestFile.getAbsolutePath());
        } else {
            try {
                id = this.getBundleIdFromManifest(new FileInputStream(manifestFile), manifestFile.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.addError(e.getMessage());
            }
        }
        return id;
    }

    /*
     * Loose catch block
     */
    private String getBundleIdFromJAR(File file) {
        String string;
        JarFile jar;
        InputStream input;
        block28: {
            JarEntry entry;
            block26: {
                block27: {
                    input = null;
                    jar = null;
                    jar = new JarFile(file, false, 1);
                    entry = jar.getJarEntry("META-INF/MANIFEST.MF");
                    if (entry != null) break block26;
                    this.addError("Bundle does not contain a MANIFEST.MF file: " + file.getAbsolutePath());
                    if (input == null) break block27;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
            input = jar.getInputStream(entry);
            string = this.getBundleIdFromManifest(input, file.getAbsolutePath());
            if (input == null) break block28;
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (IOException e) {
            block29: {
                try {
                    e.printStackTrace();
                    this.addError(e.getMessage());
                    if (input == null) break block29;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

