/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ManifestFileCreationAction;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class WebFragmentFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IDataModel model = (IDataModel)config;
            WtpUtils.addNatures((IProject)project);
            IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
            c.create(0, null);
            IVirtualFolder jsrc = c.getRootFolder();
            IJavaProject jproj = JavaCore.create((IProject)project);
            IClasspathEntry[] cp = jproj.getRawClasspath();
            int i = 0;
            while (i < cp.length) {
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3) {
                    IPath path = cpe.getPath().removeFirstSegments(1);
                    if (path.isEmpty()) {
                        path = new Path("/");
                    }
                    jsrc.createLink(path, 0, null);
                }
                ++i;
            }
            IVirtualFolder root = c.getRootFolder();
            Object container = null;
            container = root.getProjectRelativePath().segmentCount() == 0 ? project : root.getUnderlyingFolder();
            try {
                if (container != null) {
                    this.createWebFragmentFile(project, fv, (IContainer)container, monitor);
                    this.createManifest(project, (IContainer)container, monitor);
                }
            }
            catch (InvocationTargetException e) {
                J2EEPlugin.logError((Throwable)e);
            }
            catch (InterruptedException e) {
                J2EEPlugin.logError((Throwable)e);
            }
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            try {
                ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
            }
            catch (ExecutionException e) {
                WebPlugin.logError(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void createWebFragmentFile(IProject project, IProjectFacetVersion fv, IContainer aFolder, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IFile file = aFolder.getFile((IPath)new Path("META-INF/web-fragment.xml"));
        if (file.exists()) {
            return;
        }
        try {
            WebFragmentFacetInstallDelegate.createWebFragmentFile(file, project);
        }
        catch (CoreException e) {
            J2EEPlugin.logError((CoreException)e);
        }
        catch (IOException e) {
            J2EEPlugin.logError((Throwable)e);
        }
    }

    public static void createWebFragmentFile(IFile file, IProject project) throws CoreException, IOException {
        WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(file);
        String projectNamewithoutSpecialChars = WebFragmentFacetInstallDelegate.getNameWithoutSpecialCharacters(project.getName());
        String webFragXmlContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<web-fragment id=\"WebFragment_ID\" version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd\">\n<display-name>" + XMLWriter.getEscaped((String)project.getName()) + "</display-name> \n <name>" + XMLWriter.getEscaped((String)projectNamewithoutSpecialChars) + "</name> \n </web-fragment>";
        out.write(webFragXmlContents.getBytes("UTF-8"));
        out.close();
    }

    protected void createManifest(IProject project, IContainer aFolder, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IFile file = aFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (file.exists()) {
            return;
        }
        try {
            ManifestFileCreationAction.createManifestFile((IFile)file, (IProject)project);
        }
        catch (CoreException e) {
            J2EEPlugin.logError((CoreException)e);
        }
        catch (IOException e) {
            J2EEPlugin.logError((Throwable)e);
        }
    }

    private static String getNameWithoutSpecialCharacters(String projectName) {
        String result = projectName;
        Pattern p = Pattern.compile("($|_|\\p{L})(\\p{L}|\\p{Nd}|_|$)*");
        int curLength = 1;
        while (curLength <= result.length()) {
            if (!p.matcher(result.substring(0, curLength)).matches()) {
                result = result.replace(result.charAt(curLength - 1 < 0 ? curLength : curLength - 1), '_');
            }
            ++curLength;
        }
        return result;
    }
}

