/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.preferences.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.preferences.HTMLUIPreferenceNames;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposoalCatigoriesConfigurationRegistry;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.sse.ui.preferences.CodeAssistCyclingConfigurationBlock;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationWriter;

public class HTMLContentAssistPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    private static final String HTML_CONTENT_TYPE_ID = "org.eclipse.wst.html.core.htmlsource";
    private Button fAutoPropose;
    private Label fAutoProposeLabel;
    private Text fAutoProposeText;
    private CodeAssistCyclingConfigurationBlock fConfigurationBlock;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        this.createContentsForAutoActivationGroup(composite);
        this.createContentsForCyclingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void performDefaults() {
        this.performDefaultsForAutoActivationGroup();
        this.performDefaultsForCyclingGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    protected void initializeValues() {
        this.initializeValuesForAutoActivationGroup();
        this.initializeValuesForCyclingGroup();
    }

    protected void storeValues() {
        this.storeValuesForAutoActivationGroup();
        this.storeValuesForCyclingGroup();
    }

    protected void enableValues() {
        if (this.fAutoPropose != null) {
            if (this.fAutoPropose.getSelection()) {
                this.fAutoProposeLabel.setEnabled(true);
                this.fAutoProposeText.setEnabled(true);
            } else {
                this.fAutoProposeLabel.setEnabled(false);
                this.fAutoProposeText.setEnabled(false);
            }
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return HTMLUIPlugin.getDefault().getPreferenceStore();
    }

    private void createContentsForAutoActivationGroup(Composite parent) {
        Group contentAssistGroup = this.createGroup(parent, 2);
        contentAssistGroup.setText(HTMLUIMessages.Auto_Activation_UI_);
        this.fAutoPropose = this.createCheckBox((Composite)contentAssistGroup, HTMLUIMessages.Automatically_make_suggest_UI_);
        ((GridData)this.fAutoPropose.getLayoutData()).horizontalSpan = 2;
        this.fAutoPropose.addSelectionListener((SelectionListener)this);
        this.fAutoProposeLabel = this.createLabel((Composite)contentAssistGroup, HTMLUIMessages.Prompt_when_these_characte_UI_);
        this.fAutoProposeText = this.createTextField((Composite)contentAssistGroup);
    }

    private void createContentsForCyclingGroup(Composite parent) {
        ICompletionProposalCategoriesConfigurationWriter configurationWriter = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getWritableConfiguration(HTML_CONTENT_TYPE_ID);
        if (configurationWriter != null) {
            this.fConfigurationBlock = new CodeAssistCyclingConfigurationBlock(HTML_CONTENT_TYPE_ID, configurationWriter);
            this.fConfigurationBlock.createContents(parent, HTMLUIMessages.Cycling_UI_);
        } else {
            Logger.log((int)4, (String)"There should be an ICompletionProposalCategoriesConfigurationWriter specified for the HTML content type, but can't fine it, thus can't create user preference block for editing proposal categories preferences.");
        }
    }

    private void storeValuesForAutoActivationGroup() {
        this.getPreferenceStore().setValue(HTMLUIPreferenceNames.AUTO_PROPOSE, this.fAutoPropose.getSelection());
        this.getPreferenceStore().setValue(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE, this.fAutoProposeText.getText());
    }

    private void storeValuesForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.storeValues();
        }
    }

    private void initializeValuesForAutoActivationGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getBoolean(HTMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getString(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE));
    }

    private void initializeValuesForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.initializeValues();
        }
    }

    private void performDefaultsForAutoActivationGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getDefaultBoolean(HTMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getDefaultString(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE));
    }

    private void performDefaultsForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }
}

