/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.BuildPathsPropertyPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstall2;
import org.eclipse.wst.jsdt.launching.JavaRuntime;

public class ComplianceConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_LOCAL_VARIABLE_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.debug.localVariable");
    private static final OptionsConfigurationBlock.Key PREF_LINE_NUMBER_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber");
    private static final OptionsConfigurationBlock.Key PREF_SOURCE_FILE_ATTR = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_UNUSED_LOCAL = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.codegen.unusedLocal");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_TARGET_PLATFORM = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform");
    private static final OptionsConfigurationBlock.Key PREF_CODEGEN_INLINE_JSR_BYTECODE = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.codegen.inlineJsrBytecode");
    private static final OptionsConfigurationBlock.Key PREF_SOURCE_COMPATIBILITY = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.source");
    private static final OptionsConfigurationBlock.Key PREF_COMPLIANCE = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.compliance");
    private static final OptionsConfigurationBlock.Key PREF_PB_ASSERT_AS_IDENTIFIER = ComplianceConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier");
    private static final OptionsConfigurationBlock.Key INTR_DEFAULT_COMPLIANCE = ComplianceConfigurationBlock.getJDTUIKey("internal.default.compliance");
    private static final String VERSION_1_1 = "1.1";
    private static final String VERSION_1_2 = "1.2";
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String VERSION_1_5 = "1.5";
    private static final String VERSION_1_6 = "1.6";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DEFAULT_CONF = "default";
    private static final String USER_CONF = "user";
    private ArrayList fComplianceControls = new ArrayList();
    private String[] fRememberedUserCompliance;
    private static final int IDX_ASSERT_AS_IDENTIFIER = 0;
    private static final int IDX_ENUM_AS_IDENTIFIER = 1;
    private static final int IDX_SOURCE_COMPATIBILITY = 2;
    private static final int IDX_CODEGEN_TARGET_PLATFORM = 3;
    private static final int IDX_COMPLIANCE = 4;
    private static final int IDX_INLINE_JSR_BYTECODE = 5;
    private IStatus fComplianceStatus = new StatusInfo();
    private Link fJRE50InfoText;
    private Composite fControlsComposite;
    private ControlEnableState fBlockEnableState = null;

    public ComplianceConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ComplianceConfigurationBlock.getKeys(), container);
        this.fRememberedUserCompliance = new String[]{this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER), this.getValue(PREF_SOURCE_COMPATIBILITY), this.getValue(PREF_CODEGEN_TARGET_PLATFORM), this.getValue(PREF_COMPLIANCE), this.getValue(PREF_CODEGEN_INLINE_JSR_BYTECODE)};
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_LOCAL_VARIABLE_ATTR, PREF_LINE_NUMBER_ATTR, PREF_SOURCE_FILE_ATTR, PREF_CODEGEN_UNUSED_LOCAL, PREF_CODEGEN_INLINE_JSR_BYTECODE, PREF_COMPLIANCE, PREF_SOURCE_COMPATIBILITY, PREF_CODEGEN_TARGET_PLATFORM, PREF_PB_ASSERT_AS_IDENTIFIER};
    }

    protected void settingsUpdated() {
        this.setValue(INTR_DEFAULT_COMPLIANCE, this.getCurrentCompliance());
        super.settingsUpdated();
    }

    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite complianceComposite = this.createComplianceTabContent(parent);
        this.validateSettings(null, null, null);
        return complianceComposite;
    }

    public void enablePreferenceContent(boolean enable) {
        if (this.fControlsComposite != null && !this.fControlsComposite.isDisposed()) {
            if (enable) {
                if (this.fBlockEnableState != null) {
                    this.fBlockEnableState.restore();
                    this.fBlockEnableState = null;
                }
            } else if (this.fBlockEnableState == null) {
                this.fBlockEnableState = ControlEnableState.disable((Control)this.fControlsComposite);
            }
        }
    }

    private Composite createComplianceTabContent(Composite folder) {
        String[] values3456 = new String[]{VERSION_1_4, VERSION_1_5};
        String[] values3456Labels = new String[]{PreferencesMessages.ComplianceConfigurationBlock_version14, PreferencesMessages.ComplianceConfigurationBlock_version15};
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fControlsComposite = new Composite(composite, 0);
        this.fControlsComposite.setFont(composite.getFont());
        this.fControlsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this.fControlsComposite.setLayout((Layout)layout);
        int nColumns = 3;
        layout = new GridLayout();
        layout.numColumns = nColumns;
        Group group = new Group(this.fControlsComposite, 0);
        group.setFont(this.fControlsComposite.getFont());
        group.setText(PreferencesMessages.ComplianceConfigurationBlock_compliance_group_label);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)layout);
        String label = PreferencesMessages.ComplianceConfigurationBlock_compiler_compliance_label;
        Combo combo = this.addComboBox((Composite)group, label, PREF_COMPLIANCE, values3456, values3456Labels, 0);
        combo.setEnabled(false);
        return sc1;
    }

    protected final void openBuildPathPropertyPage() {
        if (this.getPreferenceContainer() != null) {
            HashMap<Object, IIncludePathEntry> data = new HashMap<Object, IIncludePathEntry>();
            data.put(BuildPathsPropertyPage.DATA_REVEAL_ENTRY, JavaRuntime.getDefaultJREContainerEntry());
            this.getPreferenceContainer().openPage("org.eclipse.wst.jsdt.ui.propertyPages.BuildPathsPropertyPage", data);
        }
        this.validateJRE50Status();
    }

    protected final void openJREInstallPreferencePage() {
        String jreID = "org.eclipse.wst.jsdt.debug.ui.preferences.VMPreferencePage";
        if (this.fProject == null && this.getPreferenceContainer() != null) {
            this.getPreferenceContainer().openPage(jreID, null);
        } else {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)jreID, (String[])new String[]{jreID}, null).open();
        }
        this.validateJRE50Status();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            if (INTR_DEFAULT_COMPLIANCE.equals(changedKey)) {
                this.updateComplianceEnableState();
                this.updateComplianceDefaultSettings(true, null);
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_COMPLIANCE.equals(changedKey)) {
                this.updateComplianceEnableState();
                this.fComplianceStatus = this.validateCompliance();
                this.validateJRE50Status();
            } else if (PREF_SOURCE_COMPATIBILITY.equals(changedKey)) {
                this.updateAssertEnumAsIdentifierEnableState();
                this.fComplianceStatus = this.validateCompliance();
            } else {
                if (!PREF_CODEGEN_TARGET_PLATFORM.equals(changedKey)) return;
                this.updateInlineJSREnableState();
                this.fComplianceStatus = this.validateCompliance();
            }
        } else {
            this.fComplianceStatus = this.validateCompliance();
        }
        this.fContext.statusChanged(this.fComplianceStatus);
    }

    private void validateJRE50Status() {
        if (this.fJRE50InfoText != null && !this.fJRE50InfoText.isDisposed()) {
            String compilerCompliance;
            boolean isVisible = false;
            String compliance = this.getStoredValue(PREF_COMPLIANCE);
            IVMInstall install = null;
            if (this.fProject != null) {
                try {
                    install = JavaRuntime.getVMInstall((IJavaScriptProject)JavaScriptCore.create((IProject)this.fProject));
                }
                catch (CoreException e) {
                    JavaScriptPlugin.log(e);
                }
            } else {
                install = JavaRuntime.getDefaultVMInstall();
            }
            if (install instanceof IVMInstall2 && JavaModelUtil.isVersionLessThan(compilerCompliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)install, compliance), compliance)) {
                Object[] args = new String[]{this.getVersionLabel(compliance), this.getVersionLabel(compilerCompliance)};
                if (this.fProject == null) {
                    this.fJRE50InfoText.setText(Messages.format(PreferencesMessages.ComplianceConfigurationBlock_jrecompliance_info, args));
                } else {
                    this.fJRE50InfoText.setText(Messages.format(PreferencesMessages.ComplianceConfigurationBlock_jrecompliance_info_project, args));
                }
                isVisible = true;
            }
            this.fJRE50InfoText.setVisible(isVisible);
        }
    }

    private String getVersionLabel(String version) {
        if (JavaModelUtil.isVersionLessThan(version, VERSION_1_5)) {
            return version;
        }
        if (VERSION_1_5.equals(version)) {
            return PreferencesMessages.ComplianceConfigurationBlock_version15;
        }
        return PreferencesMessages.ComplianceConfigurationBlock_version16;
    }

    private IStatus validateCompliance() {
        StatusInfo status = new StatusInfo();
        String compliance = this.getValue(PREF_COMPLIANCE);
        String source = this.getValue(PREF_SOURCE_COMPATIBILITY);
        String target = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
        if (JavaModelUtil.isVersionLessThan(compliance, source)) {
            status.setError(PreferencesMessages.ComplianceConfigurationBlock_src_greater_compliance);
            return status;
        }
        if (JavaModelUtil.isVersionLessThan(compliance, target)) {
            status.setError(PreferencesMessages.ComplianceConfigurationBlock_classfile_greater_compliance);
            return status;
        }
        if (!VERSION_1_3.equals(source) && JavaModelUtil.isVersionLessThan(target, source)) {
            status.setError(PreferencesMessages.ComplianceConfigurationBlock_classfile_greater_source);
            return status;
        }
        return status;
    }

    public void useProjectSpecificSettings(boolean enable) {
        super.useProjectSpecificSettings(enable);
        this.validateJRE50Status();
    }

    private void updateComplianceEnableState() {
        boolean enabled = this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF);
        int i = this.fComplianceControls.size() - 1;
        while (i >= 0) {
            Control curr = (Control)this.fComplianceControls.get(i);
            curr.setEnabled(enabled);
            --i;
        }
    }

    private void updateAssertEnumAsIdentifierEnableState() {
        if (this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF)) {
            String compatibility = this.getValue(PREF_SOURCE_COMPATIBILITY);
            boolean isLessThan14 = VERSION_1_3.equals(compatibility);
            this.updateRememberedComplianceOption(PREF_PB_ASSERT_AS_IDENTIFIER, 0, isLessThan14);
        }
    }

    private void updateRememberedComplianceOption(OptionsConfigurationBlock.Key prefKey, int idx, boolean enabled) {
        Combo combo = this.getComboBox(prefKey);
        combo.setEnabled(enabled);
        if (!enabled) {
            String val = this.getValue(prefKey);
            if (!ERROR.equals(val)) {
                this.setValue(prefKey, ERROR);
                this.updateCombo(combo);
                this.fRememberedUserCompliance[idx] = val;
            }
        } else {
            String val = this.fRememberedUserCompliance[idx];
            if (!ERROR.equals(val)) {
                this.setValue(prefKey, val);
                this.updateCombo(combo);
            }
        }
    }

    private void updateInlineJSREnableState() {
        String target = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
        boolean enabled = JavaModelUtil.isVersionLessThan(target, VERSION_1_5);
        Button checkBox = this.getCheckBox(PREF_CODEGEN_INLINE_JSR_BYTECODE);
        checkBox.setEnabled(enabled);
        if (!enabled) {
            String val;
            this.fRememberedUserCompliance[5] = val = this.getValue(PREF_CODEGEN_INLINE_JSR_BYTECODE);
            if (!ENABLED.equals(val)) {
                this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, ENABLED);
                this.updateCheckBox(checkBox);
            }
        } else {
            String val = this.fRememberedUserCompliance[5];
            if (!ENABLED.equals(val)) {
                this.setValue(PREF_CODEGEN_INLINE_JSR_BYTECODE, val);
                this.updateCheckBox(checkBox);
            }
        }
    }

    private void updateComplianceDefaultSettings(boolean rememberOld, String oldComplianceLevel) {
        String target;
        String source;
        String assertAsId;
        boolean isDefault = this.checkValue(INTR_DEFAULT_COMPLIANCE, DEFAULT_CONF);
        String complianceLevel = this.getValue(PREF_COMPLIANCE);
        if (isDefault) {
            if (rememberOld) {
                if (oldComplianceLevel == null) {
                    oldComplianceLevel = complianceLevel;
                }
                this.fRememberedUserCompliance[0] = this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER);
                this.fRememberedUserCompliance[2] = this.getValue(PREF_SOURCE_COMPATIBILITY);
                this.fRememberedUserCompliance[3] = this.getValue(PREF_CODEGEN_TARGET_PLATFORM);
                this.fRememberedUserCompliance[4] = oldComplianceLevel;
            }
            if (VERSION_1_4.equals(complianceLevel)) {
                assertAsId = WARNING;
                source = VERSION_1_3;
                target = VERSION_1_2;
            } else if (VERSION_1_5.equals(complianceLevel)) {
                assertAsId = ERROR;
                source = VERSION_1_5;
                target = VERSION_1_5;
            } else if (VERSION_1_6.equals(complianceLevel)) {
                assertAsId = ERROR;
                source = VERSION_1_6;
                target = VERSION_1_6;
            } else {
                assertAsId = IGNORE;
                source = VERSION_1_3;
                target = VERSION_1_1;
            }
        } else if (rememberOld && complianceLevel.equals(this.fRememberedUserCompliance[4])) {
            assertAsId = this.fRememberedUserCompliance[0];
            source = this.fRememberedUserCompliance[2];
            target = this.fRememberedUserCompliance[3];
        } else {
            this.updateInlineJSREnableState();
            this.updateAssertEnumAsIdentifierEnableState();
            return;
        }
        this.setValue(PREF_PB_ASSERT_AS_IDENTIFIER, assertAsId);
        this.setValue(PREF_SOURCE_COMPATIBILITY, source);
        this.setValue(PREF_CODEGEN_TARGET_PLATFORM, target);
        this.updateControls();
        this.updateInlineJSREnableState();
        this.updateAssertEnumAsIdentifierEnableState();
    }

    private String getCurrentCompliance() {
        String complianceLevel = this.getValue(PREF_COMPLIANCE);
        if (VERSION_1_3.equals(complianceLevel) && IGNORE.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && VERSION_1_3.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_1.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_4.equals(complianceLevel) && WARNING.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && VERSION_1_3.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_2.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_5.equals(complianceLevel) && ERROR.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && VERSION_1_5.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_5.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_6.equals(complianceLevel) && ERROR.equals(this.getValue(PREF_PB_ASSERT_AS_IDENTIFIER)) && VERSION_1_6.equals(this.getValue(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_6.equals(this.getValue(PREF_CODEGEN_TARGET_PLATFORM))) {
            return DEFAULT_CONF;
        }
        return USER_CONF;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.ComplianceConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PreferencesMessages.ComplianceConfigurationBlock_needsfullbuild_message : PreferencesMessages.ComplianceConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    public boolean performOk() {
        this.setValue(INTR_DEFAULT_COMPLIANCE, null);
        return super.performOk();
    }

    public boolean performApply() {
        this.setValue(INTR_DEFAULT_COMPLIANCE, null);
        boolean result = super.performApply();
        this.setValue(INTR_DEFAULT_COMPLIANCE, this.getCurrentCompliance());
        return result;
    }
}

