/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Sequence;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaContainerWrapper;
import org.eclipse.jpt.db.internal.DTPSequenceWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPSchemaWrapper
extends DTPDatabaseObjectWrapper
implements Schema {
    private final org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema;
    private DTPTableWrapper[] tables;
    private DTPSequenceWrapper[] sequences;
    private static final String PERSISTENT_AND_VIEW_TABLES_ONLY = "supportPersistentAndViewTablesOnly";

    DTPSchemaWrapper(DTPSchemaContainerWrapper container, org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema) {
        super(container, dtpSchema);
        this.dtpSchema = dtpSchema;
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().schemaChanged(this);
    }

    @Override
    public String getName() {
        return this.dtpSchema.getName();
    }

    @Override
    public DTPSchemaContainerWrapper getContainer() {
        return (DTPSchemaContainerWrapper)this.getParent();
    }

    @Override
    public Iterable<Table> getTables() {
        return new ArrayIterable((Object[])this.getTableArray());
    }

    private Iterable<DTPTableWrapper> getTableWrappers() {
        return new ArrayIterable((Object[])this.getTableArray());
    }

    private synchronized DTPTableWrapper[] getTableArray() {
        if (this.tables == null) {
            this.tables = this.buildTableArray();
        }
        return this.tables;
    }

    private DTPTableWrapper[] buildTableArray() {
        List<org.eclipse.datatools.modelbase.sql.tables.Table> dtpTables = this.getDTPTables();
        Object[] result = new DTPTableWrapper[dtpTables.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPTableWrapper(this, dtpTables.get(i));
        }
        return (DTPTableWrapper[])ArrayTools.sort((Object[])result, (Comparator)DEFAULT_COMPARATOR);
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Table> getDTPTables() {
        List<org.eclipse.datatools.modelbase.sql.tables.Table> dtpTables = this.getDTPTables_();
        return this.hack() ? this.hack(dtpTables) : dtpTables;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Table> getDTPTables_() {
        return this.dtpSchema.getTables();
    }

    private boolean hack() {
        String hack;
        IProduct product = Platform.getProduct();
        String string = hack = product == null ? null : product.getProperty(PERSISTENT_AND_VIEW_TABLES_ONLY);
        return hack != null && hack.equals("true");
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Table> hack(List<org.eclipse.datatools.modelbase.sql.tables.Table> dtpTables) {
        ArrayList<org.eclipse.datatools.modelbase.sql.tables.Table> result = new ArrayList<org.eclipse.datatools.modelbase.sql.tables.Table>();
        for (org.eclipse.datatools.modelbase.sql.tables.Table dtpTable : dtpTables) {
            if (!this.hack(dtpTable)) continue;
            result.add(dtpTable);
        }
        return result;
    }

    private boolean hack(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        return SQLTablesPackage.eINSTANCE.getPersistentTable().isSuperTypeOf(dtpTable.eClass()) || SQLTablesPackage.eINSTANCE.getViewTable().isSuperTypeOf(dtpTable.eClass());
    }

    @Override
    public int getTablesSize() {
        return this.getTableArray().length;
    }

    DTPTableWrapper getTable(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        return this.wraps(dtpTable.getSchema()) ? this.getTable_(dtpTable) : this.getContainer().getTable(dtpTable);
    }

    DTPTableWrapper getTable_(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        DTPTableWrapper[] dTPTableWrapperArray = this.getTableArray();
        int n = dTPTableWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPTableWrapper table = dTPTableWrapperArray[n2];
            if (table.wraps(dtpTable)) {
                return table;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP table: " + dtpTable);
    }

    @Override
    public DTPTableWrapper getTableNamed(String name) {
        return this.selectDatabaseObjectNamed(this.getTableWrappers(), name);
    }

    @Override
    public Iterable<String> getSortedTableIdentifiers() {
        return new TransformationIterable(this.getTableWrappers(), IDENTIFIER_TRANSFORMER);
    }

    @Override
    public DTPTableWrapper getTableForIdentifier(String identifier) {
        return this.selectDatabaseObjectForIdentifier(this.getTableWrappers(), identifier);
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return new ArrayIterable((Object[])this.getSequenceArray());
    }

    private Iterable<DTPSequenceWrapper> getSequenceWrappers() {
        return new ArrayIterable((Object[])this.getSequenceArray());
    }

    private synchronized DTPSequenceWrapper[] getSequenceArray() {
        if (this.sequences == null) {
            this.sequences = this.buildSequenceArray();
        }
        return this.sequences;
    }

    private DTPSequenceWrapper[] buildSequenceArray() {
        List<org.eclipse.datatools.modelbase.sql.schema.Sequence> dtpSequences = this.getDTPSequences();
        Object[] result = new DTPSequenceWrapper[dtpSequences.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPSequenceWrapper(this, dtpSequences.get(i));
        }
        return (DTPSequenceWrapper[])ArrayTools.sort((Object[])result, (Comparator)DEFAULT_COMPARATOR);
    }

    private List<org.eclipse.datatools.modelbase.sql.schema.Sequence> getDTPSequences() {
        return this.dtpSchema.getSequences();
    }

    @Override
    public int getSequencesSize() {
        return this.getSequenceArray().length;
    }

    @Override
    public DTPSequenceWrapper getSequenceNamed(String name) {
        return this.selectDatabaseObjectNamed(this.getSequenceWrappers(), name);
    }

    @Override
    public Iterable<String> getSortedSequenceIdentifiers() {
        return new TransformationIterable(this.getSequenceWrappers(), IDENTIFIER_TRANSFORMER);
    }

    @Override
    public DTPSequenceWrapper getSequenceForIdentifier(String identifier) {
        return this.selectDatabaseObjectForIdentifier(this.getSequenceWrappers(), identifier);
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.schema.Schema schema) {
        return this.dtpSchema == schema;
    }

    DTPColumnWrapper getColumn(Column dtpColumn) {
        return this.wraps(dtpColumn.getTable().getSchema()) ? this.getColumn_(dtpColumn) : this.getContainer().getColumn(dtpColumn);
    }

    DTPColumnWrapper getColumn_(Column dtpColumn) {
        return this.getTable_(dtpColumn.getTable()).getColumn_(dtpColumn);
    }

    @Override
    synchronized void startListening() {
        if (this.sequences != null) {
            this.startSequences();
        }
        if (this.tables != null) {
            this.startTables();
        }
        super.startListening();
    }

    private void startSequences() {
        DTPSequenceWrapper[] dTPSequenceWrapperArray = this.sequences;
        int n = this.sequences.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSequenceWrapper sequence = dTPSequenceWrapperArray[n2];
            sequence.startListening();
            ++n2;
        }
    }

    private void startTables() {
        DTPTableWrapper[] dTPTableWrapperArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            DTPTableWrapper table = dTPTableWrapperArray[n2];
            table.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.sequences != null) {
            this.stopSequences();
        }
        if (this.tables != null) {
            this.stopTables();
        }
        super.stopListening();
    }

    private void stopSequences() {
        DTPSequenceWrapper[] dTPSequenceWrapperArray = this.sequences;
        int n = this.sequences.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSequenceWrapper sequence = dTPSequenceWrapperArray[n2];
            sequence.stopListening();
            ++n2;
        }
    }

    private void stopTables() {
        DTPTableWrapper[] dTPTableWrapperArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            DTPTableWrapper table = dTPTableWrapperArray[n2];
            table.stopListening();
            ++n2;
        }
    }

    @Override
    synchronized void clear() {
        if (this.sequences != null) {
            this.clearSequences();
        }
        if (this.tables != null) {
            this.clearTables();
        }
    }

    private void clearSequences() {
        this.stopSequences();
        DTPSequenceWrapper[] dTPSequenceWrapperArray = this.sequences;
        int n = this.sequences.length;
        int n2 = 0;
        while (n2 < n) {
            DTPSequenceWrapper sequence = dTPSequenceWrapperArray[n2];
            sequence.clear();
            ++n2;
        }
        this.sequences = null;
    }

    private void clearTables() {
        this.stopTables();
        DTPTableWrapper[] dTPTableWrapperArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            DTPTableWrapper table = dTPTableWrapperArray[n2];
            table.clear();
            ++n2;
        }
        this.tables = null;
    }
}

