/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jpt.db.internal.vendor.AbstractVendor;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.NoCatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.NonFoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.Vendor;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MySQL
extends AbstractVendor {
    private static final Vendor INSTANCE = new MySQL();
    private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[]{'_', '$'};
    private static final char BACKTICK = '`';

    static Vendor instance() {
        return INSTANCE;
    }

    private MySQL() {
    }

    @Override
    public String getDTPVendorName() {
        return "MySql";
    }

    @Override
    CatalogStrategy getCatalogStrategy() {
        return NoCatalogStrategy.instance();
    }

    @Override
    FoldingStrategy getFoldingStrategy() {
        return NonFoldingStrategy.instance();
    }

    @Override
    void addDefaultSchemaNamesTo(Database database, String userName, ArrayList<String> names) {
        names.add(database.getName());
    }

    @Override
    boolean characterIsRegularNameStart(char c) {
        return Character.isDigit(c) || super.characterIsRegularNameStart(c);
    }

    @Override
    char[] getExtendedRegularNameStartCharacters() {
        return EXTENDED_REGULAR_NAME_START_CHARACTERS;
    }

    @Override
    boolean identifierIsDelimited(String identifier) {
        return StringTools.stringIsDelimited((String)identifier, (char)'`') || super.identifierIsDelimited(identifier);
    }
}

